/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.deployer.helpers;

import java.util.Collections;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractParsingDeployer;
import org.jboss.deployers.spi.deployer.matchers.JarExtensionProvider;
import org.jboss.deployers.spi.deployer.matchers.NameIgnoreMechanism;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParsingDeployerWithOutput<T>
extends AbstractParsingDeployer
implements JarExtensionProvider {
    private Set<String> names;
    private String suffix;
    private String jarExtension;
    private String attachmentKey;
    private boolean includeDeploymentFile = false;
    private boolean buildManagedObject = false;

    public AbstractParsingDeployerWithOutput(Class<T> output) {
        if (output == null) {
            throw new IllegalArgumentException("Null output");
        }
        this.setOutput(output);
        this.setAttachmentKey(output.getName());
    }

    public Class<T> getOutput() {
        return super.getOutput();
    }

    public String getName() {
        if (this.names == null || this.names.isEmpty()) {
            return null;
        }
        if (this.names.size() > 1) {
            throw new IllegalArgumentException("Use getNames since more than one name is set: " + this.names);
        }
        return this.names.iterator().next();
    }

    public void setName(String name) {
        this.names = name != null ? Collections.singleton(name) : null;
    }

    public Set<String> getNames() {
        return this.names;
    }

    public void setNames(Set<String> names) {
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                if (name != null) continue;
                throw new IllegalArgumentException("Null name: " + names);
            }
        }
        this.names = names;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public String getJarExtension() {
        return this.jarExtension;
    }

    public void setJarExtension(String jarExtension) {
        this.jarExtension = jarExtension;
    }

    public boolean isIncludeDeploymentFile() {
        return this.includeDeploymentFile;
    }

    public void setIncludeDeploymentFile(boolean includeDeploymentFile) {
        this.includeDeploymentFile = includeDeploymentFile;
    }

    public boolean isBuildManagedObject() {
        return this.buildManagedObject;
    }

    public void setBuildManagedObject(boolean buildManagedObject) {
        this.buildManagedObject = buildManagedObject;
    }

    protected boolean allowsReparse() {
        return false;
    }

    private boolean hasSingleName() {
        return this.names == null || this.names.size() == 1;
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!this.accepts(unit)) {
            return;
        }
        if (this.hasSingleName()) {
            this.createMetaData(unit, this.getName(), this.suffix);
        } else {
            this.createMetaData(unit, this.names, this.suffix);
        }
    }

    protected boolean accepts(DeploymentUnit unit) throws DeploymentException {
        return true;
    }

    protected T getMetaData(DeploymentUnit unit, String key) {
        return (T)unit.getAttachment(key, this.getOutput());
    }

    protected String getAttachmentKey() {
        return this.attachmentKey;
    }

    public void setAttachmentKey(String attachmentKey) {
        this.attachmentKey = attachmentKey;
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        this.createMetaData(unit, name, suffix, this.getAttachmentKey());
    }

    protected void createMetaData(DeploymentUnit unit, Set<String> names, String suffix) throws DeploymentException {
        this.createMetaData(unit, names, suffix, this.getAttachmentKey());
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix, String key) throws DeploymentException {
        this.createMetaData(unit, Collections.singleton(name), suffix, key);
    }

    protected void createMetaData(DeploymentUnit unit, Set<String> names, String suffix, String key) throws DeploymentException {
        T result = this.getMetaData(unit, key);
        if (result != null && !this.allowsReparse()) {
            return;
        }
        try {
            result = suffix == null ? (this.hasSingleName() ? this.parse(unit, this.getName(), result) : this.parse(unit, names, result)) : (this.hasSingleName() ? this.parse(unit, this.getName(), suffix, result) : this.parse(unit, names, suffix, result));
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error creating managed object for " + unit.getName()), (Throwable)e);
        }
        if (result == null) {
            return;
        }
        unit.getTransientManagedObjects().addAttachment(key, result, this.getOutput());
    }

    protected boolean ignoreName(DeploymentUnit unit, String name) {
        NameIgnoreMechanism mechanism = (NameIgnoreMechanism)unit.getAttachment(NameIgnoreMechanism.class);
        return mechanism != null && mechanism.ignoreName(unit, name);
    }

    protected abstract T parse(DeploymentUnit var1, String var2, T var3) throws Exception;

    protected abstract T parse(DeploymentUnit var1, Set<String> var2, T var3) throws Exception;

    protected abstract T parse(DeploymentUnit var1, String var2, String var3, T var4) throws Exception;

    protected abstract T parse(DeploymentUnit var1, Set<String> var2, String var3, T var4) throws Exception;
}

