/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Element;

public class WebServiceContextProxy
implements WebServiceContext {
    private static ThreadLocal<WebServiceContext> msgContextAssoc = new ThreadLocal();
    private static final WebServiceContext NOOP = new DefaultDelagate();

    public static void associateMessageContext(WebServiceContext messageContext) {
        msgContextAssoc.set(messageContext);
    }

    public MessageContext getMessageContext() {
        return this.delegate().getMessageContext();
    }

    public Principal getUserPrincipal() {
        return this.delegate().getUserPrincipal();
    }

    public boolean isUserInRole(String string) {
        return this.delegate().isUserInRole(string);
    }

    public EndpointReference getEndpointReference(Element ... elements) {
        return this.delegate().getEndpointReference(elements);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> aClass, Element ... elements) {
        return (T)this.delegate().getEndpointReference(aClass, elements);
    }

    private WebServiceContext delegate() {
        return msgContextAssoc.get() != null ? msgContextAssoc.get() : NOOP;
    }

    private static final class DefaultDelagate
    implements WebServiceContext {
        private final RuntimeException EX = new IllegalStateException("WebServiceContext not available");

        private DefaultDelagate() {
        }

        public MessageContext getMessageContext() {
            throw this.EX;
        }

        public Principal getUserPrincipal() {
            throw this.EX;
        }

        public boolean isUserInRole(String string) {
            throw this.EX;
        }

        public EndpointReference getEndpointReference(Element ... elements) {
            throw this.EX;
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> aClass, Element ... elements) {
            throw this.EX;
        }
    }
}

