/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.legacy.write.VersionedInvalidateCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.BaseRpcInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.transaction.TransactionContext;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidationInterceptor
extends BaseRpcInterceptor {
    private long invalidations = 0L;
    protected Map<GlobalTransaction, List<WriteCommand>> txMods;
    protected boolean optimistic;
    private CommandsFactory commandsFactory;
    private boolean statsEnabled;

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    void initTxMap() {
        boolean bl = this.optimistic = this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
        if (this.optimistic) {
            this.txMods = new ConcurrentHashMap<GlobalTransaction, List<WriteCommand>>();
        }
        this.setStatisticsEnabled(this.configuration.getExposeManagementStatistics());
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getFqn(), null, command);
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        if (ctx.getTransaction() != null) {
            ctx.getTransactionContext().addLocalModification(command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getFqn(), null, command);
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getFqn(), null, command);
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getFqn(), null, command);
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getTo(), command.getFqn(), command);
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        return this.handleWriteMethod(ctx, command.getFqn(), null, command);
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            if (this.trace) {
                this.log.trace((Object)"Entering InvalidationInterceptor's prepare phase");
            }
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            TransactionContext transactionContext = ctx.getTransactionContext();
            if (transactionContext == null) {
                throw new IllegalStateException("cannot find transaction transactionContext for " + gtx);
            }
            if (transactionContext.hasModifications()) {
                List<WriteCommand> mods;
                if (transactionContext.hasLocalModifications()) {
                    mods = new ArrayList<WriteCommand>(command.getModifications());
                    mods.removeAll(transactionContext.getLocalModifications());
                } else {
                    mods = command.getModifications();
                }
                this.broadcastInvalidate(mods, tx, ctx);
            } else if (this.trace) {
                this.log.trace((Object)"Nothing to invalidate - no modifications in the transaction.");
            }
        }
        return retval;
    }

    @Override
    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        if (tx != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            TransactionContext transactionContext = ctx.getTransactionContext();
            if (transactionContext == null) {
                throw new IllegalStateException("cannot find transaction transactionContext for " + gtx);
            }
            if (transactionContext.hasModifications()) {
                ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>(transactionContext.getModifications());
                if (transactionContext.hasLocalModifications()) {
                    mods.removeAll(transactionContext.getLocalModifications());
                }
                this.txMods.put(gtx, mods);
            }
        }
        return retval;
    }

    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        if (tx != null && this.optimistic) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            List<WriteCommand> modifications = this.txMods.remove(gtx);
            this.broadcastInvalidate(modifications, tx, ctx);
            if (this.trace) {
                this.log.trace((Object)"Committing.  Broadcasting invalidations.");
            }
        }
        return retval;
    }

    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        if (tx != null && this.optimistic) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            this.txMods.remove(gtx);
            this.log.debug((Object)"Caught a rollback.  Clearing modification in txMods");
        }
        return retval;
    }

    private Object handleWriteMethod(InvocationContext ctx, Fqn targetFqn, Fqn from, VisitableCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        Transaction tx = ctx.getTransaction();
        Option optionOverride = ctx.getOptionOverrides();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Is a CRUD method");
        }
        HashSet<Fqn> fqns = new HashSet<Fqn>();
        if (from != null) {
            fqns.add(from);
        }
        fqns.add(targetFqn);
        if (!fqns.isEmpty()) {
            if (tx == null || !TransactionTable.isValid(tx)) {
                for (Fqn fqn : fqns) {
                    this.invalidateAcrossCluster(fqn, null, this.isSynchronous(optionOverride), ctx);
                }
            } else if (this.isLocalModeForced(ctx)) {
                ctx.getTransactionContext().addLocalModification((WriteCommand)command);
            }
        }
        return retval;
    }

    private void broadcastInvalidate(List<WriteCommand> modifications, Transaction tx, InvocationContext ctx) throws Throwable {
        if (ctx.getTransaction() != null && !this.isLocalModeForced(ctx)) {
            if (modifications == null || modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                this.log.debug((Object)"Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else {
                try {
                    TransactionWorkspace workspace = this.optimistic ? this.getWorkspace(ctx) : null;
                    for (Fqn fqn : filterVisitor.result) {
                        this.invalidateAcrossCluster(fqn, workspace, this.defaultSynchronous, ctx);
                    }
                }
                catch (Throwable t) {
                    this.log.warn((Object)"Unable to broadcast evicts as a part of the prepare phase.  Rolling back.", t);
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException se) {
                        throw new RuntimeException("setting tx rollback failed ", se);
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    protected void invalidateAcrossCluster(Fqn fqn, TransactionWorkspace workspace, boolean synchronous, InvocationContext ctx) throws Throwable {
        if (!this.isLocalModeForced(ctx)) {
            this.incrementInvalidations();
            InvalidateCommand command = this.commandsFactory.buildInvalidateCommand(fqn);
            DataVersion dataVersion = this.getNodeVersion(workspace, fqn);
            if (dataVersion != null) {
                ((VersionedInvalidateCommand)command).setDataVersion(dataVersion);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache [" + this.rpcManager.getLocalAddress() + "] replicating " + command));
            }
            this.replicateCall(ctx, command, synchronous, ctx.getOptionOverrides());
        }
    }

    private void incrementInvalidations() {
        if (this.getStatisticsEnabled()) {
            ++this.invalidations;
        }
    }

    protected DataVersion getNodeVersion(TransactionWorkspace w, Fqn f) {
        if (w == null) {
            return null;
        }
        WorkspaceNode wn = w.getNode(f);
        if (wn == null) {
            return null;
        }
        DataVersion v = wn.getVersion();
        if (wn.isVersioningImplicit()) {
            v = ((DefaultDataVersion)v).increment();
        }
        return v;
    }

    protected TransactionWorkspace getWorkspace(InvocationContext ctx) {
        OptimisticTransactionContext entry = (OptimisticTransactionContext)ctx.getTransactionContext();
        return entry.getTransactionWorkSpace();
    }

    @ManagedOperation
    public void resetStatistics() {
        this.invalidations = 0L;
    }

    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Invalidations", this.invalidations);
        return retval;
    }

    @ManagedAttribute
    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    @ManagedAttribute(description="number of invalidations")
    public long getInvalidations() {
        return this.invalidations;
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Fqn> result;
        public boolean containsPutForExternalRead;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Fqn>(maxSetSize);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.result.add(command.getFqn());
            return null;
        }

        public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
            this.containsPutForExternalRead = true;
            return null;
        }

        public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
            this.result.add(command.getFqn());
            return null;
        }

        public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
            this.result.add(command.getFqn());
            return null;
        }

        public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
            this.result.add(command.getFqn());
            return null;
        }

        public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
            this.result.add(command.getFqn());
            return null;
        }

        public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
            this.result.add(command.getFqn());
            Object le = command.getFqn().getLastElement();
            Fqn parent = command.getTo();
            this.result.add(Fqn.fromRelativeElements(parent, le));
            return null;
        }
    }
}

