/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.table.renderer;

import com.sun.faces.renderkit.RenderKitUtils;
import java.io.IOException;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.gui.table.renderer.AbstractRenderer;

public abstract class AbstractButtonRenderer
extends AbstractRenderer {
    private static final String[] ATTRIBUTES = new String[]{"accesskey", "alt", "dir", "lang", "onblur", "onchange", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onselect", "style", "tabindex", "title"};
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void decode(FacesContext context, UIComponent component) {
        this.validateParameters(context, component);
        if (AbstractButtonRenderer.wasClicked(context, component) && !AbstractButtonRenderer.isReset(component)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("This command resulted in form submission - ActionEvent queued. Finished decoding " + component.getClass().getSimpleName() + " component with id " + component.getId() + "."));
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        String type = AbstractButtonRenderer.getButtonType(component);
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component).getValue();
        if (value != null) {
            label = value.toString();
        }
        String imageSrc = (String)component.getAttributes().get("image");
        writer.startElement("input", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String clientId = component.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", (Object)"image", "type");
            writer.writeURIAttribute("src", (Object)AbstractButtonRenderer.src(context, imageSrc), "image");
            writer.writeAttribute("name", (Object)clientId, "clientId");
        } else {
            writer.writeAttribute("type", (Object)type, "type");
            writer.writeAttribute("name", (Object)clientId, "clientId");
            writer.writeAttribute("value", (Object)label, "value");
        }
        RenderKitUtils.renderPassThruAttributes((ResponseWriter)writer, (UIComponent)component, (String[])ATTRIBUTES);
        this.renderBooleanAttributes(writer, component);
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.validateParameters(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("input");
    }

    protected void renderBooleanAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        RenderKitUtils.renderXHTMLStyleBooleanAttributes((ResponseWriter)writer, (UIComponent)component);
    }

    private static String src(FacesContext context, String imageURI) {
        if (imageURI == null) {
            return "";
        }
        String u = context.getApplication().getViewHandler().getResourceURL(context, imageURI);
        return context.getExternalContext().encodeResourceURL(u);
    }

    private static boolean wasClicked(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.get(clientId) == null) {
            StringBuilder builder = new StringBuilder(clientId);
            String xValue = builder.append(".x").toString();
            builder.setLength(clientId.length());
            String yValue = builder.append(".y").toString();
            return requestParameterMap.get(xValue) != null && requestParameterMap.get(yValue) != null;
        }
        return true;
    }

    private static boolean isReset(UIComponent component) {
        return "reset".equals(component.getAttributes().get("type"));
    }

    private static String getButtonType(UIComponent component) {
        String type = (String)component.getAttributes().get("type");
        if (type == null || !"reset".equals(type) && !"submit".equals(type)) {
            type = "submit";
            component.getAttributes().put("type", type);
        }
        return type;
    }
}

