/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.webdav.lib.methods;

import hidden.org.apache.commons.httpclient.Header;
import hidden.org.apache.commons.httpclient.HttpConnection;
import hidden.org.apache.commons.httpclient.HttpException;
import hidden.org.apache.commons.httpclient.HttpState;
import hidden.org.apache.webdav.lib.methods.XMLResponseMethodBase;
import hidden.org.apache.webdav.lib.util.XMLPrinter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OptionsMethod
extends XMLResponseMethodBase {
    public static final String DAV_LEVEL1 = "1";
    public static final String DAV_LEVEL2 = "2";
    public static final String ADVANCED_COLLECTIONS = "3";
    public static final String DELTAV = "4";
    public static final String ACL = "5";
    public static final String DASL = "6";
    public static final int OPTIONS_WORKSPACE = 8;
    public static final int OPTIONS_VERSION_HISTORY = 9;
    private Vector davCapabilities = new Vector();
    private Vector methodsAllowed = new Vector();
    private int type = 0;
    private boolean hasXMLBody = false;

    public OptionsMethod() {
    }

    public OptionsMethod(String path) {
        super(path);
    }

    public OptionsMethod(String path, int type) {
        super(path);
        this.type = type;
    }

    public boolean isAllowed(String method) {
        this.checkUsed();
        return this.methodsAllowed.contains(method);
    }

    public Enumeration getAllowedMethods() {
        this.checkUsed();
        return this.methodsAllowed.elements();
    }

    public boolean isSupported(String capability) {
        this.checkUsed();
        return this.davCapabilities.contains(capability);
    }

    public Enumeration getDavCapabilities() {
        this.checkUsed();
        return this.davCapabilities.elements();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            if (this.getStatusLine().getStatusCode() == 200 && this.hasXMLBody) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void processResponseHeaders(HttpState state, HttpConnection conn) {
        Header allowHeader;
        Header davHeader = this.getResponseHeader("dav");
        if (davHeader != null) {
            String davHeaderValue = davHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(davHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String davCapability = tokenizer.nextToken().trim();
                this.davCapabilities.addElement(davCapability);
            }
        }
        if ((allowHeader = this.getResponseHeader("allow")) != null) {
            String allowHeaderValue = allowHeader.getValue();
            StringTokenizer tokenizer = new StringTokenizer(allowHeaderValue, ",");
            while (tokenizer.hasMoreElements()) {
                String methodAllowed = tokenizer.nextToken().trim().toUpperCase();
                this.methodsAllowed.addElement(methodAllowed);
            }
        }
        Header lengthHeader = this.getResponseHeader("content-length");
        Header typeHeader = this.getResponseHeader("content-type");
        if (lengthHeader != null && Integer.parseInt(lengthHeader.getValue()) > 0 || typeHeader != null && typeHeader.getValue().startsWith("text/xml")) {
            this.hasXMLBody = true;
        }
        super.processResponseHeaders(state, conn);
    }

    protected String generateRequestBody() {
        if (this.type != 0) {
            XMLPrinter printer = new XMLPrinter();
            printer.writeXMLHeader();
            printer.writeElement("D", "DAV:", "options", 0);
            if (this.type == 9) {
                printer.writeElement("D", "version-history-collection-set", 2);
            }
            if (this.type == 8) {
                printer.writeElement("D", "workspace-collection-set", 2);
            }
            printer.writeElement("D", "options", 1);
            return printer.toString();
        }
        return null;
    }

    public String getName() {
        return "OPTIONS";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.type != 0 && this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    public Enumeration getAllResponseURLs() {
        this.checkUsed();
        return this.getResponseURLs().elements();
    }

    public Enumeration getResponseProperties() {
        Vector result = new Vector();
        return (Enumeration)((Object)result);
    }

    protected Document parseResponseContent(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        int allLen = 0;
        byte[] chunk = new byte[4096];
        int chunkLen = is.read(chunk);
        ArrayList<Object> chunks = new ArrayList<Object>();
        while (chunkLen != -1) {
            chunks.add(new Integer(chunkLen));
            chunks.add(chunk);
            allLen += chunkLen;
            chunk = new byte[4096];
            chunkLen = is.read(chunk);
        }
        byte[] all = new byte[allLen];
        int ofs = 0;
        int max = chunks.size();
        for (int i = 0; i < max; i += 2) {
            chunkLen = (Integer)chunks.get(i);
            chunk = (byte[])chunks.get(i + 1);
            System.arraycopy(chunk, 0, all, ofs, chunkLen);
            ofs += chunkLen;
        }
        if (all.length == 0) {
            return null;
        }
        return builder.parse(new InputSource(new ByteArrayInputStream(all)));
    }
}

