/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.deployer.kernel;

import java.util.Set;
import org.jboss.beans.metadata.spi.NamedAliasMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.spi.deployment.KernelDeployment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasDeploymentDeployer
extends AbstractComponentDeployer<KernelDeployment, NamedAliasMetaData> {
    public AliasDeploymentDeployer() {
        this.setDeploymentVisitor(new KernelDeploymentVisitor());
        this.setComponentVisitor(new AliasMetaDataVisitor());
    }

    protected static void addAliasComponent(DeploymentUnit unit, NamedAliasMetaData alias) {
        DeploymentUnit component = unit.addComponent(alias.getAliasValue().toString());
        component.addAttachment(NamedAliasMetaData.class.getName(), (Object)alias);
    }

    protected static void removeAliasComponent(DeploymentUnit unit, NamedAliasMetaData alias) {
        unit.removeComponent(alias.getAliasValue().toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AliasMetaDataVisitor
    implements DeploymentVisitor<NamedAliasMetaData> {
        public Class<NamedAliasMetaData> getVisitorType() {
            return NamedAliasMetaData.class;
        }

        public void deploy(DeploymentUnit unit, NamedAliasMetaData deployment) throws DeploymentException {
            AliasDeploymentDeployer.addAliasComponent(unit, deployment);
        }

        public void undeploy(DeploymentUnit unit, NamedAliasMetaData deployment) {
            AliasDeploymentDeployer.removeAliasComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KernelDeploymentVisitor
    implements DeploymentVisitor<KernelDeployment> {
        public Class<KernelDeployment> getVisitorType() {
            return KernelDeployment.class;
        }

        public void deploy(DeploymentUnit unit, KernelDeployment deployment) throws DeploymentException {
            Set aliases = deployment.getAliases();
            if (aliases != null && !aliases.isEmpty()) {
                for (NamedAliasMetaData alias : aliases) {
                    AliasDeploymentDeployer.addAliasComponent(unit, alias);
                }
            }
        }

        public void undeploy(DeploymentUnit unit, KernelDeployment deployment) {
            Set aliases = deployment.getAliases();
            if (aliases != null && !aliases.isEmpty()) {
                for (NamedAliasMetaData alias : aliases) {
                    AliasDeploymentDeployer.removeAliasComponent(unit, alias);
                }
            }
        }
    }
}

