/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;
import org.jboss.logging.Logger;
import org.jboss.ws.core.EndpointMetadataProvider;
import org.jboss.ws.core.StubExt;
import org.jboss.ws.core.jaxws.client.ClientFeatureProcessor;
import org.jboss.ws.core.jaxws.client.ClientImpl;
import org.jboss.ws.core.jaxws.client.ClientProxy;
import org.jboss.ws.core.jaxws.client.DispatchImpl;
import org.jboss.ws.core.jaxws.client.ServiceObjectFactoryJAXWS;
import org.jboss.ws.core.jaxws.handler.HandlerResolverImpl;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.ws.core.jaxws.wsaddressing.NativeEndpointReference;
import org.jboss.ws.metadata.builder.jaxws.JAXWSClientMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSMetaDataBuilder;
import org.jboss.ws.metadata.umdm.ClientEndpointMetaData;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.wsf.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegateImpl
extends ServiceDelegate {
    private final Logger log = Logger.getLogger(ServiceDelegateImpl.class);
    private static final Object DEFAULT_EXECUTOR_LOCK = new Object();
    private static ExecutorService defaultExecutor = null;
    private ServiceMetaData serviceMetaData;
    private UnifiedServiceRefMetaData usRef;
    private HandlerResolver handlerResolver;
    private ExecutorService executor;
    private List<QName> annotatedPorts = new ArrayList<QName>();

    public ServiceDelegateImpl(URL wsdlURL, QName serviceName, Class serviceClass) {
        HandlerChain anHandlerChain;
        ResourceLoaderAdapter vfsRoot;
        this.usRef = ServiceObjectFactoryJAXWS.getServiceRefAssociation();
        ResourceLoaderAdapter resourceLoaderAdapter = vfsRoot = this.usRef != null ? (vfsRoot = this.usRef.getVfsRoot()) : new ResourceLoaderAdapter();
        if (wsdlURL != null && serviceClass != Service.class) {
            try {
                InputStream is = wsdlURL.openStream();
                is.close();
            }
            catch (IOException e) {
                this.log.warn((Object)("Cannot access wsdlURL: " + wsdlURL));
                wsdlURL = null;
            }
        }
        if (wsdlURL != null) {
            JAXWSClientMetaDataBuilder builder = new JAXWSClientMetaDataBuilder();
            this.serviceMetaData = builder.buildMetaData(serviceName, wsdlURL, (UnifiedVirtualFile)vfsRoot);
        } else {
            UnifiedMetaData wsMetaData = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
            this.serviceMetaData = new ServiceMetaData(wsMetaData, serviceName);
            wsMetaData.addService(this.serviceMetaData);
        }
        this.handlerResolver = new HandlerResolverImpl();
        String filename = null;
        if (this.usRef != null) {
            this.serviceMetaData.setServiceRefName(this.usRef.getServiceRefName());
            if (this.usRef.getHandlerChain() != null) {
                filename = this.usRef.getHandlerChain();
            }
        }
        if (serviceClass != null && serviceClass.getAnnotation(HandlerChain.class) != null && (anHandlerChain = serviceClass.getAnnotation(HandlerChain.class)) != null && anHandlerChain.file().length() > 0) {
            filename = anHandlerChain.file();
            try {
                new URL(filename);
            }
            catch (MalformedURLException ex) {
                filename = serviceClass.getPackage().getName().replace('.', '/') + "/" + filename;
            }
        }
        if (filename != null) {
            UnifiedHandlerChainsMetaData handlerChainsMetaData = JAXWSMetaDataBuilder.getHandlerChainsMetaData(serviceClass, filename);
            for (UnifiedHandlerChainMetaData UnifiedHandlerChainMetaData2 : handlerChainsMetaData.getHandlerChains()) {
                for (UnifiedHandlerMetaData uhmd : UnifiedHandlerChainMetaData2.getHandlers()) {
                    HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                    this.serviceMetaData.addHandler(hmd);
                }
            }
            ((HandlerResolverImpl)this.handlerResolver).initServiceHandlerChain(this.serviceMetaData);
        }
    }

    public <T> T getPort(QName portName, Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException("Service meta data not available");
        }
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() > 0) {
            throw new WebServiceException("Cannot get port meta data for: " + portName);
        }
        if (this.serviceMetaData.getEndpoints().size() == 0) {
            this.log.warn((Object)("Cannot get port meta data for: " + portName));
            QName portType = this.getPortTypeName(seiClass);
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, portType, EndpointMetaData.Type.JAXWS);
        }
        String seiClassName = seiClass.getName();
        epMetaData.setServiceEndpointInterfaceName(seiClassName);
        return this.getPortInternal(epMetaData, seiClass);
    }

    public <T> T getPort(Class<T> seiClass) {
        this.assertSEIConstraints(seiClass);
        if (this.serviceMetaData == null) {
            throw new WebServiceException("Service meta data not available");
        }
        String seiClassName = seiClass.getName();
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpointByServiceEndpointInterface(seiClassName);
        if (epMetaData == null && this.serviceMetaData.getEndpoints().size() == 1) {
            epMetaData = this.serviceMetaData.getEndpoints().get(0);
            epMetaData.setServiceEndpointInterfaceName(seiClassName);
        } else {
            QName portTypeName = this.getPortTypeName(seiClass);
            for (EndpointMetaData epmd : this.serviceMetaData.getEndpoints()) {
                if (!portTypeName.equals(epmd.getPortTypeName())) continue;
                epmd.setServiceEndpointInterfaceName(seiClass.getName());
                epMetaData = epmd;
                break;
            }
        }
        if (epMetaData == null) {
            throw new WebServiceException("Cannot get port meta data for: " + seiClassName);
        }
        return this.getPortInternal(epMetaData, seiClass);
    }

    private <T> QName getPortTypeName(Class<T> seiClass) {
        String nsURI;
        if (!seiClass.isAnnotationPresent(WebService.class)) {
            throw new IllegalArgumentException("Cannot find @WebService on: " + seiClass.getName());
        }
        WebService anWebService = seiClass.getAnnotation(WebService.class);
        String localPart = anWebService.name();
        if (localPart.length() == 0) {
            localPart = WSDLUtils.getJustClassName(seiClass);
        }
        if ((nsURI = anWebService.targetNamespace()).length() == 0) {
            nsURI = WSDLUtils.getTypeNamespace(seiClass);
        }
        QName portType = new QName(nsURI, localPart);
        return portType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getPortInternal(EndpointMetaData epMetaData, Class<T> seiClass) {
        QName portName = epMetaData.getPortName();
        if (!this.annotatedPorts.contains(portName)) {
            EndpointMetaData endpointMetaData = epMetaData;
            synchronized (endpointMetaData) {
                if (!this.annotatedPorts.contains(portName)) {
                    JAXWSClientMetaDataBuilder metaDataBuilder = new JAXWSClientMetaDataBuilder();
                    metaDataBuilder.rebuildEndpointMetaData(epMetaData, seiClass);
                    this.annotatedPorts.add(portName);
                }
            }
        }
        return this.createProxy(seiClass, epMetaData);
    }

    private void assertSEIConstraints(Class seiClass) {
        if (seiClass == null) {
            throw new IllegalArgumentException("Service endpoint interface cannot be null");
        }
        if (!seiClass.isAnnotationPresent(WebService.class)) {
            throw new WebServiceException("SEI is missing @WebService annotation: " + seiClass);
        }
    }

    public void addPort(QName portName, String bindingId, String epAddress) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            epMetaData = new ClientEndpointMetaData(this.serviceMetaData, portName, null, EndpointMetaData.Type.JAXWS);
            this.serviceMetaData.addEndpoint(epMetaData);
        }
        epMetaData.setBindingId(bindingId);
        epMetaData.setEndpointAddress(epAddress);
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        DispatchImpl<T> dispatch = new DispatchImpl<T>(executor, epMetaData, type, mode);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext jbc, Service.Mode mode) {
        ExecutorService executor = (ExecutorService)this.getExecutor();
        EndpointMetaData epMetaData = this.getEndpointMetaData(portName);
        DispatchImpl<Object> dispatch = new DispatchImpl<Object>(executor, epMetaData, jbc, mode);
        return dispatch;
    }

    private EndpointMetaData getEndpointMetaData(QName portName) {
        EndpointMetaData epMetaData = this.serviceMetaData.getEndpoint(portName);
        if (epMetaData == null) {
            throw new WebServiceException("Cannot find port: " + portName);
        }
        return epMetaData;
    }

    public QName getServiceName() {
        return this.serviceMetaData.getServiceName();
    }

    public Iterator<QName> getPorts() {
        ArrayList<QName> portNames = new ArrayList<QName>();
        for (EndpointMetaData epMetaData : this.serviceMetaData.getEndpoints()) {
            portNames.add(epMetaData.getPortName());
        }
        return portNames.iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this.serviceMetaData.getWsdlLocation();
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerResolver = handlerResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getDefaultExecutor() {
        if (defaultExecutor == null) {
            Object object = DEFAULT_EXECUTOR_LOCK;
            synchronized (object) {
                if (defaultExecutor == null) {
                    defaultExecutor = Executors.newCachedThreadPool();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"Created new defaultExecutor", new Throwable("Call Trace"));
                    }
                }
            }
        }
        return defaultExecutor;
    }

    public Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.getDefaultExecutor();
        }
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        if (!(executor instanceof ExecutorService)) {
            throw new IllegalArgumentException("Supported executors must implement " + ExecutorService.class.getName());
        }
        this.executor = (ExecutorService)executor;
    }

    private <T> T createProxy(Class<T> seiClass, EndpointMetaData epMetaData) throws WebServiceException {
        if (seiClass == null) {
            throw new IllegalArgumentException("SEI class cannot be null");
        }
        try {
            Object proxy;
            ExecutorService executor = (ExecutorService)this.getExecutor();
            ClientProxy handler = new ClientProxy(executor, new ClientImpl(epMetaData, this.handlerResolver));
            ClassLoader cl = epMetaData.getClassLoader();
            try {
                proxy = Proxy.newProxyInstance(cl, new Class[]{seiClass, BindingProvider.class, StubExt.class}, (InvocationHandler)handler);
            }
            catch (RuntimeException rte) {
                URL codeLocation = seiClass.getProtectionDomain().getCodeSource().getLocation();
                this.log.error((Object)("Cannot create proxy for SEI " + seiClass.getName() + " from: " + codeLocation));
                throw rte;
            }
            this.configureStub((StubExt)proxy);
            return (T)proxy;
        }
        catch (WebServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebServiceException("Cannot create proxy", (Throwable)ex);
        }
    }

    private void configureStub(StubExt stub) {
        EndpointMetaData epMetaData = stub.getEndpointMetaData();
        String seiName = epMetaData.getServiceEndpointInterfaceName();
        QName portName = epMetaData.getPortName();
        if (this.usRef == null) {
            this.log.debug((Object)("No port configuration for: " + portName));
            return;
        }
        String configFile = this.usRef.getConfigFile();
        String configName = this.usRef.getConfigName();
        UnifiedPortComponentRefMetaData pcref = this.usRef.getPortComponentRef(seiName, portName);
        if (pcref != null) {
            if (pcref.getConfigFile() != null) {
                configFile = pcref.getConfigFile();
            }
            if (pcref.getConfigName() != null) {
                configName = pcref.getConfigName();
            }
            BindingProvider bp = (BindingProvider)stub;
            Map reqCtx = bp.getRequestContext();
            for (UnifiedStubPropertyMetaData prop : pcref.getStubProperties()) {
                this.log.debug((Object)("Set stub property: " + prop));
                reqCtx.put(prop.getPropName(), prop.getPropValue());
            }
        }
        if (configName != null || configFile != null) {
            this.log.debug((Object)("Configure Stub: [configName=" + configName + ",configFile=" + configFile + "]"));
            stub.setConfigName(configName, configFile);
        }
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public <T> Dispatch<T> createDispatch(EndpointReference epr, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        QName portName = null;
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        portName = nepr.getEndpointName();
        if (this.getEndpointMetaData(portName) != null && nepr.getAddress() != null && nepr.getAddress().length() > 0) {
            this.getEndpointMetaData(portName).setEndpointAddress(nepr.getAddress());
        }
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode);
        this.initAddressingProperties((BindingProvider)dispatch, epr);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(EndpointReference epr, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        QName portName = null;
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        portName = nepr.getEndpointName();
        if (this.getEndpointMetaData(portName) != null && nepr.getAddress() != null && nepr.getAddress().length() > 0) {
            this.getEndpointMetaData(portName).setEndpointAddress(nepr.getAddress());
        }
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode);
        this.initAddressingProperties((BindingProvider)dispatch, epr);
        this.initWebserviceFeatures(dispatch, features);
        return dispatch;
    }

    public <T> T getPort(QName portName, Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(portName, sei);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    public <T> T getPort(EndpointReference epr, Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(sei);
        this.initAddressingProperties((BindingProvider)port, epr);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    public <T> T getPort(Class<T> sei, WebServiceFeature ... features) {
        T port = this.getPort(sei);
        this.initWebserviceFeatures(port, features);
        return port;
    }

    private <T> void initWebserviceFeatures(T stub, WebServiceFeature ... features) {
        if (features != null) {
            EndpointMetaData epMetaData = ((EndpointMetadataProvider)stub).getEndpointMetaData();
            for (WebServiceFeature feature : features) {
                ClientFeatureProcessor.processFeature(feature, epMetaData, stub);
            }
        }
    }

    private void initAddressingProperties(BindingProvider bindingProvider, EndpointReference epr) {
        Map reqContext = bindingProvider.getRequestContext();
        AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
        AddressingProperties addrProps = builder.newAddressingProperties();
        reqContext.put("javax.xml.ws.addressing.context.outbound", addrProps);
        NativeEndpointReference nepr = EndpointReferenceUtil.transform(NativeEndpointReference.class, epr);
        try {
            List<Element> w3cRefParams;
            if (nepr.getAddress() != null) {
                addrProps.setTo(builder.newURI(nepr.getAddress()));
            }
            if ((w3cRefParams = nepr.getReferenceParameters()) != null) {
                ReferenceParameters refParams = addrProps.getReferenceParameters();
                for (Element w3cRefParam : w3cRefParams) {
                    refParams.addElement(w3cRefParam);
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

