/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.jboss.ws.extensions.security.KeyResolver;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.ReferenceList;
import org.jboss.ws.extensions.security.element.SecurityProcess;
import org.jboss.ws.extensions.security.element.SecurityTokenReference;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.FailedCheckException;
import org.jboss.ws.extensions.security.exception.InvalidSecurityHeaderException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.EncryptionOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptedKey
implements SecurityProcess {
    private Document document;
    private SecretKey secretKey;
    private X509Token token;
    private ReferenceList list;
    private String wrapAlgorithm;
    private Element cachedElement;
    private String tokenRefType;
    private static HashMap<String, String> keyWrapAlgorithms = new HashMap(2);
    private static final String DEFAULT_ALGORITHM = "rsa_15";

    public EncryptedKey(Document document, SecretKey secretKey, X509Token token, String wrap, String tokenRefType) {
        this(document, secretKey, token, new ReferenceList(), wrap, tokenRefType);
    }

    public EncryptedKey(Document document, SecretKey secretKey, X509Token token, ReferenceList list, String wrap, String tokenRefType) {
        this.document = document;
        this.secretKey = secretKey;
        this.token = token;
        this.list = list;
        this.wrapAlgorithm = keyWrapAlgorithms.get(wrap);
        if (this.wrapAlgorithm == null) {
            this.wrapAlgorithm = keyWrapAlgorithms.get(DEFAULT_ALGORITHM);
        }
        this.tokenRefType = tokenRefType;
    }

    public EncryptedKey(Element element, KeyResolver resolver) throws WSSecurityException {
        org.apache.xml.security.encryption.EncryptedKey key;
        XMLCipher cipher;
        try {
            cipher = XMLCipher.getInstance();
            cipher.init(2, null);
            key = cipher.loadEncryptedKey(element);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Could not parse encrypted key: " + e.getMessage(), e);
        }
        KeyInfo info = key.getKeyInfo();
        if (info == null) {
            throw new WSSecurityException("EncryptedKey element did not contain KeyInfo");
        }
        PrivateKey privateKey = resolver.resolvePrivateKey(info);
        Element referenceList = Util.findElement(element, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        if (referenceList == null) {
            throw new WSSecurityException("Encrypted key did not contain a reference list");
        }
        this.list = new ReferenceList(referenceList);
        String alg = this.getKeyAlgorithm(element);
        if (alg == null) {
            throw new WSSecurityException("Could not determine encrypted key algorithm!");
        }
        try {
            cipher.init(4, (Key)privateKey);
            this.secretKey = (SecretKey)cipher.decryptKey(key, alg);
        }
        catch (XMLSecurityException e) {
            try {
                this.secretKey = EncryptionOperation.generateSecretKey(alg);
            }
            catch (Exception ex) {
                FailedCheckException exception = new FailedCheckException(e);
                exception.setInternal(true);
                throw exception;
            }
        }
        this.document = element.getOwnerDocument();
        this.token = new X509Token(resolver.resolveCertificate(info), this.document);
    }

    private String getKeyAlgorithm(Element element) throws WSSecurityException {
        String id = this.list.getAllReferences().iterator().next();
        if (id == null) {
            return null;
        }
        Element dataElement = Util.findElementByWsuId(element.getOwnerDocument().getDocumentElement(), id);
        if (dataElement == null) {
            return null;
        }
        return this.getEncryptionAlgorithm(dataElement);
    }

    private String getEncryptionAlgorithm(Element element) throws WSSecurityException {
        if ((element = Util.findElement(element, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#")) == null) {
            throw new InvalidSecurityHeaderException("Encrypted element corrupted, no encryption method");
        }
        String alg = element.getAttribute("Algorithm");
        if (alg == null || alg.length() == 0) {
            throw new InvalidSecurityHeaderException("Encrypted element corrupted, no algorithm specified");
        }
        return alg;
    }

    public Element getElement() throws WSSecurityException {
        org.apache.xml.security.encryption.EncryptedKey key;
        XMLCipher cipher;
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        try {
            cipher = XMLCipher.getInstance((String)this.wrapAlgorithm);
            cipher.init(3, (Key)this.token.getCert().getPublicKey());
            key = cipher.encryptKey(this.document, (Key)this.secretKey);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Error encrypting key: " + e.getMessage(), e);
        }
        SecurityTokenReference reference = new SecurityTokenReference(Reference.getReference(this.tokenRefType, this.document, this.token));
        KeyInfo keyInfo = new KeyInfo(this.document);
        keyInfo.addUnknownElement(reference.getElement());
        key.setKeyInfo(keyInfo);
        key.setReferenceList(cipher.createReferenceList(1));
        this.list.populateRealReferenceList(key.getReferenceList());
        this.cachedElement = cipher.martial(key);
        return this.cachedElement;
    }

    public void addReference(String id) {
        this.list.add(id);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public ReferenceList getReferenceList() {
        return this.list;
    }

    static {
        keyWrapAlgorithms.put(DEFAULT_ALGORITHM, "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        keyWrapAlgorithms.put("rsa_oaep", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
    }
}

