/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.operation;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.extensions.security.QNameTarget;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SignatureKeysAssociation;
import org.jboss.ws.extensions.security.Target;
import org.jboss.ws.extensions.security.Util;
import org.jboss.ws.extensions.security.element.EncryptedKey;
import org.jboss.ws.extensions.security.element.ReferenceList;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.X509Token;
import org.jboss.ws.extensions.security.exception.WSSecurityException;
import org.jboss.ws.extensions.security.operation.EncodingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptionOperation
implements EncodingOperation {
    private List<Target> targets;
    private String alias;
    private String algorithm;
    private String wrap;
    private String tokenRefType;
    private String securityDomainAliasLabel;
    private static HashMap<String, Algorithm> algorithms = new HashMap(4);
    private static HashMap<String, String> algorithmsID;
    private static final String DEFAULT_ALGORITHM = "aes-128";

    public EncryptionOperation(List<Target> targets, String alias, String algorithm, String wrap, String tokenRefType, String securityDomainAliasLabel) {
        this.targets = targets;
        this.alias = alias;
        this.algorithm = algorithm;
        this.wrap = wrap;
        this.tokenRefType = tokenRefType;
        this.securityDomainAliasLabel = securityDomainAliasLabel;
    }

    private void processTarget(XMLCipher cipher, Document message, Target target, ReferenceList list, SecretKey key) throws WSSecurityException {
        if (!(target instanceof QNameTarget)) {
            throw new NotImplementedException();
        }
        QName name = ((QNameTarget)target).getName();
        Element element = Util.findElement(message.getDocumentElement(), name);
        if (element == null) {
            throw new RuntimeException("Could not find element");
        }
        Util.assignWsuId(element);
        try {
            cipher.init(1, (Key)key);
            EncryptedData encrypted = cipher.getEncryptedData();
            String id = Util.generateId("encrypted");
            encrypted.setId(id);
            list.add(id);
            cipher.doFinal(message, element, target.isContent());
        }
        catch (Exception e) {
            throw new WSSecurityException("Error encrypting target: " + name, e);
        }
    }

    private static SecretKey getSecretKey(String algorithm) throws WSSecurityException {
        Algorithm alg = algorithms.get(algorithm);
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(alg.jceName);
            kgen.init(alg.size);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(e.getMessage());
        }
    }

    public static SecretKey generateSecretKey(String alg) throws WSSecurityException {
        return EncryptionOperation.getSecretKey(algorithmsID.get(alg));
    }

    @Override
    public void process(Document message, SecurityHeader header, SecurityStore store) throws WSSecurityException {
        XMLCipher cipher;
        if (!algorithms.containsKey(this.algorithm)) {
            this.algorithm = DEFAULT_ALGORITHM;
        }
        SecretKey secretKey = EncryptionOperation.getSecretKey(this.algorithm);
        try {
            cipher = XMLCipher.getInstance((String)EncryptionOperation.algorithms.get((Object)this.algorithm).xmlName);
            cipher.init(1, (Key)secretKey);
        }
        catch (XMLSecurityException e) {
            throw new WSSecurityException("Error initializing xml cipher" + e.getMessage(), e);
        }
        ReferenceList list = new ReferenceList();
        if (this.targets == null || this.targets.size() == 0) {
            String namespace = message.getDocumentElement().getNamespaceURI();
            this.processTarget(cipher, message, new QNameTarget(new QName(namespace, "Body"), true), list, secretKey);
        } else {
            for (Target target : this.targets) {
                this.processTarget(cipher, message, target, list, secretKey);
            }
        }
        X509Certificate cert = this.getCertificate(store, this.alias, this.securityDomainAliasLabel);
        X509Token token = (X509Token)header.getSharedToken(cert);
        if (token == null) {
            token = new X509Token(cert, message);
            if (this.tokenRefType == null || "directReference".equals(this.tokenRefType)) {
                header.addToken(token);
            }
        }
        EncryptedKey eKey = new EncryptedKey(message, secretKey, token, list, this.wrap, this.tokenRefType);
        header.addSecurityProcess(eKey);
    }

    private X509Certificate getCertificate(SecurityStore store, String alias, String secDomainLabel) throws WSSecurityException {
        X509Certificate cert = null;
        if (alias != null || secDomainLabel != null) {
            cert = store.getCertificate(alias, secDomainLabel);
            if (cert == null) {
                throw new WSSecurityException("Cannot load certificate from keystore; alias = " + alias);
            }
        } else {
            List<PublicKey> publicKeys = SignatureKeysAssociation.getPublicKeys();
            if (publicKeys != null && publicKeys.size() == 1) {
                cert = store.getCertificateByPublicKey(publicKeys.iterator().next());
            }
            if (cert == null) {
                throw new WSSecurityException("Cannot get the certificate for message encryption! Verify the keystore contents, considering the certificate is obtained through the alias specified in the encrypt configuration element or (server side only) through a single key used to sign the incoming message.");
            }
        }
        return cert;
    }

    public static boolean probeUnlimitedCrypto() throws WSSecurityException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(256);
            SecretKey key = kgen.generateKey();
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key);
            kgen = KeyGenerator.getInstance("Blowfish");
            key = kgen.generateKey();
            c = Cipher.getInstance("Blowfish");
            c.init(1, key);
            return true;
        }
        catch (InvalidKeyException e) {
            return false;
        }
        catch (Exception e) {
            throw new WSSecurityException("Error probing cryptographic permissions", e);
        }
    }

    static {
        algorithms.put(DEFAULT_ALGORITHM, new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128));
        algorithms.put("aes-192", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192));
        algorithms.put("aes-256", new Algorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
        algorithms.put("aes-128-gcm", new Algorithm("AES", "http://www.w3.org/2009/xmlenc11#aes128-gcm", 128));
        algorithms.put("aes-192-gcm", new Algorithm("AES", "http://www.w3.org/2009/xmlenc11#aes192-gcm", 192));
        algorithms.put("aes-256-gcm", new Algorithm("AES", "http://www.w3.org/2009/xmlenc11#aes256-gcm", 256));
        algorithms.put("tripledes", new Algorithm("TripleDes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168));
        algorithmsID = new HashMap(4);
        algorithmsID.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", DEFAULT_ALGORITHM);
        algorithmsID.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", "aes-192");
        algorithmsID.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "aes-256");
        algorithmsID.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "tripledes");
    }

    private static class Algorithm {
        public String jceName;
        public String xmlName;
        public int size;

        Algorithm(String jceName, String xmlName, int size) {
            this.jceName = jceName;
            this.xmlName = xmlName;
            this.size = size;
        }
    }
}

