/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.ws.extensions.validation.SchemaResourceResolver;
import org.jboss.ws.extensions.validation.StrictlyValidErrorHandler;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaValidationHelper {
    private ErrorHandler errorHandler = new StrictlyValidErrorHandler();
    private static SchemaFactory factory = null;
    private Validator validator = null;

    public SchemaValidationHelper(URL xsdURL) throws SAXException {
        Schema schema = factory.newSchema(new File(xsdURL.getFile()));
        this.validator = schema.newValidator();
        this.validator.setErrorHandler(this.errorHandler);
    }

    public SchemaValidationHelper(Map<String, byte[]> xsdStreams) throws SAXException {
        SchemaResourceResolver resolver = new SchemaResourceResolver(xsdStreams);
        factory.setResourceResolver(resolver);
        ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
        for (byte[] ins : xsdStreams.values()) {
            StreamSource source = new StreamSource(new ByteArrayInputStream(ins));
            schemas.add(source);
        }
        Source[] sources = schemas.toArray(new Source[0]);
        Schema schema = factory.newSchema(sources);
        this.validator = schema.newValidator();
        this.validator.setErrorHandler(this.errorHandler);
    }

    public SchemaValidationHelper setErrorHandler(ErrorHandler errorHandler) {
        this.validator.setErrorHandler(errorHandler);
        return this;
    }

    public void validateDocument(String inxml) throws Exception {
        StreamSource source = new StreamSource(new ByteArrayInputStream(inxml.getBytes()));
        this.validateDocument(source);
    }

    public void validateDocument(Source xml) throws Exception {
        this.validator.validate(xml);
    }

    public void validateDocument(Element inxml) throws Exception {
        DOMSource domSource = new DOMSource(inxml);
        this.validator.validate(domSource);
    }

    public void validateDocument(InputStream inxml) throws Exception {
        StreamSource source = new StreamSource(inxml);
        this.validateDocument(source);
    }

    public void validateDocument(InputSource inxml) throws Exception {
        StreamSource source = new StreamSource(inxml.getByteStream());
        this.validateDocument(source);
    }

    static {
        factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    }
}

