/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xsd;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;

public class XSDWriter {
    protected static final Logger log = Logger.getLogger(XSDWriter.class);
    protected WSDLDefinitions wsdl = null;
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);

    public void writeXSD(Writer writer, XSModel xsmodel, WSDLDefinitions wsdl) {
        if (xsmodel == null) {
            throw new IllegalArgumentException("xsmodel is NULL");
        }
        this.wsdl = wsdl;
        if (this.schemautils.isEmptySchema(xsmodel)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL serialize(XSModel xsmodel, String ns) throws IOException {
        if (ns == null) {
            throw new IllegalArgumentException("Illegal Null Argument:ns");
        }
        String xsdString = "";
        if (xsmodel instanceof JBossXSModel) {
            JBossXSModel jbxs = (JBossXSModel)xsmodel;
            xsdString = jbxs.serialize();
        } else {
            StringWriter strwr = new StringWriter();
            this.sutils.serialize(xsmodel, strwr);
            xsdString = strwr.toString();
        }
        log.trace((Object)("serialize:\n" + xsdString));
        File xsdFile = SchemaUtils.getSchemaTempFile(ns, null);
        FileWriter writer = new FileWriter(xsdFile);
        try {
            writer.write(xsdString);
        }
        finally {
            writer.close();
        }
        return xsdFile.toURL();
    }

    public void serialize(XSModel xsmodel, String ns, OutputStream os) throws IOException {
        StringWriter strwr = new StringWriter();
        this.sutils.serialize(xsmodel, strwr);
        String xsdString = strwr.toString();
        log.trace((Object)("serialize:" + xsdString));
        os.write(xsdString.getBytes());
    }
}

