/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLBindingMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLDocumentation;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLExtensibilityElement;
import org.jboss.ws.metadata.wsdl.WSDLImport;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceMessageReference;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLRPCSignatureItem;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.jboss.ws.tools.wsdl.WSDLWriterResolver;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDL11Writer
extends WSDLWriter {
    private String wsdlStyle = "RPC/Literal";
    private HashSet<String> writtenFaultMessages = new HashSet();

    public WSDL11Writer(WSDLDefinitions wsdl) {
        super(wsdl);
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, null);
    }

    public void write(Writer writer, String charset) throws IOException {
        this.write(writer, charset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, String charset, WSDLWriterResolver resolver) throws IOException {
        if (this.wsdl.getWsdlOneOneDefinition() != null) {
            Definition wsdlDefinition = this.wsdl.getWsdlOneOneDefinition();
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                javax.wsdl.xml.WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                wsdlWriter.writeWSDL(wsdlDefinition, writer);
            }
            catch (WSDLException e) {
                this.logException((Exception)((Object)e));
                throw new IOException(e.toString());
            }
        } else {
            StringBuilder buffer = new StringBuilder();
            this.wsdlStyle = this.utils.getWSDLStyle(this.wsdl);
            StringBuilder importBuffer = new StringBuilder();
            for (WSDLImport wsdlImport : this.wsdl.getImports()) {
                WSDLWriterResolver resolved;
                if (resolver == null || (resolved = resolver.resolve(wsdlImport.getLocation())) == null) continue;
                String namespace = wsdlImport.getNamespace();
                importBuffer.append("<import namespace='" + namespace + "' location='" + resolved.actualFile + "'/>");
                if (resolved == null) continue;
                StringBuilder builder = new StringBuilder();
                this.appendDefinitions(builder, namespace);
                this.appendBody(builder, namespace);
                try {
                    this.writeBuilder(builder, resolved.writer, resolved.charset);
                }
                finally {
                    resolved.writer.close();
                }
            }
            this.appendDefinitions(buffer, this.wsdl.getTargetNamespace());
            if (importBuffer.length() > 0) {
                buffer.append((CharSequence)importBuffer);
            }
            this.appendBody(buffer, this.wsdl.getTargetNamespace());
            this.writeBuilder(buffer, writer, charset);
        }
    }

    private void writeBuilder(StringBuilder builder, Writer writer, String charset) throws IOException {
        Element element = DOMUtils.parse((String)builder.toString());
        if (charset != null) {
            writer.write("<?xml version=\"1.0\" encoding=\"" + charset + "\"?>\n");
        }
        new DOMWriter(writer).setPrettyprint(true).print((Node)element);
    }

    protected void appendBody(StringBuilder builder, String namespace) {
        this.writtenFaultMessages.clear();
        this.appendTypes(builder, namespace);
        this.appendUnknownExtensibilityElements(builder, this.wsdl);
        this.appendMessages(builder, namespace);
        this.appendInterfaces(builder, namespace);
        this.appendBindings(builder, namespace);
        this.appendServices(builder, namespace);
        builder.append("</definitions>");
    }

    protected void appendUnknownExtensibilityElements(StringBuilder builder, Extendable extendable) {
        for (WSDLExtensibilityElement ext : extendable.getAllExtensibilityElements()) {
            this.appendJAXWSCustomizationElements(builder, ext);
        }
    }

    private void appendJAXWSCustomizationElements(StringBuilder builder, WSDLExtensibilityElement extElem) {
        if ("http://java.sun.com/xml/ns/jaxws".equalsIgnoreCase(extElem.getUri())) {
            this.appendElementSkippingKnownNs(builder, extElem.getElement());
        }
    }

    private void appendElementSkippingKnownNs(StringBuilder builder, Element el) {
        builder.append("<" + el.getNodeName());
        NamedNodeMap attributes = el.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (attr.getName().startsWith("xmlns:") && attr.getValue() != null) {
                String prefix = attr.getName().substring(6);
                if (attr.getValue().equalsIgnoreCase(this.wsdl.getNamespaceURI(prefix))) continue;
            }
            builder.append(" " + attr.getName() + "='" + attr.getValue() + "'");
        }
        builder.append(">");
        NodeList childrenList = el.getChildNodes();
        for (int i = 0; i < childrenList.getLength(); ++i) {
            Node node = childrenList.item(i);
            if (node instanceof Element) {
                this.appendElementSkippingKnownNs(builder, (Element)node);
                continue;
            }
            builder.append(DOMWriter.printNode((Node)node, (boolean)false));
        }
        builder.append("</" + el.getNodeName() + ">");
    }

    protected void appendMessages(StringBuilder buffer, String namespace) {
        WSDLInterface[] interfaces = this.wsdl.getInterfaces();
        int len = interfaces != null ? interfaces.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterface intf = interfaces[i];
            if (!namespace.equals(intf.getName().getNamespaceURI())) continue;
            WSDLInterfaceOperation[] operations = intf.getSortedOperations();
            int lenOps = operations.length;
            for (int j = 0; j < lenOps; ++j) {
                this.appendMessage(buffer, operations[j]);
                this.appendMessagesForExceptions(buffer, operations[j]);
            }
        }
    }

    private void appendMessage(StringBuilder buffer, WSDLInterfaceOperation operation) {
        String opname = operation.getName().getLocalPart();
        if (!"http://www.w3.org/2004/03/wsdl/style/rpc".equals(operation.getStyle())) {
            this.wsdlStyle = "Document/Literal";
        }
        String interfaceName = operation.getWsdlInterface().getName().getLocalPart();
        buffer.append("<message name='" + interfaceName + "_" + opname + "' >");
        for (WSDLInterfaceOperationInput input : operation.getInputs()) {
            this.appendUnknownExtensibilityElements(buffer, input);
            this.appendMessageParts(buffer, input);
        }
        buffer.append("</message>");
        if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
            WSDLInterfaceOperationOutput[] outputs;
            buffer.append("<message name='" + interfaceName + "_" + opname + "Response' >");
            for (WSDLInterfaceOperationOutput output : outputs = operation.getOutputs()) {
                this.appendMessageParts(buffer, output);
            }
            buffer.append("</message>");
        }
    }

    private void appendMessagesForExceptions(StringBuilder buffer, WSDLInterfaceOperation operation) {
        WSDLInterfaceOperationOutfault[] faults = operation.getOutfaults();
        int len = faults != null ? faults.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterfaceOperationOutfault fault = faults[i];
            String exceptionName = fault.getRef().getLocalPart();
            if (this.writtenFaultMessages.contains(exceptionName)) continue;
            QName xmlName = fault.getRef();
            buffer.append("<message name='" + exceptionName + "' >");
            String prefix = this.wsdl.getPrefix(xmlName.getNamespaceURI());
            String xmlNameStr = prefix + ":" + xmlName.getLocalPart();
            buffer.append("<part name='" + exceptionName + "' element='" + xmlNameStr + "' />");
            buffer.append("</message>");
            this.writtenFaultMessages.add(exceptionName);
        }
    }

    private String getReferenceString(QName name) {
        String namespaceURI = name.getNamespaceURI();
        String prefix = this.wsdl.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new WSException("Prefix not bound for namespace: " + namespaceURI);
        }
        return prefix + ":" + name.getLocalPart();
    }

    private void appendMessageParts(StringBuilder buffer, WSDLInterfaceMessageReference reference) {
        WSDLBindingMessageReference bindingReference;
        if (this.wsdlStyle.equals("RPC/Literal")) {
            for (WSDLRPCPart part : reference.getChildParts()) {
                buffer.append("<part name='" + part.getName()).append('\'');
                buffer.append(" type='" + this.getReferenceString(part.getType()) + "'/>");
            }
        } else {
            QName element = reference.getElement();
            if (element != null) {
                buffer.append("<part name='" + reference.getPartName() + '\'');
                buffer.append(" element='" + this.getReferenceString(element) + "'/>");
            }
        }
        if ((bindingReference = this.getBindingReference(reference)) == null) {
            return;
        }
        for (WSDLSOAPHeader header : bindingReference.getSoapHeaders()) {
            if (header.isIncludeInSignature()) {
                // empty if block
            }
            QName element = header.getElement();
            buffer.append("<part name='" + header.getPartName() + '\'');
            buffer.append(" element='" + this.getReferenceString(element) + "'/>");
        }
    }

    private WSDLBindingMessageReference getBindingReference(WSDLInterfaceMessageReference reference) {
        WSDLInterfaceOperation wsdlOperation = reference.getWsdlOperation();
        WSDLInterface wsdlInterface = wsdlOperation.getWsdlInterface();
        WSDLBinding binding = wsdlInterface.getWsdlDefinitions().getBindingByInterfaceName(wsdlInterface.getName());
        WSDLBindingOperation bindingOperation = binding.getOperationByRef(wsdlOperation.getName());
        WSDLBindingMessageReference[] bindingReferences = reference instanceof WSDLInterfaceOperationInput ? bindingOperation.getInputs() : bindingOperation.getOutputs();
        if (bindingReferences.length > 1) {
            throw new IllegalArgumentException("WSDl 1.1 only supports In-Only, and In-Out MEPS, more than reference input found");
        }
        if (bindingReferences.length == 1) {
            return bindingReferences[0];
        }
        return null;
    }

    protected void appendInterfaces(StringBuilder buffer, String namespace) {
        WSDLInterface[] intfs = this.wsdl.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            WSDLInterface intf = intfs[i];
            if (!namespace.equals(intf.getName().getNamespaceURI())) continue;
            buffer.append("<portType name='" + intf.getName().getLocalPart() + "'");
            buffer.append(">");
            this.appendDocumentation(buffer, intf.getDocumentationElement());
            this.appendUnknownExtensibilityElements(buffer, intf);
            this.appendPortOperations(buffer, intf);
            buffer.append("</portType>");
        }
    }

    private String getParameterOrder(WSDLInterfaceOperation operation) {
        StringBuilder builder = new StringBuilder();
        for (WSDLRPCSignatureItem item : operation.getRpcSignatureItems()) {
            if (item.getDirection() == WSDLRPCSignatureItem.Direction.RETURN) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(item.getName());
        }
        return builder.toString();
    }

    protected void appendPortOperations(StringBuilder buffer, WSDLInterface intf) {
        String prefix = this.wsdl.getPrefix(intf.getName().getNamespaceURI());
        WSDLInterfaceOperation[] operations = intf.getSortedOperations();
        for (int i = 0; i < operations.length; ++i) {
            String parameterOrder;
            WSDLInterfaceOperation operation = operations[i];
            buffer.append("<operation name='" + operation.getName().getLocalPart() + "'");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern()) && (parameterOrder = this.getParameterOrder(operation)).length() > 0) {
                buffer.append(" parameterOrder='").append(parameterOrder).append("'");
            }
            buffer.append(">");
            this.appendDocumentation(buffer, operation.getDocumentationElement());
            this.appendUnknownExtensibilityElements(buffer, operation);
            String opname = operation.getName().getLocalPart();
            String interfaceName = operation.getWsdlInterface().getName().getLocalPart();
            String msgEl = prefix + ":" + interfaceName + "_" + opname;
            buffer.append("<input message='" + msgEl + "'>").append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(operation.getPattern())) {
                buffer.append("<output message='" + msgEl + "Response'>");
                buffer.append("</output>");
            }
            for (WSDLInterfaceOperationOutfault fault : operation.getOutfaults()) {
                QName element = fault.getRef();
                buffer.append("<fault  message='" + prefix + ":" + element.getLocalPart());
                buffer.append("' name='" + element.getLocalPart() + "'/>");
            }
            buffer.append("</operation>");
        }
    }

    protected void appendDocumentation(StringBuilder buffer, WSDLDocumentation documentation) {
        if (documentation != null && documentation.getContent() != null) {
            buffer.append("<documentation>");
            buffer.append(documentation.getContent());
            buffer.append("</documentation>");
        }
    }

    protected void appendBindings(StringBuilder buffer, String namespace) {
        WSDLBinding[] bindings = this.wsdl.getBindings();
        for (int i = 0; i < bindings.length; ++i) {
            WSDLBinding binding = bindings[i];
            if (!namespace.equals(binding.getName().getNamespaceURI())) continue;
            buffer.append("<binding name='" + binding.getName().getLocalPart() + "' type='" + this.getQNameRef(binding.getInterfaceName()) + "'>");
            if (this.wsdlStyle == null) {
                throw new IllegalArgumentException("WSDL Style is null (should be rpc or document");
            }
            String style = "rpc";
            if (this.wsdlStyle.equals("Document/Literal")) {
                style = "document";
            }
            this.appendUnknownExtensibilityElements(buffer, binding);
            buffer.append("<" + this.soapPrefix + ":binding transport='" + "http://schemas.xmlsoap.org/soap/http" + "' style='" + style + "'/>");
            this.appendBindingOperations(buffer, binding);
            buffer.append("</binding>");
        }
    }

    protected void appendBindingOperations(StringBuilder buffer, WSDLBinding binding) {
        Object[] operations = binding.getOperations();
        Arrays.sort(operations);
        for (int i = 0; i < operations.length; ++i) {
            WSDLInterfaceOperationOutfault[] faults;
            Object operation = operations[i];
            QName interfaceName = ((WSDLBindingOperation)operation).getWsdlBinding().getInterfaceName();
            WSDLInterface wsdlInterface = this.wsdl.getInterface(interfaceName);
            if (wsdlInterface == null) {
                throw new WSException("WSDL Interface should not be null");
            }
            WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(((WSDLBindingOperation)operation).getRef());
            buffer.append("<operation name='" + interfaceOperation.getName().getLocalPart() + "'>");
            String soapAction = ((WSDLBindingOperation)operation).getSOAPAction() != null ? ((WSDLBindingOperation)operation).getSOAPAction() : "";
            this.appendUnknownExtensibilityElements(buffer, (Extendable)operation);
            buffer.append("<" + this.soapPrefix + ":operation soapAction=\"" + soapAction + "\"/>");
            WSDLBindingMessageReference[] inputs = ((WSDLBindingOperation)operation).getInputs();
            if (inputs.length != 1) {
                throw new WSException("WSDl 1.1 only supports In-Only, and In-Out MEPS.");
            }
            buffer.append("<input>");
            this.appendUnknownExtensibilityElements(buffer, inputs[0]);
            this.appendSOAPBinding(buffer, wsdlInterface, (WSDLBindingOperation)operation, inputs);
            buffer.append("</input>");
            if (!"http://www.w3.org/2004/08/wsdl/in-only".equals(this.getBindingOperationPattern((WSDLBindingOperation)operation))) {
                buffer.append("<output>");
                WSDLBindingMessageReference[] outputs = ((WSDLBindingOperation)operation).getOutputs();
                this.appendSOAPBinding(buffer, wsdlInterface, (WSDLBindingOperation)operation, outputs);
                buffer.append("</output>");
            }
            if ((faults = interfaceOperation.getOutfaults()) == null) continue;
            for (WSDLInterfaceOperationOutfault fault : faults) {
                String n = "name='" + fault.getRef().getLocalPart() + "'";
                buffer.append("<fault  " + n + ">");
                buffer.append("<" + this.soapPrefix + ":fault  " + n + " use='literal' />");
                buffer.append("</fault>");
            }
            buffer.append("</operation>");
        }
    }

    private void appendSOAPBinding(StringBuilder buffer, WSDLInterface wsdlInterface, WSDLBindingOperation operation, WSDLBindingMessageReference[] inputs) {
        String tns = this.wsdl.getTargetNamespace();
        WSDLInterfaceOperation interfaceOperation = wsdlInterface.getOperation(operation.getRef());
        WSDLInterfaceMessageReference reference = inputs instanceof WSDLBindingOperationInput[] ? interfaceOperation.getInputs()[0] : interfaceOperation.getOutputs()[0];
        StringBuilder bodyParts = new StringBuilder();
        if ("Document/Literal" == this.wsdlStyle) {
            if (reference.getPartName() != null) {
                bodyParts.append(reference.getPartName());
            }
        } else {
            for (WSDLRPCPart part : reference.getChildParts()) {
                if (bodyParts.length() > 0) {
                    bodyParts.append(" ");
                }
                bodyParts.append(part.getName());
            }
        }
        StringBuilder soapHeader = new StringBuilder();
        for (WSDLSOAPHeader header : inputs[0].getSoapHeaders()) {
            if (!header.isIncludeInSignature()) continue;
            String messageName = wsdlInterface.getName().getLocalPart() + "_" + operation.getRef().getLocalPart();
            if (reference instanceof WSDLInterfaceOperationOutput) {
                messageName = messageName + "Response";
            }
            soapHeader.append("<").append(this.soapPrefix).append(":header use='literal' message='tns:").append(messageName);
            soapHeader.append("' part='").append(header.getPartName()).append("'/>");
        }
        buffer.append("<" + this.soapPrefix + ":body use='literal'");
        if (this.wsdlStyle != "Document/Literal") {
            buffer.append(" namespace='" + tns + "'");
        }
        if (soapHeader.length() > 0) {
            buffer.append(" parts='").append((CharSequence)bodyParts).append("'/>");
            buffer.append((CharSequence)soapHeader);
        } else {
            buffer.append("/>");
        }
    }

    private String getBindingOperationPattern(WSDLBindingOperation operation) {
        WSDLBinding binding = operation.getWsdlBinding();
        String pattern = binding.getInterface().getOperation(operation.getRef()).getPattern();
        return pattern;
    }

    protected void appendServices(StringBuilder buffer, String namespace) {
        for (WSDLService service : this.wsdl.getServices()) {
            if (!namespace.equals(service.getName().getNamespaceURI())) continue;
            buffer.append("<service name='" + service.getName().getLocalPart() + "'>");
            this.appendUnknownExtensibilityElements(buffer, service);
            for (WSDLEndpoint endpoint : service.getEndpoints()) {
                this.appendServicePort(buffer, endpoint);
            }
            buffer.append("</service>");
        }
    }

    protected void appendServicePort(StringBuilder buffer, WSDLEndpoint endpoint) {
        String name = endpoint.getName().getLocalPart();
        QName endpointBinding = endpoint.getBinding();
        String prefix = endpointBinding.getPrefix();
        prefix = this.wsdl.getPrefix(endpointBinding.getNamespaceURI());
        String ebname = prefix + ":" + endpointBinding.getLocalPart();
        buffer.append("<port name='" + name + "' binding='" + ebname + "'>");
        buffer.append("<" + this.soapPrefix + ":address location='" + endpoint.getAddress() + "'/>");
        this.appendUnknownExtensibilityElements(buffer, endpoint);
        buffer.append("</port>");
    }
}

