/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.hql.ast.tree.AbstractRestrictableStatement;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.OrderByClause;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryNode
extends AbstractRestrictableStatement
implements SelectExpression {
    private static final Logger log = LoggerFactory.getLogger(QueryNode.class);
    private OrderByClause orderByClause;
    private String alias;

    @Override
    public int getStatementType() {
        return 83;
    }

    @Override
    public boolean needsExecutor() {
        return false;
    }

    @Override
    protected int getWhereClauseParentTokenType() {
        return 22;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public final SelectClause getSelectClause() {
        return (SelectClause)ASTUtil.findTypeInChildren((AST)this, 131);
    }

    public final boolean hasOrderByClause() {
        OrderByClause orderByClause = this.locateOrderByClause();
        return orderByClause != null && orderByClause.getNumberOfChildren() > 0;
    }

    public final OrderByClause getOrderByClause() {
        if (this.orderByClause == null) {
            this.orderByClause = this.locateOrderByClause();
            if (this.orderByClause == null) {
                log.debug("getOrderByClause() : Creating a new ORDER BY clause");
                this.orderByClause = (OrderByClause)ASTUtil.create(this.getWalker().getASTFactory(), 41, "ORDER");
                AST prevSibling = ASTUtil.findTypeInChildren((AST)this, 53);
                if (prevSibling == null) {
                    prevSibling = ASTUtil.findTypeInChildren((AST)this, 22);
                }
                this.orderByClause.setNextSibling(prevSibling.getNextSibling());
                prevSibling.setNextSibling((AST)this.orderByClause);
            }
        }
        return this.orderByClause;
    }

    private OrderByClause locateOrderByClause() {
        return (OrderByClause)ASTUtil.findTypeInChildren((AST)this, 41);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public FromElement getFromElement() {
        return null;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isReturnableEntity() throws SemanticException {
        return false;
    }

    @Override
    public boolean isScalar() throws SemanticException {
        return true;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    @Override
    public Type getDataType() {
        return ((SelectExpression)this.getSelectClause().getFirstSelectExpression()).getDataType();
    }
}

