/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.Region;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.impl.CacheDataDescriptionImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.JTASessionContext;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.impl.SessionImpl;
import org.hibernate.impl.StatelessSessionImpl;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.PersisterFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImpl;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryImpl.class);
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map collectionRolesByEntityParticipant;
    private final transient Map identifierGenerators;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map sqlResultSetMappings;
    private final transient Map filters;
    private final transient Map imports;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map<String, QueryCache> queryCaches;
    private final transient ConcurrentMap<String, Region> allCacheRegions = new ConcurrentHashMap<String, Region>();
    private final transient StatisticsImpl statistics = new StatisticsImpl(this);
    private final transient EventListeners eventListeners;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient EntityNotFoundDelegate entityNotFoundDelegate;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserver observer;
    private final transient HashMap entityNameResolvers = new HashMap();
    private final QueryPlanCache queryPlanCache;
    private transient boolean isClosed = false;

    public SessionFactoryImpl(Configuration cfg, Mapping mapping, Settings settings, EventListeners listeners, SessionFactoryObserver observer) throws HibernateException {
        Map errors;
        log.info("building session factory");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)cfg.getProperties());
        this.interceptor = cfg.getInterceptor();
        this.settings = settings;
        this.sqlFunctionRegistry = new SQLFunctionRegistry(settings.getDialect(), cfg.getSqlFunctions());
        this.eventListeners = listeners;
        this.observer = observer != null ? observer : new SessionFactoryObserver(){

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
            }
        };
        this.filters = new HashMap();
        this.filters.putAll(cfg.getFilterDefinitions());
        if (log.isDebugEnabled()) {
            log.debug("Session factory constructed with filter configurations : " + this.filters);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating session factory with properties: " + this.properties);
        }
        settings.getRegionFactory().start(settings, this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        this.identifierGenerators = new HashMap();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = (PersistentClass)classes.next();
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(settings.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        String cacheRegionPrefix = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        this.entityPersisters = new HashMap();
        HashMap<String, Object> entityAccessStrategies = new HashMap<String, Object>();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            AccessType accessType;
            PersistentClass model = (PersistentClass)classes.next();
            model.prepareTemporaryTables(mapping, settings.getDialect());
            String cacheRegionName = cacheRegionPrefix + model.getRootClass().getCacheRegionName();
            EntityRegionAccessStrategy accessStrategy = (EntityRegionAccessStrategy)entityAccessStrategies.get(cacheRegionName);
            if (accessStrategy == null && settings.isSecondLevelCacheEnabled() && (accessType = AccessType.parse(model.getCacheConcurrencyStrategy())) != null) {
                log.trace("Building cache for entity data [" + model.getEntityName() + "]");
                EntityRegion entityRegion = settings.getRegionFactory().buildEntityRegion(cacheRegionName, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = entityRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(cacheRegionName, accessStrategy);
                this.allCacheRegions.put(cacheRegionName, entityRegion);
            }
            EntityPersister entityPersister = PersisterFactory.createClassPersister(model, accessStrategy, this, mapping);
            this.entityPersisters.put(model.getEntityName(), entityPersister);
            classMeta.put(model.getEntityName(), entityPersister.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            Type elementType;
            Collection model = (Collection)collections.next();
            String string = cacheRegionPrefix + model.getCacheRegionName();
            AccessType accessType = AccessType.parse(model.getCacheConcurrencyStrategy());
            CollectionRegionAccessStrategy accessStrategy = null;
            if (accessType != null && settings.isSecondLevelCacheEnabled()) {
                log.trace("Building cache for collection data [" + model.getRole() + "]");
                CollectionRegion collectionRegion = settings.getRegionFactory().buildCollectionRegion(string, this.properties, CacheDataDescriptionImpl.decode(model));
                accessStrategy = collectionRegion.buildAccessStrategy(accessType);
                entityAccessStrategies.put(string, accessStrategy);
                this.allCacheRegions.put(string, collectionRegion);
            }
            CollectionPersister persister = PersisterFactory.createCollectionPersister(cfg, model, accessStrategy, this);
            this.collectionPersisters.put(model.getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                String entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        for (Map.Entry entry : tmpEntityToCollectionRoleMap.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap(cfg.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap(cfg.getSqlResultSetMappings());
        this.imports = new HashMap(cfg.getImports());
        for (Object persister : this.entityPersisters.values()) {
            persister.postInstantiate();
            this.registerEntityNameResolvers((EntityPersister)persister);
        }
        for (Object persister : this.collectionPersisters.values()) {
            persister.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        log.debug("instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(cfg, settings).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(cfg, settings).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(cfg, settings).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(cfg, settings);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug("obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            if (settings.getTransactionFactory().isTransactionManagerRequired()) {
                throw new HibernateException("The chosen transaction strategy requires access to the JTA TransactionManager");
            }
            this.transactionManager = null;
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap<String, QueryCache>();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (settings.isNamedQueryStartupCheckingEnabled() && !(errors = this.checkNamedQueries()).isEmpty()) {
            Set keys = errors.keySet();
            StringBuffer failingQueries = new StringBuffer("Errors in named queries: ");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String queryName = (String)iterator.next();
                HibernateException e = (HibernateException)errors.get(queryName);
                failingQueries.append(queryName);
                if (iterator.hasNext()) {
                    failingQueries.append(", ");
                }
                log.error("Error in named query: " + queryName, (Throwable)e);
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.getStatistics().setStatisticsEnabled(settings.isStatisticsEnabled());
        EntityNotFoundDelegate entityNotFoundDelegate = cfg.getEntityNotFoundDelegate();
        if (entityNotFoundDelegate == null) {
            entityNotFoundDelegate = new EntityNotFoundDelegate(){

                @Override
                public void handleEntityNotFound(String entityName, Serializable id) {
                    throw new ObjectNotFoundException(id, entityName);
                }
            };
        }
        this.entityNotFoundDelegate = entityNotFoundDelegate;
        this.observer.sessionFactoryCreated(this);
    }

    private void registerEntityNameResolvers(EntityPersister persister) {
        if (persister.getEntityMetamodel() == null || persister.getEntityMetamodel().getTuplizerMapping() == null) {
            return;
        }
        Iterator itr = persister.getEntityMetamodel().getTuplizerMapping().iterateTuplizers();
        while (itr.hasNext()) {
            EntityTuplizer tuplizer = (EntityTuplizer)itr.next();
            this.registerEntityNameResolvers(tuplizer);
        }
    }

    private void registerEntityNameResolvers(EntityTuplizer tuplizer) {
        EntityNameResolver[] resolvers = tuplizer.getEntityNameResolvers();
        if (resolvers == null) {
            return;
        }
        for (int i = 0; i < resolvers.length; ++i) {
            this.registerEntityNameResolver(resolvers[i], tuplizer.getEntityMode());
        }
    }

    public void registerEntityNameResolver(EntityNameResolver resolver, EntityMode entityMode) {
        LinkedHashSet<EntityNameResolver> resolversForMode = (LinkedHashSet<EntityNameResolver>)this.entityNameResolvers.get(entityMode);
        if (resolversForMode == null) {
            resolversForMode = new LinkedHashSet<EntityNameResolver>();
            this.entityNameResolvers.put(entityMode, resolversForMode);
        }
        resolversForMode.add(resolver);
    }

    public Iterator iterateEntityNameResolvers(EntityMode entityMode) {
        Set actualEntityNameResolvers = (Set)this.entityNameResolvers.get(entityMode);
        return actualEntityNameResolvers == null ? EmptyIterator.INSTANCE : actualEntityNameResolvers.iterator();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map checkNamedQueries() throws HibernateException {
        NamedQueryDefinition qd;
        String queryName;
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        log.debug("Checking " + this.namedQueries.size() + " named HQL queries");
        for (Map.Entry entry : this.namedQueries.entrySet()) {
            queryName = (String)entry.getKey();
            qd = (NamedQueryDefinition)entry.getValue();
            try {
                log.debug("Checking named query: " + queryName);
                this.queryPlanCache.getHQLQueryPlan(qd.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        log.debug("Checking " + this.namedSqlQueries.size() + " named SQL queries");
        for (Map.Entry entry : this.namedSqlQueries.entrySet()) {
            queryName = (String)entry.getKey();
            qd = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification spec;
                log.debug("Checking named SQL query: " + queryName);
                if (((NamedSQLQueryDefinition)qd).getResultSetRef() != null) {
                    ResultSetMappingDefinition definition = (ResultSetMappingDefinition)this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)qd).getResultSetRef());
                    if (definition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)qd).getResultSetRef());
                    }
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), definition.getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                } else {
                    spec = new NativeSQLQuerySpecification(qd.getQueryString(), ((NamedSQLQueryDefinition)qd).getQueryReturns(), ((NamedSQLQueryDefinition)qd).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(spec);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        return errors;
    }

    @Override
    public StatelessSession openStatelessSession() {
        return new StatelessSessionImpl(null, this);
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return new StatelessSessionImpl(connection, this);
    }

    private SessionImpl openSession(Connection connection, boolean autoClose, long timestamp, Interceptor sessionLocalInterceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, sessionLocalInterceptor == null ? this.interceptor : sessionLocalInterceptor, this.settings.getDefaultEntityMode(), this.settings.isFlushBeforeCompletionEnabled(), this.settings.isAutoCloseSessionEnabled(), this.settings.getConnectionReleaseMode());
    }

    @Override
    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, sessionLocalInterceptor);
    }

    @Override
    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        long timestamp = this.settings.getRegionFactory().nextTimestamp();
        return this.openSession(null, true, timestamp, sessionLocalInterceptor);
    }

    @Override
    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return new SessionImpl(null, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), false, false, ConnectionReleaseMode.AFTER_STATEMENT);
    }

    @Override
    public Session openSession(Connection connection, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return new SessionImpl(connection, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), flushBeforeCompletionEnabled, autoCloseSessionEnabled, connectionReleaseMode);
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = (EntityPersister)this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    @Override
    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.settings.getSQLExceptionConverter();
    }

    @Override
    public Set getCollectionRolesByEntityParticipant(String entityName) {
        return (Set)this.collectionRolesByEntityParticipant.get(entityName);
    }

    @Override
    public Reference getReference() throws NamingException {
        log.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace("Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug("resolved SessionFactory by name");
        } else {
            log.debug("resolved SessionFactory by uid");
        }
        return result;
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String queryName) {
        return (NamedQueryDefinition)this.namedQueries.get(queryName);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return (NamedSQLQueryDefinition)this.namedSqlQueries.get(queryName);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String resultSetName) {
        return (ResultSetMappingDefinition)this.sqlResultSetMappings.get(resultSetName);
    }

    @Override
    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace("deserializing");
        in.defaultReadObject();
        log.debug("deserialized: " + this.uuid);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        log.debug("serializing: " + this.uuid);
        out.defaultWriteObject();
        log.trace("serialized");
    }

    @Override
    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(queryString, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(roleName);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return (ClassMetadata)this.classMetadata.get(entityName);
    }

    @Override
    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        for (EntityPersister testPersister : this.entityPersisters.values()) {
            boolean assignableSuperclass;
            if (!(testPersister instanceof Queryable)) continue;
            Queryable testQueryable = (Queryable)testPersister;
            String testClassName = testQueryable.getEntityName();
            boolean isMappedClass = className.equals(testClassName);
            if (testQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(testClassName);
                continue;
            }
            Class mappedClass = testQueryable.getMappedClass(EntityMode.POJO);
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (testQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(testQueryable.getMappedSuperclass()).getMappedClass(EntityMode.POJO);
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(testClassName);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    public String getImportedClassName(String className) {
        String result = (String)this.imports.get(className);
        if (result == null) {
            try {
                ReflectHelper.classForName(className);
                return className;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return result;
    }

    @Override
    public Map getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            log.trace("already closed");
            return;
        }
        log.info("closing");
        this.isClosed = true;
        for (Object p : this.entityPersisters.values()) {
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        for (Object p : this.collectionPersisters.values()) {
            if (!p.hasCache()) continue;
            p.getCacheAccessStrategy().getRegion().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (QueryCache cache : this.queryCaches.values()) {
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getRegionFactory().stop();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        this.observer.sessionFactoryClosed(this);
        this.eventListeners.destroyListeners();
    }

    @Override
    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        EntityPersister p = this.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.infoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getIdentifierType(), p.getRootEntityName(), EntityMode.POJO, this);
            p.getCacheAccessStrategy().evict(cacheKey);
        }
    }

    @Override
    public void evictEntity(String entityName) throws HibernateException {
        EntityPersister p = this.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getEntityName());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        EntityPersister p = this.getEntityPersister(persistentClass.getName());
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.infoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getIdentifierType(), p.getRootEntityName(), EntityMode.POJO, this);
            p.getCacheAccessStrategy().evict(cacheKey);
        }
    }

    @Override
    public void evict(Class persistentClass) throws HibernateException {
        EntityPersister p = this.getEntityPersister(persistentClass.getName());
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getEntityName());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.collectionInfoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getKeyType(), p.getRole(), EntityMode.POJO, this);
            p.getCacheAccessStrategy().evict(cacheKey);
        }
    }

    @Override
    public void evictCollection(String roleName) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getRole());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (regionName == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        QueryCache currentQueryCache = this.queryCaches.get(regionName);
        if (currentQueryCache == null) {
            currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(regionName, this.updateTimestampsCache, this.settings, this.properties);
            this.queryCaches.put(regionName, currentQueryCache);
            this.allCacheRegions.put(currentQueryCache.getRegion().getName(), currentQueryCache.getRegion());
        }
        return currentQueryCache;
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        return (Region)this.allCacheRegions.get(regionName);
    }

    @Override
    public Map getAllSecondLevelCacheRegions() {
        return new HashMap<String, Region>(this.allCacheRegions);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public void evictQueries(String cacheRegion) throws HibernateException {
        QueryCache currentQueryCache;
        if (cacheRegion == null) {
            throw new NullPointerException("use the zero-argument form to evict the default query cache");
        }
        if (this.settings.isQueryCacheEnabled() && (currentQueryCache = this.queryCaches.get(cacheRegion)) != null) {
            currentQueryCache.clear();
        }
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        FilterDefinition def = (FilterDefinition)this.filters.get(filterName);
        if (def == null) {
            throw new HibernateException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    public BatcherFactory getBatcherFactory() {
        return this.settings.getBatcherFactory();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return (IdentifierGenerator)this.identifierGenerators.get(rootEntityName);
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null && this.transactionManager != null) {
            impl = "jta";
        }
        if (impl == null) {
            return null;
        }
        if ("jta".equals(impl)) {
            if (this.settings.getTransactionFactory().areCallbacksLocalToHibernateTransactions()) {
                log.warn("JTASessionContext being used with JDBCTransactionFactory; auto-flush will not operate correctly with getCurrentSession()");
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class implClass = ReflectHelper.classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            log.error("Unable to construct current session context [" + impl + "]", t);
            return null;
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    void serialize(ObjectOutputStream oos) throws IOException {
        oos.writeUTF(this.uuid);
        oos.writeBoolean(this.name != null);
        if (this.name != null) {
            oos.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object result;
        String uuid = ois.readUTF();
        boolean isNamed = ois.readBoolean();
        String name = null;
        if (isNamed) {
            name = ois.readUTF();
        }
        if ((result = SessionFactoryObjectFactory.getInstance(uuid)) == null) {
            log.trace("could not locate session factory by uuid [" + uuid + "] during session deserialization; trying name");
            if (isNamed) {
                result = SessionFactoryObjectFactory.getNamedInstance(name);
            }
            if (result == null) {
                throw new InvalidObjectException("could not resolve session factory during session deserialization [uuid=" + uuid + ", name=" + name + "]");
            }
        }
        return (SessionFactoryImpl)result;
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

