/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LazyInitializationException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.LazyInitializer;

public abstract class AbstractLazyInitializer
implements LazyInitializer {
    private String entityName;
    private Serializable id;
    private Object target;
    private boolean initialized;
    private boolean unwrap;
    private transient SessionImplementor session;

    protected AbstractLazyInitializer() {
    }

    protected AbstractLazyInitializer(String entityName, Serializable id, SessionImplementor session) {
        this.entityName = entityName;
        this.id = id;
        this.session = session;
    }

    @Override
    public final String getEntityName() {
        return this.entityName;
    }

    @Override
    public final Serializable getIdentifier() {
        return this.id;
    }

    @Override
    public final void setIdentifier(Serializable id) {
        this.id = id;
    }

    @Override
    public final boolean isUninitialized() {
        return !this.initialized;
    }

    @Override
    public final SessionImplementor getSession() {
        return this.session;
    }

    @Override
    public final void setSession(SessionImplementor s) throws HibernateException {
        if (s != this.session) {
            if (this.isConnectedToSession()) {
                throw new HibernateException("illegally attempted to associate a proxy with two open Sessions");
            }
            this.session = s;
        }
    }

    @Override
    public void unsetSession() {
        this.session = null;
    }

    @Override
    public final void initialize() throws HibernateException {
        if (!this.initialized) {
            if (this.session == null) {
                throw new LazyInitializationException("could not initialize proxy - no Session");
            }
            if (!this.session.isOpen()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session was closed");
            }
            if (!this.session.isConnected()) {
                throw new LazyInitializationException("could not initialize proxy - the owning Session is disconnected");
            }
            this.target = this.session.immediateLoad(this.entityName, this.id);
            this.initialized = true;
            this.checkTargetState();
        } else {
            this.checkTargetState();
        }
    }

    private void checkTargetState() {
        if (!this.unwrap && this.target == null) {
            this.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(this.entityName, this.id);
        }
    }

    protected final boolean isConnectedToSession() {
        return this.session != null && this.session.isOpen() && this.session.getPersistenceContext().containsProxy(this);
    }

    @Override
    public final Object getImplementation() {
        this.initialize();
        return this.target;
    }

    @Override
    public final void setImplementation(Object target) {
        this.target = target;
        this.initialized = true;
    }

    @Override
    public final Object getImplementation(SessionImplementor s) throws HibernateException {
        EntityKey entityKey = new EntityKey(this.getIdentifier(), s.getFactory().getEntityPersister(this.getEntityName()), s.getEntityMode());
        return s.getPersistenceContext().getEntity(entityKey);
    }

    protected final Object getTarget() {
        return this.target;
    }

    @Override
    public boolean isUnwrap() {
        return this.unwrap;
    }

    @Override
    public void setUnwrap(boolean unwrap) {
        this.unwrap = unwrap;
    }
}

