/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger log = LoggerFactory.getLogger(SchemaValidator.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;

    public SchemaValidator(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaValidator(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
    }

    public SchemaValidator(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new SchemaValidator(cfg).validate();
        }
        catch (Exception e) {
            log.error("Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        log.info("Running schema validator");
        Connection connection = null;
        try {
            DatabaseMetadata meta;
            try {
                log.info("fetching database metadata");
                this.connectionHelper.prepare(false);
                connection = this.connectionHelper.getConnection();
                meta = new DatabaseMetadata(connection, this.dialect, false);
            }
            catch (SQLException sqle) {
                log.error("could not get database metadata", (Throwable)sqle);
                throw sqle;
            }
            this.configuration.validateSchema(this.dialect, meta);
        }
        catch (SQLException e) {
            log.error("could not complete schema validation", (Throwable)e);
        }
        finally {
            try {
                this.connectionHelper.release();
            }
            catch (Exception e) {
                log.error("Error closing connection", (Throwable)e);
            }
        }
    }
}

