/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.transaction.JNDITransactionManagerLookup;
import org.hibernate.util.NamingHelper;

public final class JBossTransactionManagerLookup
extends JNDITransactionManagerLookup {
    public static final String AS4_TM_NAME = "java:/TransactionManager";
    public static final String AS7_TM_NAME = "java:jboss/TransactionManager";

    @Override
    protected String getName() {
        return AS4_TM_NAME;
    }

    @Override
    public String getUserTransactionName() {
        return "UserTransaction";
    }

    @Override
    public TransactionManager getTransactionManager(Properties props) throws HibernateException {
        try {
            return (TransactionManager)NamingHelper.getInitialContext(props).lookup(this.getName());
        }
        catch (NamingException ne) {
            try {
                return (TransactionManager)NamingHelper.getInitialContext(props).lookup(AS7_TM_NAME);
            }
            catch (NamingException ne2) {
                throw new HibernateException("Could not locate TransactionManager", ne2);
            }
        }
    }
}

