/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_0;
import org.omg.GIOP.ReplyStatusType_1_0Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Helper;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContextListHelper;
import org.slf4j.Logger;

public class ReplyOutputStream
extends ServiceContextTransportingOutputStream {
    private final boolean is_locate_reply;
    private final Logger logger;

    public ReplyOutputStream(ORB oRB, int n, ReplyStatusType_1_2 replyStatusType_1_2, int n2, boolean bl, Logger logger) {
        super(oRB);
        this.logger = logger;
        this.is_locate_reply = bl;
        this.setGIOPMinor(n2);
        this.writeGIOPMsgHeader(1, n2);
        switch (n2) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(n);
                ReplyStatusType_1_0Helper.write(this, ReplyStatusType_1_0.from_int(replyStatusType_1_2.value()));
                break;
            }
            case 2: {
                this.write_ulong(n);
                ReplyStatusType_1_2Helper.write(this, replyStatusType_1_2);
                ServiceContextListHelper.write(this, Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write_to(GIOPConnection gIOPConnection) throws IOException {
        block7: {
            if (this.is_locate_reply) {
                ReplyInputStream replyInputStream = new ReplyInputStream(null, this.getBufferCopy());
                try {
                    LocateReplyOutputStream locateReplyOutputStream = this.getLocateReplyOutputStream(replyInputStream);
                    try {
                        locateReplyOutputStream.write_to(gIOPConnection);
                        break block7;
                    }
                    finally {
                        locateReplyOutputStream.close();
                    }
                }
                finally {
                    replyInputStream.close();
                }
            }
            super.write_to(gIOPConnection);
        }
    }

    private LocateReplyOutputStream getLocateReplyOutputStream(ReplyInputStream replyInputStream) {
        LocateReplyOutputStream locateReplyOutputStream;
        block14: {
            block13: {
                if (replyInputStream.getGIOPMinor() >= 2) break block13;
                switch (replyInputStream.rep_hdr.reply_status.value()) {
                    case 0: {
                        int n = replyInputStream.read_boolean() ? 0 : 1;
                        locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, n, replyInputStream.getGIOPMinor());
                        break block14;
                    }
                    case 1: 
                    case 2: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest");
                        }
                        locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 0, replyInputStream.getGIOPMinor());
                        break block14;
                    }
                    case 3: {
                        locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                        locateReplyOutputStream.write_IOR(IORHelper.read(replyInputStream));
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("ReplyStatus is invalid");
                    }
                }
            }
            switch (replyInputStream.rep_hdr.reply_status.value()) {
                case 0: {
                    int n = replyInputStream.read_boolean() ? 0 : 1;
                    locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, n, replyInputStream.getGIOPMinor());
                    break;
                }
                case 1: {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Received an exception when processing a LocateRequest - mapping to UNKNOWN system exception");
                    }
                    locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                    SystemExceptionHelper.write(locateReplyOutputStream, new UNKNOWN());
                    break;
                }
                case 2: {
                    locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                    SystemExceptionHelper.write(locateReplyOutputStream, SystemExceptionHelper.read(replyInputStream));
                    break;
                }
                case 3: {
                    locateReplyOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                    locateReplyOutputStream.write_IOR(IORHelper.read(replyInputStream));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ReplyStatus is invalid");
                }
            }
        }
        return locateReplyOutputStream;
    }
}

