/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.serviceref;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.ServiceRefMetaDataParser;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.xb.QNameBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultServiceRefMetaDataParser
implements ServiceRefMetaDataParser {
    private static final Logger log = Logger.getLogger(DefaultServiceRefMetaDataParser.class);

    public void importStandardXml(Element root, UnifiedServiceRefMetaData sref) {
        sref.setServiceRefName(this.getElementContent(root, "service-ref-name"));
        sref.setServiceInterface(this.getOptionalElementContent(root, "service-interface"));
        sref.setWsdlFile(this.getOptionalElementContent(root, "wsdl-file"));
        sref.setMappingFile(this.getOptionalElementContent(root, "jaxrpc-mapping-file"));
        Element child = DOMUtils.getFirstChildElement((Node)root, (String)"service-qname");
        if (child != null) {
            sref.setServiceQName(QNameBuilder.buildQName((Element)child, (String)this.getTextContent(child)));
        }
        Iterator iterator = DOMUtils.getChildElements((Node)root, (String)"port-component-ref");
        while (iterator.hasNext()) {
            Element pcrefElement = (Element)iterator.next();
            UnifiedPortComponentRefMetaData pcrefMetaData = new UnifiedPortComponentRefMetaData(sref);
            pcrefMetaData.importStandardXml(pcrefElement);
            sref.addPortComponentRef(pcrefMetaData);
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"handler");
        while (iterator.hasNext()) {
            Element handlerElement = (Element)iterator.next();
            UnifiedHandlerMetaData handlerMetaData = new UnifiedHandlerMetaData();
            handlerMetaData.importStandardXml(handlerElement);
            sref.addHandler(handlerMetaData);
        }
    }

    public void importJBossXml(Element root, UnifiedServiceRefMetaData sref) {
        sref.setConfigName(this.getOptionalElementContent(root, "config-name"));
        sref.setConfigFile(this.getOptionalElementContent(root, "config-file"));
        sref.setWsdlOverride(this.getOptionalElementContent(root, "wsdl-override"));
        Iterator iterator = DOMUtils.getChildElements((Node)root, (String)"port-component-ref");
        while (iterator.hasNext()) {
            QName portName;
            Element pcrefElement = (Element)iterator.next();
            String seiName = this.getOptionalElementContent(pcrefElement, "service-endpoint-interface");
            UnifiedPortComponentRefMetaData pcref = sref.getPortComponentRef(seiName, portName = this.getOptionalElementContentAsQName(pcrefElement, "port-qname"));
            if (pcref == null && seiName != null) {
                pcref = new UnifiedPortComponentRefMetaData(sref);
                pcref.importStandardXml(pcrefElement);
                sref.addPortComponentRef(pcref);
            }
            if (pcref == null) continue;
            pcref.importJBossXml(pcrefElement);
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"call-property");
        while (iterator.hasNext()) {
            Element propElement = (Element)iterator.next();
            String name = this.getElementContent(propElement, "prop-name");
            String value = this.getElementContent(propElement, "prop-value");
            sref.addCallProperty(new UnifiedCallPropertyMetaData(name, value));
        }
    }

    public void importStandardXml(Element root, UnifiedPortComponentRefMetaData pcref) {
        pcref.setServiceEndpointInterface(this.getOptionalElementContent(root, "service-endpoint-interface"));
        pcref.setPortComponentLink(this.getOptionalElementContent(root, "port-component-link"));
    }

    public void importJBossXml(Element root, UnifiedPortComponentRefMetaData pcref) {
        Element sei;
        Element configFile;
        Element configName;
        String value;
        String name;
        Element propElement;
        Iterator iterator = DOMUtils.getChildElements((Node)root, (String)"call-property");
        while (iterator.hasNext()) {
            propElement = (Element)iterator.next();
            name = this.getElementContent(propElement, "prop-name");
            value = this.getElementContent(propElement, "prop-value");
            pcref.addCallProperty(new UnifiedCallPropertyMetaData(name, value));
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"stub-property");
        while (iterator.hasNext()) {
            propElement = (Element)iterator.next();
            name = this.getElementContent(propElement, "prop-name");
            value = this.getElementContent(propElement, "prop-value");
            UnifiedStubPropertyMetaData propMetaData = new UnifiedStubPropertyMetaData();
            propMetaData.setPropName(name);
            propMetaData.setPropValue(value);
            pcref.addStubProperty(propMetaData);
        }
        QName portQName = this.getOptionalElementContentAsQName(root, "port-qname");
        if (portQName != null) {
            pcref.setPortQName(portQName);
        }
        if ((configName = DOMUtils.getFirstChildElement((Node)root, (String)"config-name")) != null) {
            pcref.setConfigName(this.getTextContent(configName));
        }
        if ((configFile = DOMUtils.getFirstChildElement((Node)root, (String)"config-file")) != null) {
            pcref.setConfigFile(this.getTextContent(configFile));
        }
        if ((sei = DOMUtils.getFirstChildElement((Node)root, (String)"service-endpoint-interface")) != null) {
            pcref.setServiceEndpointInterface(this.getTextContent(sei));
        }
    }

    public void importStandardXml(Element root, UnifiedHandlerMetaData href) {
        String content;
        href.setHandlerName(this.getElementContent(root, "handler-name"));
        href.setHandlerClass(this.getElementContent(root, "handler-class"));
        Iterator iterator = DOMUtils.getChildElements((Node)root, (String)"init-param");
        while (iterator.hasNext()) {
            Element paramElement = (Element)iterator.next();
            UnifiedInitParamMetaData param = new UnifiedInitParamMetaData();
            param.setParamName(this.getElementContent(paramElement, "param-name"));
            param.setParamValue(this.getElementContent(paramElement, "param-value"));
            href.addInitParam(param);
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"soap-header");
        while (iterator.hasNext()) {
            Element headerElement = (Element)iterator.next();
            content = this.getTextContent(headerElement);
            QName qname = DOMUtils.resolveQName((Element)headerElement, (String)content);
            href.addSoapHeader(qname);
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"soap-role");
        while (iterator.hasNext()) {
            Element roleElement = (Element)iterator.next();
            content = this.getTextContent(roleElement);
            href.addSoapRole(content);
        }
        iterator = DOMUtils.getChildElements((Node)root, (String)"port-name");
        while (iterator.hasNext()) {
            Element portElement = (Element)iterator.next();
            content = this.getTextContent(portElement);
            href.addPortName(content);
        }
    }

    private String getElementContent(Element element, String childName) {
        String childValue = this.getOptionalElementContent(element, childName);
        if (childValue == null || childValue.length() == 0) {
            throw new IllegalStateException("Invalid null element content: " + childName);
        }
        return childValue;
    }

    private String getOptionalElementContent(Element element, String childName) {
        return this.getTextContent(DOMUtils.getFirstChildElement((Node)element, (String)childName));
    }

    private QName getOptionalElementContentAsQName(Element element, String childName) {
        QName qname = null;
        String value = this.getOptionalElementContent(element, childName);
        if (value != null) {
            qname = value.startsWith("{") ? QName.valueOf(value) : DOMUtils.resolveQName((Element)element, (String)value);
        }
        return qname;
    }

    private String getTextContent(Element element) {
        String content = null;
        if (element != null && (content = DOMUtils.getTextContent((Node)element)) != null) {
            content = content.trim();
        }
        return content;
    }
}

