/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.TimeoutException;
import org.jgroups.stack.Interval;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class TimeSchedulerTest
extends TestCase {
    TimeScheduler timer = null;
    static final int NUM_MSGS = 1000;
    static long[] xmit_timeouts = new long[]{1000L, 2000L, 4000L, 8000L};
    static double PERCENTAGE_OFF = 0.3;
    HashMap<Long, Entry> msgs = new HashMap();

    public TimeSchedulerTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.timer = new TimeScheduler();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.timer.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testCancel() throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            this.timer.scheduleWithDynamicInterval(new OneTimeTask(1000L));
        }
        TimeSchedulerTest.assertEquals((int)10, (int)this.timer.size());
        this.timer.stop();
        TimeSchedulerTest.assertEquals((int)0, (int)this.timer.size());
    }

    public void testTaskCancellationBeforeTaskHasRun() {
        StressTask task = new StressTask();
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertEquals((int)1, (int)this.timer.size());
        future.cancel(true);
        TimeSchedulerTest.assertEquals((int)1, (int)this.timer.size());
        Util.sleep(200L);
        int num_executions = task.getNum_executions();
        System.out.println("number of task executions=" + num_executions);
        TimeSchedulerTest.assertEquals((String)"task should never have executed as it was cancelled before execution", (int)0, (int)num_executions);
        this.timer.purge();
        TimeSchedulerTest.assertEquals((int)0, (int)this.timer.size());
    }

    public void testTaskCancellationAfterHasRun() {
        StressTask task = new StressTask();
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertEquals((int)1, (int)this.timer.size());
        Util.sleep(200L);
        future.cancel(true);
        TimeSchedulerTest.assertEquals((int)1, (int)this.timer.size());
        int num_executions = task.getNum_executions();
        System.out.println("number of task executions=" + num_executions);
        TimeSchedulerTest.assertTrue((String)"task should have executed at least 1 time, as it was cancelled after 200ms", (num_executions >= 1 ? 1 : 0) != 0);
        this.timer.purge();
        TimeSchedulerTest.assertEquals((int)0, (int)this.timer.size());
    }

    public void testRepeatingTask() {
        System.out.println(System.currentTimeMillis() + ": adding task");
        RepeatingTask task = new RepeatingTask(500L);
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        Util.sleep(5000L);
        System.out.println("<<< cancelling task");
        future.cancel(true);
        Util.sleep(2000L);
        int num = task.getNum();
        System.out.println("task executed " + num + " times");
        TimeSchedulerTest.assertTrue((num >= 9 && num < 11 ? 1 : 0) != 0);
    }

    public void testStress() {
        int i;
        for (i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                StressTask t = new StressTask();
                ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(t);
                future.cancel(true);
            }
            System.out.println(i + ": " + this.timer.size());
        }
        for (i = 0; i < 10; ++i) {
            System.out.println(this.timer.size());
            Util.sleep(500L);
        }
        TimeSchedulerTest.assertEquals((int)0, (int)this.timer.size());
    }

    public void testDynamicTask() throws InterruptedException {
        DynamicTask task = new DynamicTask();
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertEquals((int)1, (int)this.timer.getQueue().size());
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        Thread.sleep(3000L);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        future.cancel(true);
        TimeSchedulerTest.assertTrue((boolean)future.isCancelled());
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
    }

    public void testDynamicTaskCancel() throws InterruptedException {
        DynamicTask task = new DynamicTask();
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        Thread.sleep(3000L);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        boolean success = future.cancel(true);
        TimeSchedulerTest.assertTrue((boolean)success);
        TimeSchedulerTest.assertTrue((boolean)future.isCancelled());
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
        success = future.cancel(true);
        TimeSchedulerTest.assertTrue((boolean)success);
    }

    public void testIsDone() throws InterruptedException {
        DynamicTask task = new DynamicTask();
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        Thread.sleep(3000L);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        future.cancel(true);
        TimeSchedulerTest.assertTrue((boolean)future.isCancelled());
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
    }

    public void testIsDone2() throws InterruptedException {
        DynamicTask task = new DynamicTask(new long[]{1000L, 2000L, -1L});
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertFalse((boolean)future.isDone());
        Thread.sleep(3500L);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
        boolean success = future.cancel(true);
        if (success) {
            TimeSchedulerTest.assertTrue((boolean)future.isCancelled());
        } else {
            TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        }
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
    }

    public void testIsDone3() throws InterruptedException {
        DynamicTask task = new DynamicTask(new long[]{-1L});
        ScheduledFuture<?> future = this.timer.scheduleWithDynamicInterval(task);
        Thread.sleep(100L);
        TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
        boolean success = future.cancel(true);
        if (success) {
            TimeSchedulerTest.assertTrue((boolean)future.isCancelled());
        } else {
            TimeSchedulerTest.assertFalse((boolean)future.isCancelled());
        }
        TimeSchedulerTest.assertTrue((boolean)future.isDone());
    }

    public void testImmediateExecution() {
        Promise p = new Promise();
        ImmediateTask task = new ImmediateTask(p);
        this.timer.execute(task);
        try {
            long start = System.currentTimeMillis();
            p.getResultWithTimeout(5L);
            long stop = System.currentTimeMillis();
            System.out.println("task took " + (stop - start) + "ms");
        }
        catch (TimeoutException e) {
            TimeSchedulerTest.fail((String)"ran into timeout - task should have executed immediately");
        }
    }

    public void test2Tasks() throws InterruptedException {
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
        int size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)1, (int)size);
        Thread.sleep(1000L);
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)0, (int)size);
        Thread.sleep(1500L);
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
        System.out.println(System.currentTimeMillis() + ": adding task");
        this.timer.schedule(new MyTask(), 500L, TimeUnit.MILLISECONDS);
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)3, (int)size);
        Thread.sleep(1000L);
        size = this.timer.size();
        System.out.println("queue size=" + size);
        TimeSchedulerTest.assertEquals((int)0, (int)size);
    }

    public void testRetransmits() throws InterruptedException {
        Entry entry;
        long i;
        int num_non_correct_entries = 0;
        System.out.println("-- adding 1000 messages:");
        for (i = 0L; i < 1000L; ++i) {
            entry = new Entry(i);
            this.msgs.put(new Long(i), entry);
            this.timer.scheduleWithDynamicInterval(entry);
        }
        System.out.println("-- done");
        System.out.println("-- waiting for 20 secs for all retransmits");
        Thread.sleep(20000L);
        for (i = 0L; i < 1000L; ++i) {
            entry = this.msgs.get(new Long(i));
            if (entry.isCorrect()) continue;
            ++num_non_correct_entries;
        }
        if (num_non_correct_entries > 0) {
            System.err.println("Number of incorrect retransmission timeouts: " + num_non_correct_entries);
        } else {
            for (i = 0L; i < 1000L; ++i) {
                entry = this.msgs.get(new Long(i));
                if (entry == null) continue;
                System.out.println(i + ": " + entry);
            }
        }
        TimeSchedulerTest.assertEquals((int)0, (int)num_non_correct_entries);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TimeSchedulerTest.class);
        return suite;
    }

    public static void main(String[] args) {
        String[] name = new String[]{TimeSchedulerTest.class.getName()};
        TestRunner.main((String[])name);
    }

    private static class Entry
    implements TimeScheduler.Task {
        long start_time = 0L;
        long first_xmit = 0L;
        long second_xmit = 0L;
        long third_xmit = 0L;
        long fourth_xmit = 0L;
        boolean cancelled = false;
        Interval interval = new StaticInterval(xmit_timeouts);
        long seqno = 0L;

        Entry(long seqno) {
            this.seqno = seqno;
            this.start_time = System.currentTimeMillis();
        }

        @Override
        public long nextInterval() {
            return this.interval.next();
        }

        @Override
        public void run() {
            if (this.first_xmit == 0L) {
                this.first_xmit = System.currentTimeMillis();
            } else if (this.second_xmit == 0L) {
                this.second_xmit = System.currentTimeMillis();
            } else if (this.third_xmit == 0L) {
                this.third_xmit = System.currentTimeMillis();
            } else if (this.fourth_xmit == 0L) {
                this.fourth_xmit = System.currentTimeMillis();
            }
        }

        boolean isCorrect() {
            long delta;
            boolean off = false;
            long expected = xmit_timeouts[0];
            long t = this.first_xmit - this.start_time;
            long diff = Math.abs(expected - t);
            if (diff >= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = xmit_timeouts[1]) - (t = this.second_xmit - this.first_xmit))) >= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = xmit_timeouts[2]) - (t = this.third_xmit - this.second_xmit))) >= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                off = true;
            }
            if ((diff = Math.abs((expected = xmit_timeouts[3]) - (t = this.fourth_xmit - this.third_xmit))) >= (delta = (long)((double)expected * PERCENTAGE_OFF))) {
                off = true;
            }
            if (off) {
                System.err.println("#" + this.seqno + ": " + this + ": (" + "entry is more than " + PERCENTAGE_OFF + " percentage off ");
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.first_xmit - this.start_time).append(", ").append(this.second_xmit - this.first_xmit).append(", ");
            sb.append(this.third_xmit - this.second_xmit).append(", ").append(this.fourth_xmit - this.third_xmit);
            return sb.toString();
        }
    }

    static class StressTask
    implements TimeScheduler.Task {
        boolean cancelled = false;
        int num_executions = 0;

        StressTask() {
        }

        public int getNum_executions() {
            return this.num_executions;
        }

        @Override
        public long nextInterval() {
            return 50L;
        }

        @Override
        public void run() {
            ++this.num_executions;
        }
    }

    static class RepeatingTask
    extends OneTimeTask {
        int num = 0;

        RepeatingTask(long timeout) {
            super(timeout);
        }

        public int getNum() {
            return this.num;
        }

        @Override
        public void run() {
            System.out.println(this.num + 1 + ": this is the repeating task");
            ++this.num;
        }
    }

    static class OneTimeTask
    implements TimeScheduler.Task {
        boolean done = false;
        private long timeout = 0L;

        OneTimeTask(long timeout) {
            this.timeout = timeout;
        }

        @Override
        public long nextInterval() {
            return this.timeout;
        }

        @Override
        public void run() {
            System.out.println(System.currentTimeMillis() + ": this is MyTask running - done");
            this.done = true;
        }
    }

    static class DynamicTask
    implements TimeScheduler.Task {
        long[] times = new long[]{1000L, 2000L, 4000L};
        int index = 0;

        public DynamicTask() {
        }

        public DynamicTask(long[] times) {
            this.times = times;
        }

        @Override
        public long nextInterval() {
            if (this.index == this.times.length - 1) {
                return this.times[this.index];
            }
            return this.times[this.index++];
        }

        @Override
        public void run() {
            System.out.println("dynamic task run at " + new Date());
        }
    }

    static class MyTask
    implements Runnable {
        MyTask() {
        }

        @Override
        public void run() {
            System.out.println(System.currentTimeMillis() + ": this is MyTask running - done");
        }
    }

    private static class ImmediateTask
    implements Runnable {
        Promise p;

        public ImmediateTask(Promise p) {
            this.p = p;
        }

        @Override
        public void run() {
            this.p.setResult(Boolean.TRUE);
        }
    }
}

