/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;

public class SecurityContextAssociation {
    private static boolean SERVER = true;
    private static SecurityContext securityContext = null;
    private static RuntimePermission SetSecurityContextPermission = new RuntimePermission("org.jboss.security.setSecurityContext");
    private static RuntimePermission GetSecurityContextPermission = new RuntimePermission("org.jboss.security.getSecurityContext");
    private static RuntimePermission ClearSecurityContextPermission = new RuntimePermission("org.jboss.security.clearSecurityContext");
    public static final String SECURITYCONTEXT_THREADLOCAL = "org.jboss.security.context.ThreadLocal";
    private static final String SECURITYASSOCIATION_THREADLOCAL = "org.jboss.security.SecurityAssociation.ThreadLocal";
    private static ThreadLocal<SecurityContext> securityContextLocal;

    public static boolean isClient() {
        return !SERVER;
    }

    public static void setClient() {
        SERVER = false;
    }

    public static void setSecurityContext(SecurityContext sc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SetSecurityContextPermission);
        }
        if (!SERVER) {
            securityContext = sc;
        } else if (sc == null) {
            securityContextLocal.remove();
        } else {
            securityContextLocal.set(sc);
        }
    }

    public static SecurityContext getSecurityContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GetSecurityContextPermission);
        }
        if (!SERVER) {
            return securityContext;
        }
        return securityContextLocal.get();
    }

    public static void clearSecurityContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ClearSecurityContextPermission);
        }
        if (!SERVER) {
            securityContext = null;
        } else {
            securityContextLocal.remove();
        }
    }

    private static String getSystemProperty(final String propertyName, final String defaultString) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultString);
            }
        });
    }

    static {
        String saflag = SecurityContextAssociation.getSystemProperty(SECURITYASSOCIATION_THREADLOCAL, "false");
        String scflag = SecurityContextAssociation.getSystemProperty(SECURITYCONTEXT_THREADLOCAL, "false");
        boolean useThreadLocal = Boolean.valueOf(saflag) != false || Boolean.valueOf(scflag) != false;
        securityContextLocal = useThreadLocal ? new ThreadLocal() : new InheritableThreadLocal<SecurityContext>();
    }
}

