/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.jpa.jbpapp9336;

/**
 * @author Navin Surtani (navssurtani)
 * 
 * Interface designed to access the SLSB {@link HandlerTestBean}
 */

public interface HandlerTest {

    /**
     * Method that will be used to create and EWHA.
     * 
     * @param handler
     * @return - the newly created EWHA.
     */
    
    public EntityWithHandlerAttribute createEntityWithHandlerAttribute(String handler);
    
    /**
     * Call using the id of the EWHA to actually get hold of the EWHA instance.
     * 
     * @param id
     * @return - the EWHA.
     */
    public EntityWithHandlerAttribute loadEntityWithHandlerAttribute(Long id);
}
