package org.jboss.seam.test.integration.bpm;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.TransactionPropagationType;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.annotations.bpm.CreateProcess;

@Name("seamExpressionEvaluatorTestController")
public class SeamExpressionEvaluatorTestController {
       
   private String name = "foo";
   
   @Factory(value="testBoolean", scope=ScopeType.BUSINESS_PROCESS)
   public Boolean testNameFactory()
   {
      return false;
   }
   
   @CreateProcess(definition="TestProcess2") 
   public void createProcess2() 
   {            
   }
   
   @CreateProcess(definition="TestProcess3") 
   public void createProcess3() 
   {            
   }
   
   @CreateProcess(definition="TestProcess4") 
   public void createProcess4() 
   {
   }
   
   @CreateProcess(definition="TestProcess5") 
   public void createProcess5() 
   {
   }
   
   public void logTrue()
   {
      System.out.println("true");
   }
   
   public void log()
   {
      System.out.println("After Shipping");
   }
   
   public String getName()
   {
      return this.name;
   }
   
   public void setName(String name)
   {
      this.name = name;
   }
   
   public void exceptionThrowing()
   {
      throw new RuntimeException("Exception is thrown - test handling");
   }   
   
   @Asynchronous //@Transactional(TransactionPropagationType.REQUIRED)
   public void asyncExceptionThrowing()
   {
      System.out.println("calling async method ********************");
      //throw new RuntimeException("Exception is thrown - test handling");
   }
    
}