/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jDimension;
import org.olap4j.driver.xmla.XmlaOlap4jElement;
import org.olap4j.driver.xmla.XmlaOlap4jHierarchy;
import org.olap4j.driver.xmla.XmlaOlap4jLevel;
import org.olap4j.driver.xmla.XmlaOlap4jMemberBase;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayMap;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jMember
extends XmlaOlap4jElement
implements XmlaOlap4jMemberBase,
Member,
Named {
    private final XmlaOlap4jLevel olap4jLevel;
    private final String parentMemberUniqueName;
    private final Member.Type type;
    private XmlaOlap4jMember parentMember;
    private final int childMemberCount;
    private final int ordinal;
    private final Map<Property, Object> propertyValueMap;

    XmlaOlap4jMember(XmlaOlap4jLevel olap4jLevel, String uniqueName, String name, String caption, String description, String parentMemberUniqueName, Member.Type type, int childMemberCount, int ordinal, Map<Property, Object> propertyValueMap) {
        super(uniqueName, name, caption, description);
        this.ordinal = ordinal;
        assert (olap4jLevel != null);
        assert (type != null);
        this.olap4jLevel = olap4jLevel;
        this.parentMemberUniqueName = parentMemberUniqueName;
        this.type = type;
        this.childMemberCount = childMemberCount;
        this.propertyValueMap = UnmodifiableArrayMap.of(propertyValueMap);
    }

    @Override
    public int hashCode() {
        return this.uniqueName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof XmlaOlap4jMember && ((XmlaOlap4jMember)obj).uniqueName.equals(this.uniqueName);
    }

    public NamedList<? extends Member> getChildMembers() throws OlapException {
        NamedListImpl list = new NamedListImpl();
        this.getCube().getMetadataReader().lookupMemberRelatives(Olap4jUtil.enumSetOf((Enum)Member.TreeOp.CHILDREN, (Enum[])new Member.TreeOp[0]), this.uniqueName, (List<XmlaOlap4jMember>)list);
        return list;
    }

    public int getChildMemberCount() {
        return this.childMemberCount;
    }

    public XmlaOlap4jMember getParentMember() {
        if (this.parentMemberUniqueName == null) {
            return null;
        }
        if (this.parentMember == null) {
            try {
                this.parentMember = this.getCube().getMetadataReader().lookupMemberByUniqueName(this.parentMemberUniqueName);
            }
            catch (OlapException e) {
                throw new RuntimeException("yuck!");
            }
        }
        return this.parentMember;
    }

    public XmlaOlap4jLevel getLevel() {
        return this.olap4jLevel;
    }

    public XmlaOlap4jHierarchy getHierarchy() {
        return this.olap4jLevel.olap4jHierarchy;
    }

    public XmlaOlap4jDimension getDimension() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension;
    }

    public Member.Type getMemberType() {
        return this.type;
    }

    public boolean isAll() {
        return this.type == Member.Type.ALL;
    }

    public boolean isChildOrEqualTo(Member member) {
        throw new UnsupportedOperationException();
    }

    public boolean isCalculated() {
        return this.type == Member.Type.FORMULA;
    }

    public int getSolveOrder() {
        return -1;
    }

    public ParseTreeNode getExpression() {
        throw new UnsupportedOperationException();
    }

    public List<Member> getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (XmlaOlap4jMember m = this.getParentMember(); m != null; m = m.getParentMember()) {
            list.add(m);
        }
        return list;
    }

    public boolean isCalculatedInQuery() {
        return false;
    }

    public Object getPropertyValue(Property property) throws OlapException {
        return XmlaOlap4jMember.getPropertyValue(property, this, this.propertyValueMap);
    }

    static Object getPropertyValue(Property property, XmlaOlap4jMemberBase member, Map<Property, Object> propertyValueMap) throws OlapException {
        Object value = propertyValueMap.get(property);
        if (value != null || propertyValueMap.containsKey(property)) {
            return value;
        }
        if (property instanceof Property.StandardMemberProperty) {
            Property.StandardMemberProperty o = (Property.StandardMemberProperty)property;
            switch (o) {
                case MEMBER_CAPTION: {
                    return member.getCaption();
                }
                case MEMBER_NAME: {
                    return member.getName();
                }
                case MEMBER_UNIQUE_NAME: {
                    return member.getUniqueName();
                }
                case CATALOG_NAME: {
                    return member.getCatalog().getName();
                }
                case CHILDREN_CARDINALITY: {
                    return member.getChildMemberCount();
                }
                case CUBE_NAME: {
                    return member.getCube().getName();
                }
                case DEPTH: {
                    return member.getDepth();
                }
                case DESCRIPTION: {
                    return member.getDescription();
                }
                case DIMENSION_UNIQUE_NAME: {
                    return member.getDimension().getUniqueName();
                }
                case DISPLAY_INFO: {
                    return null;
                }
                case HIERARCHY_UNIQUE_NAME: {
                    return member.getHierarchy().getUniqueName();
                }
                case LEVEL_NUMBER: {
                    return member.getLevel().getDepth();
                }
                case LEVEL_UNIQUE_NAME: {
                    return member.getLevel().getUniqueName();
                }
                case MEMBER_GUID: {
                    return null;
                }
                case MEMBER_ORDINAL: {
                    return member.getOrdinal();
                }
                case MEMBER_TYPE: {
                    return member.getMemberType();
                }
                case PARENT_COUNT: {
                    return 1;
                }
                case PARENT_LEVEL: {
                    return member.getParentMember() == null ? 0 : member.getParentMember().getLevel().getDepth();
                }
                case PARENT_UNIQUE_NAME: {
                    return member.getParentMember() == null ? null : member.getParentMember().getUniqueName();
                }
                case SCHEMA_NAME: {
                    return member.getCube().olap4jSchema.getName();
                }
                case VALUE: {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public XmlaOlap4jCube getCube() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube;
    }

    @Override
    public XmlaOlap4jCatalog getCatalog() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube.olap4jSchema.olap4jCatalog;
    }

    @Override
    public XmlaOlap4jConnection getConnection() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
    }

    @Override
    public Map<Property, Object> getPropertyValueMap() {
        return this.propertyValueMap;
    }

    public String getPropertyFormattedValue(Property property) throws OlapException {
        return String.valueOf(this.getPropertyValue(property));
    }

    public void setProperty(Property property, Object value) {
        this.propertyValueMap.put(property, value);
    }

    public NamedList<Property> getProperties() {
        return this.olap4jLevel.getProperties();
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public boolean isHidden() {
        return false;
    }

    public int getDepth() {
        Object depth = this.propertyValueMap.get(Property.StandardMemberProperty.DEPTH);
        if (depth == null) {
            return this.olap4jLevel.getDepth();
        }
        return XmlaOlap4jMember.toInteger(depth);
    }

    static int toInteger(Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.intValue();
        }
        return Integer.valueOf(o.toString());
    }

    public Member getDataMember() {
        return null;
    }
}

