/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.OlapException;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.Member;
import org.olap4j.query.Query;
import org.olap4j.query.QueryDimension;
import org.olap4j.query.QueryNode;
import org.olap4j.query.QueryNodeImpl;
import org.olap4j.query.SortOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAxis
extends QueryNodeImpl {
    protected final List<QueryDimension> dimensions = new DimensionList();
    private final Query query;
    protected Axis location = null;
    private boolean nonEmpty;
    private SortOrder sortOrder = null;
    private String sortEvaluationLiteral = null;

    public QueryAxis(Query query, Axis location) {
        this.query = query;
        this.location = location;
    }

    public Axis getLocation() {
        return this.location;
    }

    public List<QueryDimension> getDimensions() {
        return this.dimensions;
    }

    public String getName() {
        return this.location.getCaption(this.query.getLocale());
    }

    public void pullUp(int index) {
        HashMap<Integer, QueryNode> removed = new HashMap<Integer, QueryNode>();
        removed.put(index, this.dimensions.get(index));
        HashMap<Integer, QueryNode> added = new HashMap<Integer, QueryNode>();
        added.put(index - 1, this.dimensions.get(index));
        Collections.swap(this.dimensions, index, index - 1);
        this.notifyRemove(removed);
        this.notifyAdd(added);
    }

    public void pushDown(int index) {
        HashMap<Integer, QueryNode> removed = new HashMap<Integer, QueryNode>();
        removed.put(index, this.dimensions.get(index));
        HashMap<Integer, QueryNode> added = new HashMap<Integer, QueryNode>();
        added.put(index + 1, this.dimensions.get(index));
        Collections.swap(this.dimensions, index, index + 1);
        this.notifyRemove(removed);
        this.notifyAdd(added);
    }

    public void addDimension(QueryDimension dimension) {
        this.getDimensions().add(dimension);
        Integer index = this.getDimensions().indexOf(dimension);
        this.notifyAdd(dimension, index);
    }

    public void addDimension(int index, QueryDimension dimension) {
        this.getDimensions().add(index, dimension);
        this.notifyAdd(dimension, index);
    }

    public void removeDimension(QueryDimension dimension) {
        Integer index = this.getDimensions().indexOf(dimension);
        this.getDimensions().remove(dimension);
        this.notifyRemove(dimension, index);
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    @Override
    void tearDown() {
        for (QueryDimension node : this.getDimensions()) {
            node.tearDown();
        }
        this.clearListeners();
        this.getDimensions().clear();
    }

    public void sort(SortOrder order) throws OlapException {
        this.sort(order, this.query.getCube().getDimensions().get("Measures").getDefaultHierarchy().getDefaultMember());
    }

    public void sort(SortOrder order, List<IdentifierSegment> nameParts) throws OlapException {
        assert (order != null);
        assert (nameParts != null);
        Member member = this.query.getCube().lookupMember(nameParts);
        if (member == null) {
            throw new OlapException("Cannot find member.");
        }
        this.sort(order, member);
    }

    public void sort(SortOrder order, Member member) {
        assert (order != null);
        assert (member != null);
        this.sort(order, member.getUniqueName());
    }

    public void sort(SortOrder order, String sortEvaluationLiteral) {
        assert (order != null);
        assert (sortEvaluationLiteral != null);
        this.sortOrder = order;
        this.sortEvaluationLiteral = sortEvaluationLiteral;
    }

    public void clearSort() {
        this.sortEvaluationLiteral = null;
        this.sortOrder = null;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getSortIdentifierNodeName() {
        return this.sortEvaluationLiteral;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DimensionList
    extends AbstractList<QueryDimension> {
        private final List<QueryDimension> list = new ArrayList<QueryDimension>();

        private DimensionList() {
        }

        @Override
        public QueryDimension get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public QueryDimension set(int index, QueryDimension dimension) {
            if (dimension.getAxis() != null && dimension.getAxis() != QueryAxis.this) {
                dimension.getAxis().getDimensions().remove(dimension);
            }
            dimension.setAxis(QueryAxis.this);
            return this.list.set(index, dimension);
        }

        @Override
        public void add(int index, QueryDimension dimension) {
            if (this.contains(dimension)) {
                throw new IllegalStateException("dimension already on this axis");
            }
            if (dimension.getAxis() != null && dimension.getAxis() != QueryAxis.this) {
                dimension.getAxis().getDimensions().remove(dimension);
            }
            dimension.setAxis(QueryAxis.this);
            if (index >= this.list.size()) {
                this.list.add(dimension);
            } else {
                this.list.add(index, dimension);
            }
        }

        @Override
        public QueryDimension remove(int index) {
            QueryDimension dimension = this.list.remove(index);
            dimension.setAxis(null);
            return dimension;
        }
    }
}

