# McStringerson: Source code string key localization verification tool.
# Verifies that all of the langpack string keys used in the source code have 
# been localized in the language file."
#
# Author: fcanas@redhat.com
#
# Needs BeautifulSoup to run:
# sudo pip install BeautifulSoup
# 
# If you don't have pip, then:
# sudo yum install python-pip
#
from bs4 import BeautifulSoup
import argparse
import subprocess
import re

whitelist = ["userInputSpec.xml","install.xml",".java"]

def parse_key_list_from_output(output,xml=False):
	lines = output.split(" ")
	if xml:
		key_pattern = "id=\"(.*)\""
	else:
		key_pattern = "getString\(\"(.*)\"\)"
	loc_pattern = "(.*):"
	keys_and_location = []
	keys = []
	
	for line in lines:
		match_key = re.search(key_pattern, line)
		match_loc = re.search(loc_pattern, line)
		loc_key = re.search(loc_pattern, line)
		if match_key:
			keys.append(match_key.group(1))
		if loc_key and match_key:
			for file_type in whitelist:
				if file_type in match_loc.group(1):
					keys_and_location.append((match_key.group(1),match_loc.group(1)))
					break		
	# TODO: Handle duplicates a little better
	return list(set(keys)), list(set(keys_and_location))

def find_missing_keys(src_keys_list, path_to_langfile):
	string_file = BeautifulSoup(open(path_to_langfile))
	strings_list  = string_file.find_all('str')
	keys_list = [s['id'] for s in strings_list]
	return [ key for key in src_keys_list if key not in keys_list]

def report(missing_keys, keys_and_locations, langfile_path):

	if missing_keys:
		print "=" * 100
		print "Keys used in source code and missing from " + langfile_path
		print "=" * 100
		for pair in keys_and_locations:
			if pair[0] in missing_keys:
				print "Key: " + pair[0]
				print "Location: " + pair[1]
		print

if __name__=="__main__":
    parser = argparse.ArgumentParser(
            description="Verifies that all of the langpack string keys used in the source code have been localized in the language file.")
    parser.add_argument("source_path",
            help="The path to the source code to check for string keys.")
    parser.add_argument("language_file",
            help="The xml language file to check for missing key strings.")
    parser.add_argument("--xml", action="store_true",
            help="Look for string keys in .xml spec files instead of .java files.")
   
    args=parser.parse_args()
    print "[ Running Grep ]"
    if args.xml:
    	pattern = "id="
    else:
    	pattern = "langpack.getString"

    cmd = ["""/bin/grep -R '""" + pattern + """' """ + args.source_path]
    output = subprocess.check_output(cmd,shell=True)

    print "[ Parsing Keys from Source ]"
    keys, keys_and_locations = parse_key_list_from_output(output, args.xml)

    print "[ Searching for Missing Keys ]"
    missing = find_missing_keys(keys, args.language_file)

    print "[ Results ]"
    report(missing, keys_and_locations, args.language_file)






	