package com.redhat.installer.validator;

import java.util.ArrayList;
import java.util.regex.Pattern;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

public class DirectoryValidator  implements Validator, DataValidator {
	AutomatedInstallData idata;
	String error;
	public boolean validate(ProcessingClient client) //Validator for UserInputSpec
	{
		idata = AutomatedInstallData.getInstance();
		int numFields = client.getNumFields();
		
        for (int i = 0; i < numFields; i++)
        {
            if (!checkDirectory(client.getFieldContents(i)))
    		{
            	return false;
    		}
        } 
        return true;
	}

	public Status validateData(AutomatedInstallData idata) //Validator for target panel
	{
		String path = idata.getVariable("INSTALL_PATH");
		if (!checkDirectory(path))
		{
			setError(idata.langpack.getString("TargetPanel.invalid"));
			return Status.ERROR;
		}
		return Status.OK;
	}
	
	private boolean checkDirectory(String path)
	{
        String filteredPath = path;
        String pathValidator = "[^\\[\\];,|:]+";
        String windowPathValidator = "[a-zA-Z]:[^\\[\\];,|:\\/\\*\\?<>]*[^ ]";
        //Forwardslash slash not included because installer will end up creating directory with backslash
        String[] invalidWindowCharacters = {"<", ">", ":", "\"", "\\\\", "|", "?", "*", "[", "]", "(", ")"};


        ArrayList<String> invalidCharacters = new ArrayList<String>();
        invalidCharacters.add("\\0"); //No null character
        invalidCharacters.add("  ");  //No consecutive spaces
        invalidCharacters.add(" \\"); //No Trailing space followed by a backslash
        invalidCharacters.add("@"); //No Trailing space followed by a backslash

        if(System.getProperty("os.name").toLowerCase().contains("window"))
        {
            pathValidator = windowPathValidator;
            for (String character : invalidWindowCharacters){
                invalidCharacters.add(character);
            }
            filteredPath = path.substring(2, path.length()); //Remove starting drive

        }

        if (!Pattern.matches(pathValidator, path)) return false;
        for (String character : invalidCharacters){
            if (filteredPath.contains(character)) return false;
        }

        return true;
	}
	
	public void setError(String e)
	{
		this.error= e;
	}
	public String getErrorMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	public String getWarningMessageId() {
		// TODO Auto-generated method stub
		return error;
	}

	public boolean getDefaultAnswer() {
		// TODO Auto-generated method stub
		return false;
	}
}
