# Zoidberg: Zanata Translations Counter
# Run this in the langpacks directory to generate information on missing Strings
# needed for translations.
# Author: fcanas@redhat.com
#
# Needs BeautifulSoup to run:
# sudo pip install BeautifulSoup
# 
# If you don't have pip, then:
# sudo yum install pip
from bs4 import BeautifulSoup
eng = BeautifulSoup(open("eng.xml"))

langs = ["chn","deu","fra","jpn","por","spa"]
langstr = {}

eng_str=eng.find_all('str')
eng_key=[e['id'] for e in eng_str]

for l in langs:
    lfile = BeautifulSoup(open(l+".xml"))
    lstr = lfile.find_all('str')
    langstr[l]=[k['id'] for k in lstr]

eng_key_str_dict = {}
for ele in eng_str:
    eng_key_str_dict[ele['id']]=ele['txt']

total_missing_strings = 0

# this dictionary will map lang => keys missing in that language
missing_key_per_lang = {}

# this dictionary will map keys => langs missing that key
missing_lang_per_key = {}

for lang in langs:
    missing_key_per_lang[lang] = []
    for key in eng_key:
        if key not in langstr[lang]:
            if key not in missing_lang_per_key:
                missing_lang_per_key[key] = []
            missing_lang_per_key[key].append(lang)
            missing_key_per_lang[lang].append(key)
            total_missing_strings += 1

# Generate the Report
print "=" * 72
print "Keys missing translations in langpacks:"
print "=" * 72
for k,v in missing_lang_per_key.iteritems():
    print k + ": ",
    for l in v:
        print l,
    print "\n"

print "=" * 72
print "Languages missing keys:"
print "=" * 72
for k,v in missing_key_per_lang.iteritems():
    print "=" * 72
    print k +":"
    for key in v:
        print key + "=\"" + eng_key_str_dict[key] + "\""

print "=" * 72
print "Languages missing keys:"
print "=" * 72
print "Strings Missing Per Langpack:"
for k,v in missing_key_per_lang.iteritems():
    print k + ":" + str(len(v))
print "Total Missing Strings: " + str(total_missing_strings)


