/*
 * Copyright 2013 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.artificer.integration.teiid.artifactbuilder;

import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNot.not;
import static org.hamcrest.core.IsNull.nullValue;
import static org.junit.Assert.assertThat;

import java.io.IOException;
import java.io.InputStream;

import org.artificer.integration.teiid.model.TeiidModel;
import org.artificer.integration.teiid.model.VdbManifest;
import org.junit.Before;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.artificer.common.ArtifactContent;

/**
 * A test class for a {@link ModelArtifactBuilder}.
 */
@SuppressWarnings( {"javadoc", "nls"} )
public final class ModelArtifactBuilderTest extends TeiidIntegrationTest {
    private ModelArtifactBuilder builder = null;
    private ExtendedDocument modelArtifact = null;

    @Before
    public void constructDeriver() {
        this.builder = new ModelArtifactBuilder();

        this.modelArtifact = new ExtendedDocument();
        this.modelArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        this.modelArtifact.setName(VdbManifest.FILE_NAME);
        this.modelArtifact.setExtendedType(TeiidModel.ARTIFACT_TYPE.extendedType());
    }

    @Test
    public void shouldDeriveBooksOracleModel() throws Exception {
        final InputStream modelStream = getResourceAsStream("Books_Oracle.xmi");
        assertThat(modelStream, is(not(nullValue())));

        // deriver framework will call derive and link methods
        builder.buildArtifacts(this.modelArtifact, new ArtifactContent("Books_Oracle.xmi", modelStream));

        // check model artifact properties
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.MMUID, "mmuuid:18b6c0ff-aa2a-409b-87f2-c3f1cd742b41");
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.DESCRIPTION, "This is a source model");
        assertPropertyValue(this.modelArtifact,
                            TeiidModel.PropertyId.PRIMARY_METAMODEL_URI,
                            "http://www.metamatrix.com/metamodels/Relational");
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.MODEL_TYPE, "PHYSICAL");
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.MAX_SET_SIZE, "1000");
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.PRODUCER_NAME, "Teiid Designer");
        assertPropertyValue(this.modelArtifact, TeiidModel.PropertyId.PRODUCER_VERSION, "8.0.0");
    }

    @Test( expected = IOException.class )
    public void shouldNotDeriveNonModels() throws Exception {
        final InputStream notAModelStream = getResourceAsStream("twitterVdb.xml");
        assertThat(notAModelStream, is(not(nullValue())));

        // deriver framework will call derive
        builder.buildArtifacts(
                this.modelArtifact, new ArtifactContent("twitterVdb.xml", notAModelStream)).getDerivedArtifacts();
    }

}
