/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;

public class ZipDataFormat
implements DataFormat {
    private final int compressionLevel;

    public ZipDataFormat() {
        this.compressionLevel = 1;
    }

    public ZipDataFormat(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, graph);
        DeflaterOutputStream zipOutput = new DeflaterOutputStream(stream, new Deflater(this.compressionLevel));
        try {
            IOHelper.copy(is, zipOutput);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IOHelper.close(is);
            IOHelper.close(zipOutput);
            throw throwable;
        }
        IOHelper.close(is);
        IOHelper.close(zipOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] byArray;
        InputStream is = ExchangeHelper.getMandatoryInBody(exchange, InputStream.class);
        InflaterInputStream unzipInput = new InflaterInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            IOHelper.copy(unzipInput, bos);
            byArray = bos.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            IOHelper.close(unzipInput);
            throw throwable;
        }
        IOHelper.close(unzipInput);
        return byArray;
    }
}

