/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.util.ObjectHelper;

public class LogFormatter
implements ExchangeFormatter {
    private boolean showExchangeId;
    private boolean showProperties;
    private boolean showHeaders;
    private boolean showBodyType = true;
    private boolean showBody = true;
    private boolean showOut;
    private boolean showException;
    private boolean showCaughtException;
    private boolean showStackTrace;
    private boolean showAll;
    private boolean multiline;
    private boolean showFuture;
    private int maxChars;

    public Object format(Exchange exchange) {
        Message in = exchange.getIn();
        StringBuilder sb = new StringBuilder("");
        if (this.showAll || this.showExchangeId) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Id:").append(exchange.getExchangeId());
        }
        if (this.showAll || this.showProperties) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Properties:").append(exchange.getProperties());
        }
        if (this.showAll || this.showHeaders) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Headers:").append(in.getHeaders());
        }
        if (this.showAll || this.showBodyType) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", BodyType:").append(this.getBodyTypeAsString(in));
        }
        if (this.showAll || this.showBody) {
            if (this.multiline) {
                sb.append('\n');
            }
            sb.append(", Body:").append(this.getBodyAsString(in));
        }
        if (this.showAll || this.showException || this.showCaughtException) {
            Exception exception = exchange.getException();
            boolean caught = false;
            if (this.showCaughtException && exception == null) {
                exception = exchange.getProperty("CamelExceptionCaught", Exception.class);
                caught = true;
            }
            if (exception != null) {
                if (this.multiline) {
                    sb.append('\n');
                }
                if (caught) {
                    sb.append(", CaughtExceptionType:").append(exception.getClass().getCanonicalName());
                    sb.append(", CaughtExceptionMessage:").append(exception.getMessage());
                } else {
                    sb.append(", ExceptionType:").append(exception.getClass().getCanonicalName());
                    sb.append(", ExceptionMessage:").append(exception.getMessage());
                }
                if (this.showAll || this.showStackTrace) {
                    StringWriter sw = new StringWriter();
                    exception.printStackTrace(new PrintWriter(sw));
                    sb.append(", StackTrace:").append(sw.toString());
                }
            }
        }
        if (this.showAll || this.showOut) {
            if (exchange.hasOut()) {
                Message out = exchange.getOut();
                if (this.showAll || this.showHeaders) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutHeaders:").append(out.getHeaders());
                }
                if (this.showAll || this.showBodyType) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutBodyType:").append(this.getBodyTypeAsString(out));
                }
                if (this.showAll || this.showBody) {
                    if (this.multiline) {
                        sb.append('\n');
                    }
                    sb.append(", OutBody:").append(this.getBodyAsString(out));
                }
            } else {
                if (this.multiline) {
                    sb.append('\n');
                }
                sb.append(", Out: null");
            }
        }
        if (this.maxChars > 0) {
            StringBuilder answer = new StringBuilder();
            for (String s : sb.toString().split("\n")) {
                if (s == null) continue;
                if (s.length() > this.maxChars) {
                    s = s.substring(0, this.maxChars);
                    answer.append(s).append("...");
                } else {
                    answer.append(s);
                }
                if (!this.multiline) continue;
                answer.append("\n");
            }
            return "Exchange[" + (this.multiline ? answer.append(']').toString() : answer.toString().substring(2) + "]");
        }
        return "Exchange[" + (this.multiline ? sb.append(']').toString() : sb.toString().substring(2) + "]");
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowOut() {
        return this.showOut;
    }

    public void setShowOut(boolean showOut) {
        this.showOut = showOut;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public boolean isShowException() {
        return this.showException;
    }

    public void setShowException(boolean showException) {
        this.showException = showException;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    public void setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
    }

    public boolean isShowCaughtException() {
        return this.showCaughtException;
    }

    public void setShowCaughtException(boolean showCaughtException) {
        this.showCaughtException = showCaughtException;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isShowFuture() {
        return this.showFuture;
    }

    public void setShowFuture(boolean showFuture) {
        this.showFuture = showFuture;
    }

    protected Object getBodyAsString(Message message) {
        Object answer;
        if (message.getBody() instanceof Future && !this.isShowFuture()) {
            return message.getBody().toString();
        }
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer;
    }

    protected Object getBodyTypeAsString(Message message) {
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }
}

