/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ManagementStrategy;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(description="Managed CamelContext")
public class ManagedCamelContext {
    private CamelContext context;

    public ManagedCamelContext(CamelContext context) {
        this.context = context;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    @ManagedAttribute(description="Camel id")
    public String getCamelId() {
        return this.context.getName();
    }

    @ManagedAttribute(description="Camel Version")
    public String getCamelVersion() {
        return this.context.getVersion();
    }

    @ManagedAttribute(description="Camel State")
    public String getState() {
        ServiceStatus status = ((ServiceSupport)((Object)this.context)).getStatus();
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute(description="Camel Properties")
    public Map<String, String> getProperties() {
        if (this.context.getProperties().isEmpty()) {
            return null;
        }
        return this.context.getProperties();
    }

    @ManagedAttribute(description="Tracing")
    public Boolean getTracing() {
        return this.context.isTracing();
    }

    @ManagedAttribute(description="Tracing")
    public void setTracing(Boolean tracing) {
        this.context.setTracing(tracing);
    }

    @ManagedAttribute(description="Current number of inflight Exchanges")
    public Integer getInflightExchanges() {
        return this.context.getInflightRepository().size();
    }

    @ManagedOperation(description="Start Camel")
    public void start() throws Exception {
        this.context.start();
    }

    @ManagedOperation(description="Stop Camel")
    public void stop() throws Exception {
        this.context.stop();
    }

    @ManagedOperation(description="Send body (in only)")
    public void sendBody(String endpointUri, String body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        template.sendBody(endpointUri, (Object)body);
        template.stop();
    }

    @ManagedOperation(description="Request body (in out)")
    public Object requestBody(String endpointUri, String body) throws Exception {
        ProducerTemplate template = this.context.createProducerTemplate();
        Object answer = template.requestBody(endpointUri, (Object)body);
        template.stop();
        return answer;
    }
}

