/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */

package org.apache.directory.shared.ldap.message.spi;


import java.io.InputStream;

import org.apache.directory.shared.asn1.codec.stateful.StatefulDecoder;


/**
 * Standard decoder service provider interface. BER decoders generating ASN.1
 * compiler stub based containment tree for a provider are expected to implement
 * this interface.
 * 
 * @author <a href="mailto:dev@directory.apache.org"> Apache Directory Project</a>
 * @version $Rev$
 */
public interface ProviderDecoder extends ProviderObject, StatefulDecoder
{
    /**
     * Decodes a BER encoded LDAPv3 ASN.1 message envelope from a binary input
     * stream into an in memory containment tree using stub's generated by a
     * provider's ASN.1 stub compiler and associated runtime BER libraries.
     * 
     * @param lock
     *            lock object used to exclusively read from the input stream
     * @param in
     *            the binary input stream where the encoded message PDU is read
     * @return an object representing the top-most containment tree object which
     *         represents the entire message envelope. For the Snacc provider
     *         this object would be a populated instance of LDAPMessage.
     * @throws ProviderException
     *             to indicate an error while attempting to decode the message
     *             envelope onto the output stream. Provider specific exceptions
     *             encountered while decoding can be held within this subclass
     *             of MultiException.
     */
    Object decode( Object lock, InputStream in ) throws ProviderException;
}
