/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.NoFactoryAvailableException;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLanguageResolver
implements LanguageResolver {
    public static final String LANGUAGE_RESOURCE_PATH = "META-INF/services/org/apache/camel/language/";
    public static final String LANGUAGE_RESOLVER_RESOURCE_PATH = "META-INF/services/org/apache/camel/language/resolver/";
    private static final transient Log LOG = LogFactory.getLog(DefaultLanguageResolver.class);
    protected FactoryFinder languageFactory;
    protected FactoryFinder languageResolver;

    @Override
    public Language resolveLanguage(String name, CamelContext context) {
        Object bean;
        block9: {
            bean = null;
            try {
                bean = context.getRegistry().lookup(name);
                if (bean != null && this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("Found language: " + name + " in registry: " + bean));
                }
            }
            catch (Exception e) {
                if (!this.getLog().isDebugEnabled()) break block9;
                this.getLog().debug((Object)("Ignored error looking up bean: " + name + ". Error: " + e));
            }
        }
        if (bean != null && bean instanceof Language) {
            return (Language)bean;
        }
        Class<?> type = null;
        try {
            type = this.findLanguage(name, context);
        }
        catch (NoFactoryAvailableException e) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no Language registered for scheme: " + name, e);
        }
        if (type != null) {
            if (Language.class.isAssignableFrom(type)) {
                return (Language)context.getInjector().newInstance(type);
            }
            throw new IllegalArgumentException("Resolving language: " + name + " detected type conflict: Not a Language implementation. Found: " + type.getName());
        }
        return this.noSpecificLanguageFound(name, context);
    }

    protected Language noSpecificLanguageFound(String name, CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findLanguageResolver("default", context);
        }
        catch (NoFactoryAvailableException e) {
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI, no LanguageResolver registered for scheme: " + name, e);
        }
        if (type != null) {
            if (LanguageResolver.class.isAssignableFrom(type)) {
                LanguageResolver resolver = (LanguageResolver)context.getInjector().newInstance(type);
                return resolver.resolveLanguage(name, context);
            }
            throw new IllegalArgumentException("Resolving language: " + name + " detected type conflict: Not a LanguageResolver implementation. Found: " + type.getName());
        }
        throw new NoSuchLanguageException(name);
    }

    protected Class<?> findLanguage(String name, CamelContext context) throws Exception {
        if (this.languageFactory == null) {
            this.languageFactory = context.getFactoryFinder(LANGUAGE_RESOURCE_PATH);
        }
        return this.languageFactory.findClass(name);
    }

    protected Class<?> findLanguageResolver(String name, CamelContext context) throws Exception {
        if (this.languageResolver == null) {
            this.languageResolver = context.getFactoryFinder(LANGUAGE_RESOLVER_RESOURCE_PATH);
        }
        return this.languageResolver.findClass(name);
    }

    protected Log getLog() {
        return LOG;
    }
}

