/**
 * @module Jmx
 */
/// <reference path="./jmxPlugin.ts"/>
module Jmx {
  _module.controller("Jmx.ChartEditController", ["$scope", "$location", "workspace", "jolokia", ($scope, $location, workspace:Workspace, jolokia) => {
    $scope.selectedAttributes = [];
    $scope.selectedMBeans = [];
    $scope.metrics = {};
    $scope.mbeans = {};

    // TODO move this function to $routeScope
    $scope.size = (value) => {
      if (angular.isObject(value)) {
        return Object.size(value);
      } else if (angular.isArray(value)) {
        return value.length;
      } else return 1;
    };

    $scope.canViewChart = () => {
      return $scope.selectedAttributes.length && $scope.selectedMBeans.length &&
              $scope.size($scope.mbeans) > 0 && $scope.size($scope.metrics) > 0;
    };

    $scope.showAttributes = () => {
      return $scope.canViewChart() && $scope.size($scope.metrics) > 1;
    };

    $scope.showElements = () => {
      return $scope.canViewChart() && $scope.size($scope.mbeans) > 1;
    };

    $scope.viewChart = () => {
      // lets add the attributes and mbeans into the URL so we can navigate back to the charts view
      var search = $location.search();
      // if we have selected all attributes, then lets just remove the attribute
      if ($scope.selectedAttributes.length === $scope.size($scope.metrics)) {
        delete search["att"];
      } else {
        search["att"] = $scope.selectedAttributes;
      }
      // if we are on an mbean with no children lets discard an unnecessary parameter
      if ($scope.selectedMBeans.length === $scope.size($scope.mbeans) && $scope.size($scope.mbeans) === 1) {
        delete search["el"];
      } else {
        search["el"] = $scope.selectedMBeans;
      }
      $location.search(search);
      $location.path("jmx/charts");
    };

    $scope.$watch('workspace.selection', render);

    $scope.$on("$routeChangeSuccess", function (event, current, previous) {
      // lets do this asynchronously to avoid Error: $digest already in progress
      setTimeout(render, 50);
    });

    function render() {
      var node = workspace.selection;
      if (!angular.isDefined(node)) {
        return;
      }

      $scope.selectedAttributes = [];
      $scope.selectedMBeans = [];
      $scope.metrics = {};
      $scope.mbeans = {};
      var mbeanCounter = 0;
      var resultCounter = 0;

      // lets iterate through all the children if the current node is not an mbean
      var children = node.children;
      if (!children || !children.length || node.objectName) {
        children = [node];
      }
      if (children) {
        children.forEach((mbeanNode) => {
          var mbean = mbeanNode.objectName;
          var name = mbeanNode.title;
          if (name && mbean) {
            mbeanCounter++;
            $scope.mbeans[name] = name;
            // we need to escape the mbean path for list
            var listKey = escapeMBeanPath(mbean);
            //var listKey = encodeMBeanPath(mbean);
            jolokia.list(listKey, onSuccess((meta) => {
              var attributes = meta.attr;
              if (attributes) {
                for (var key in attributes) {
                  var value = attributes[key];
                  if (value) {
                    var typeName = value['type'];
                    if (isNumberTypeName(typeName)) {
                      if (!$scope.metrics[key]) {
                        //console.log("Number attribute " + key + " for " + mbean);
                        $scope.metrics[key] = key;
                      }
                    }
                  }
                }
                if (++resultCounter >= mbeanCounter) {
                  // TODO do we need to sort just in case?

                  // lets look in the search URI to default the selections
                  var search = $location.search();
                  var attributeNames = toSearchArgumentArray(search["att"]);
                  var elementNames = toSearchArgumentArray(search["el"]);
                  if (attributeNames && attributeNames.length) {
                    attributeNames.forEach((name) => {
                      if ($scope.metrics[name]) {
                        $scope.selectedAttributes.push(name);
                      }
                    });
                  }
                  if (elementNames && elementNames.length) {
                    elementNames.forEach((name) => {
                      if ($scope.mbeans[name]) {
                        $scope.selectedMBeans.push(name);
                      }
                    });
                  }

                  // default selections if there are none
                  if ($scope.selectedMBeans.length < 1) {
                    $scope.selectedMBeans = Object.keys($scope.mbeans);
                  }
                  if ($scope.selectedAttributes.length < 1) {
                    var attrKeys = Object.keys($scope.metrics).sort();
                    if ($scope.selectedMBeans.length > 1) {
                      $scope.selectedAttributes = [attrKeys.first()];
                    } else {
                      $scope.selectedAttributes = attrKeys;
                    }
                  }

                  // lets update the sizes using jquery as it seems AngularJS doesn't support it
                  $("#attributes").attr("size", Object.size($scope.metrics));
                  $("#mbeans").attr("size", Object.size($scope.mbeans));
                  Core.$apply($scope);
                }
              }
            }));
          }
        });
      }
    }
  }]);
}
