/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.cp;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;

public class CharacterEncoding {
    protected static Hashtable<String, String> m_JavaToSAPEncoding = null;
    protected static Hashtable<String, String> m_JavaToXMLEncoding = null;

    protected CharacterEncoding() {
    }

    protected static void initJavaToSAPEncoding() {
        m_JavaToSAPEncoding = new Hashtable(23);
        m_JavaToSAPEncoding.put("ascii", "1100");
        m_JavaToSAPEncoding.put("ebcdic", "0120");
        m_JavaToSAPEncoding.put("utf-8", "4110");
        m_JavaToSAPEncoding.put("utf8", "4110");
        m_JavaToSAPEncoding.put("utf16-be", "4102");
        m_JavaToSAPEncoding.put("utf16be", "4102");
        m_JavaToSAPEncoding.put("utf16 bigendian", "4102");
        m_JavaToSAPEncoding.put("unicodebig", "4102");
        m_JavaToSAPEncoding.put("unicodebigunmarked", "4102");
        m_JavaToSAPEncoding.put("utf16-le", "4103");
        m_JavaToSAPEncoding.put("utf16le", "4103");
        m_JavaToSAPEncoding.put("utf16 littleendian", "4103");
        m_JavaToSAPEncoding.put("unicodelittle", "4103");
        m_JavaToSAPEncoding.put("unicodelittleunmarked", "4103");
    }

    protected static void initJavaToXMLEncoding() {
        m_JavaToXMLEncoding = new Hashtable(201);
        m_JavaToXMLEncoding.put("ascii", "US-ASCII");
        m_JavaToXMLEncoding.put("utf-16", "UTF-16");
        m_JavaToXMLEncoding.put("utf-8", "UTF-8");
        m_JavaToXMLEncoding.put("utf16", "UTF-16");
        m_JavaToXMLEncoding.put("utf8", "UTF-8");
        m_JavaToXMLEncoding.put("unicode", "UTF-16");
        m_JavaToXMLEncoding.put("unicodebig", "UTF-16");
        m_JavaToXMLEncoding.put("unicodebigunmarked", "UTF-16BE");
        m_JavaToXMLEncoding.put("unicodelittle", "UTF-16");
        m_JavaToXMLEncoding.put("unicodelittleunmarked", "UTF-16LE");
        m_JavaToXMLEncoding.put("unicodeunknown", "UTF-16");
        m_JavaToXMLEncoding.put("iso8859_1", "ISO-8859-1");
        m_JavaToXMLEncoding.put("iso8859_2", "ISO-8859-2");
        m_JavaToXMLEncoding.put("iso8859_3", "ISO-8859-3");
        m_JavaToXMLEncoding.put("iso8859_4", "ISO-8859-4");
        m_JavaToXMLEncoding.put("iso8859_5", "ISO-8859-5");
        m_JavaToXMLEncoding.put("iso8859_6", "ISO-8859-6");
        m_JavaToXMLEncoding.put("iso8859_7", "ISO-8859-7");
        m_JavaToXMLEncoding.put("iso8859_8", "ISO-8859-8");
        m_JavaToXMLEncoding.put("iso8859_9", "ISO-8859-9");
        m_JavaToXMLEncoding.put("iso8859_10", "ISO-8859-10");
        m_JavaToXMLEncoding.put("iso8859_13", "ISO-8859-13");
        m_JavaToXMLEncoding.put("iso8859_14", "ISO-8859-14");
        m_JavaToXMLEncoding.put("iso8859_15", "ISO-8859-15");
        m_JavaToXMLEncoding.put("iso8859_15_fdis", "ISO-8859-15");
        m_JavaToXMLEncoding.put("iso8859_16", "ISO-8859-16");
        m_JavaToXMLEncoding.put("big5", "Big5");
        m_JavaToXMLEncoding.put("big5_hkscs", "Big5-HKSCS");
        m_JavaToXMLEncoding.put("big5_solaris", "Big5");
        m_JavaToXMLEncoding.put("euc_cn", "GB2312");
        m_JavaToXMLEncoding.put("euc_jp", "EUC-JP");
        m_JavaToXMLEncoding.put("euc_jp_solaris", "EUC-JP");
        m_JavaToXMLEncoding.put("euc_jp_linux", "EUC-JP");
        m_JavaToXMLEncoding.put("euc_kr", "EUC-KR");
        m_JavaToXMLEncoding.put("gb18030", "GB18030");
        m_JavaToXMLEncoding.put("gbk", "GBK");
        m_JavaToXMLEncoding.put("iso2022cn", "ISO-2022-CN");
        m_JavaToXMLEncoding.put("iso2022jp", "ISO-2022-JP");
        m_JavaToXMLEncoding.put("iso2022kr", "ISO-2022-KR");
        m_JavaToXMLEncoding.put("jis0201", "JIS_X020");
        m_JavaToXMLEncoding.put("koi8_r", "KOI8-R");
        m_JavaToXMLEncoding.put("ms932", "Shift_JIS");
        m_JavaToXMLEncoding.put("pck", "Shift_JIS");
        m_JavaToXMLEncoding.put("sjis", "Shift_JIS");
        m_JavaToXMLEncoding.put("tis620", "TIS-620");
        m_JavaToXMLEncoding.put("cp1250", "windows-1250");
        m_JavaToXMLEncoding.put("cp1251", "windows-1251");
        m_JavaToXMLEncoding.put("cp1252", "windows-1252");
        m_JavaToXMLEncoding.put("cp1253", "windows-1253");
        m_JavaToXMLEncoding.put("cp1254", "windows-1254");
        m_JavaToXMLEncoding.put("cp1255", "windows-1255");
        m_JavaToXMLEncoding.put("cp1256", "windows-1256");
        m_JavaToXMLEncoding.put("cp1257", "windows-1257");
        m_JavaToXMLEncoding.put("cp1258", "windows-1258");
        m_JavaToXMLEncoding.put("cp037", "IBM037");
        m_JavaToXMLEncoding.put("cp038", "IBM038");
        m_JavaToXMLEncoding.put("cp273", "IBM273");
        m_JavaToXMLEncoding.put("cp274", "IBM274");
        m_JavaToXMLEncoding.put("cp275", "IBM275");
        m_JavaToXMLEncoding.put("cp277", "IBM277");
        m_JavaToXMLEncoding.put("cp278", "IBM278");
        m_JavaToXMLEncoding.put("cp280", "IBM280");
        m_JavaToXMLEncoding.put("cp281", "IBM281");
        m_JavaToXMLEncoding.put("cp284", "IBM284");
        m_JavaToXMLEncoding.put("cp285", "IBM285");
        m_JavaToXMLEncoding.put("cp290", "IBM290");
        m_JavaToXMLEncoding.put("cp297", "IBM297");
        m_JavaToXMLEncoding.put("cp420", "IBM420");
        m_JavaToXMLEncoding.put("cp423", "IBM423");
        m_JavaToXMLEncoding.put("cp424", "IBM424");
        m_JavaToXMLEncoding.put("cp437", "IBM437");
        m_JavaToXMLEncoding.put("cp500", "IBM500");
        m_JavaToXMLEncoding.put("cp775", "IBM775");
        m_JavaToXMLEncoding.put("cp850", "IBM850");
        m_JavaToXMLEncoding.put("cp851", "IBM851");
        m_JavaToXMLEncoding.put("cp852", "IBM852");
        m_JavaToXMLEncoding.put("cp855", "IBM855");
        m_JavaToXMLEncoding.put("cp857", "IBM857");
        m_JavaToXMLEncoding.put("cp860", "IBM860");
        m_JavaToXMLEncoding.put("cp861", "IBM861");
        m_JavaToXMLEncoding.put("cp862", "IBM862");
        m_JavaToXMLEncoding.put("cp863", "IBM863");
        m_JavaToXMLEncoding.put("cp864", "IBM864");
        m_JavaToXMLEncoding.put("cp865", "IBM865");
        m_JavaToXMLEncoding.put("cp866", "IBM866");
        m_JavaToXMLEncoding.put("cp868", "IBM868");
        m_JavaToXMLEncoding.put("cp869", "IBM869");
        m_JavaToXMLEncoding.put("cp870", "IBM870");
        m_JavaToXMLEncoding.put("cp871", "IBM871");
        m_JavaToXMLEncoding.put("cp880", "IBM880");
        m_JavaToXMLEncoding.put("cp891", "IBM891");
        m_JavaToXMLEncoding.put("cp903", "IBM903");
        m_JavaToXMLEncoding.put("cp904", "IBM904");
        m_JavaToXMLEncoding.put("cp905", "IBM905");
        m_JavaToXMLEncoding.put("cp918", "IBM918");
        m_JavaToXMLEncoding.put("cp1026", "IBM1026");
        m_JavaToXMLEncoding.put("cp737", "x-IBM737");
        m_JavaToXMLEncoding.put("cp838", "x-IBM838");
        m_JavaToXMLEncoding.put("cp856", "x-IBM856");
        m_JavaToXMLEncoding.put("cp874", "x-IBM874");
        m_JavaToXMLEncoding.put("cp875", "x-IBM875");
        m_JavaToXMLEncoding.put("cp921", "x-IBM921");
        m_JavaToXMLEncoding.put("cp922", "x-IBM922");
        m_JavaToXMLEncoding.put("cp930", "x-IBM930");
        m_JavaToXMLEncoding.put("cp933", "x-IBM933");
        m_JavaToXMLEncoding.put("cp935", "x-IBM935");
        m_JavaToXMLEncoding.put("cp937", "x-IBM937");
        m_JavaToXMLEncoding.put("cp939", "x-IBM939");
        m_JavaToXMLEncoding.put("cp942", "x-IBM942");
        m_JavaToXMLEncoding.put("cp942c", "x-IBM942C");
        m_JavaToXMLEncoding.put("cp943", "x-IBM943");
        m_JavaToXMLEncoding.put("cp943c", "x-IBM943C");
        m_JavaToXMLEncoding.put("cp948", "x-IBM948");
        m_JavaToXMLEncoding.put("cp949", "x-IBM949");
        m_JavaToXMLEncoding.put("cp949c", "x-IBM949C");
        m_JavaToXMLEncoding.put("cp950", "x-IBM950");
        m_JavaToXMLEncoding.put("cp964", "x-IBM964");
        m_JavaToXMLEncoding.put("cp970", "x-IBM970");
        m_JavaToXMLEncoding.put("cp1006", "x-IBM1006");
        m_JavaToXMLEncoding.put("cp1025", "x-IBM1025");
        m_JavaToXMLEncoding.put("cp1097", "x-IBM1097");
        m_JavaToXMLEncoding.put("cp1098", "x-IBM1098");
        m_JavaToXMLEncoding.put("cp1112", "x-IBM1112");
        m_JavaToXMLEncoding.put("cp1122", "x-IBM1122");
        m_JavaToXMLEncoding.put("cp1123", "x-IBM1123");
        m_JavaToXMLEncoding.put("cp1124", "x-IBM1124");
        m_JavaToXMLEncoding.put("cp1381", "x-IBM1381");
        m_JavaToXMLEncoding.put("cp1383", "x-IBM1383");
        m_JavaToXMLEncoding.put("cp33722", "x-IBM33722");
        m_JavaToXMLEncoding.put("euc_tw", "x-EUC-TW");
        m_JavaToXMLEncoding.put("iscii91", "x-ISCII91");
        m_JavaToXMLEncoding.put("iso8859_11", "x-ISO-8859-11");
        m_JavaToXMLEncoding.put("iso8859_12", "x-ISO-8859-12");
        m_JavaToXMLEncoding.put("johab", "x-Johab");
        m_JavaToXMLEncoding.put("ms1361", "x-Johab");
        m_JavaToXMLEncoding.put("ms950", "x-windows-950");
        m_JavaToXMLEncoding.put("ms874", "x-windows-874");
        m_JavaToXMLEncoding.put("ms949", "x-windows-949");
    }

    public static String mapJavaToSAPEncoding(String javaEncoding) {
        String sapEncoding;
        if (javaEncoding == null) {
            return null;
        }
        if ((javaEncoding = javaEncoding.toLowerCase(Locale.ENGLISH)).startsWith("sap")) {
            javaEncoding = javaEncoding.substring(3);
        }
        if (javaEncoding.length() == 4) {
            try {
                if (Integer.parseInt(javaEncoding) >= 0) {
                    return javaEncoding;
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (m_JavaToSAPEncoding == null) {
            CharacterEncoding.initJavaToSAPEncoding();
        }
        if ((sapEncoding = m_JavaToSAPEncoding.get(javaEncoding)) == null && javaEncoding.startsWith("u") && (javaEncoding.equals("utf-16") || javaEncoding.equals("utf16") || javaEncoding.equals("unicode") || javaEncoding.equals("unicodeunknown"))) {
            String endian = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String prop = System.getProperty("sun.cpu.endian");
                    if (prop == null) {
                        prop = System.getProperty("sun.io.unicode.encoding", "null");
                    }
                    return prop;
                }
            }).toLowerCase(Locale.ENGLISH);
            sapEncoding = endian.indexOf("little") >= 0 ? "4103" : "4102";
        }
        return sapEncoding;
    }

    public static String mapJavaToXMLEncoding(String javaEncoding) {
        if (javaEncoding == null) {
            return null;
        }
        if (m_JavaToXMLEncoding == null) {
            CharacterEncoding.initJavaToXMLEncoding();
        }
        return m_JavaToXMLEncoding.get(javaEncoding.toLowerCase(Locale.ENGLISH));
    }
}

