/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.engine;

import com.sap.conn.rfc.api.GatewayRegInfo;
import com.sap.conn.rfc.api.RfcAcceptInfo;
import com.sap.conn.rfc.api.RfcRegisterInfo;
import com.sap.conn.rfc.api.RfcRuntime;
import com.sap.conn.rfc.driver.CpicDriver;
import com.sap.conn.rfc.driver.RfcDriver;
import com.sap.conn.rfc.driver.RfcTypeDirectCpic;
import com.sap.conn.rfc.driver.RfcTypePlayback;
import com.sap.conn.rfc.driver.RfcTypeRecorder;
import com.sap.conn.rfc.driver.RfcTypeRegisterCpic;
import com.sap.conn.rfc.engine.DefaultRfcTraceWriter;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.RfcTraceWriter;
import com.sap.conn.rfc.exceptions.RfcException;
import java.util.Properties;

public class DefaultRfcRuntime
implements RfcRuntime {
    @Override
    public RfcAcceptInfo createAcceptInfo(Properties properties) {
        return new RfcRegisterInfo();
    }

    @Override
    public String getVersion() {
        return CpicDriver.CpicGetVersion();
    }

    @Override
    public RfcDriver createChannel(RfcIoOpenCntl currentControl) {
        RfcDriver driver = null;
        switch (currentControl.type) {
            case 0: 
            case 4: {
                driver = new RfcTypeDirectCpic(currentControl);
                break;
            }
            case 12: {
                driver = new RfcTypeRegisterCpic(currentControl);
                break;
            }
            case 10: {
                driver = new RfcTypePlayback(currentControl);
                break;
            }
            case 21: {
                driver = new RfcTypeRecorder(currentControl);
            }
        }
        return driver;
    }

    @Override
    public RfcTraceWriter getRfcTraceWriter() {
        return new DefaultRfcTraceWriter();
    }

    @Override
    public void updateClientConnectionProperties(char connectionType, Properties properties) {
    }

    @Override
    public void initializeHandle(RfcIoOpenCntl currentControl) {
    }

    @Override
    public void setCpicTrace(int level, String fileName) {
        CpicDriver.setCpicTrace(level, fileName);
    }

    @Override
    public String getTraceFileName() {
        return CpicDriver.getTraceFileName();
    }

    @Override
    public void setRfcTrace(boolean traceOn) {
        RfcIoOpenCntl.setGeneralTrace(traceOn);
    }

    @Override
    public RfcIoOpenCntl getNextListener() {
        return RfcTypeRegisterCpic.getNextListener();
    }

    @Override
    public int waitForCpicRequest(int timeout) {
        return RfcTypeRegisterCpic.waitForRequest(timeout);
    }

    @Override
    public int getNumServerConnections(RfcAcceptInfo acceptInfo) throws RfcException {
        return RfcTypeRegisterCpic.getNumServerConnections(acceptInfo);
    }

    @Override
    public void setCpicMaxConv(int no_elem) throws RfcException {
        CpicDriver.setCpicMaxConv(no_elem);
    }

    @Override
    public String getOwnCodepage() {
        return "4102";
    }

    @Override
    public boolean isLittleEndian() {
        return false;
    }

    @Override
    public void setupRegKeepAlive(boolean pingActivate, boolean pingReply, int ping_period_in_sec, int ping_write_timeout_in_ms) throws RfcException {
        CpicDriver.setupRegKeepAlive(pingActivate, pingReply, ping_period_in_sec, ping_write_timeout_in_ms);
    }

    @Override
    public String[] launchSapGui(RfcIoOpenCntl currentControl, String startCommand, String sapGuiId, String systemID, int systemNr) {
        return ((CpicDriver)currentControl.channel).launchSapGui(startCommand, sapGuiId, systemID, systemNr);
    }

    @Override
    public byte[] createUUID() {
        return CpicDriver.createUUID();
    }

    @Override
    public GatewayRegInfo getGatewayRegInfo(RfcIoOpenCntl cntl) throws RfcException {
        return RfcTypeRegisterCpic.getGatewayRegInfo(cntl);
    }
}

