/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertBase;
import com.sap.i18n.cp.ConvertCToX;
import com.sap.i18n.cp.ConvertUc2BE;
import com.sap.i18n.cp.ConvertUc2Db;
import com.sap.i18n.cp.ConvertUc2LE;
import com.sap.i18n.cp.ConvertUc2Sb;
import com.sap.i18n.cp.ConvertUc2Utf8;

public class ConvertCToXFactory {
    private static ShortcutBase[] ms_aShortcuts = new ShortcutBase[10000];

    public static ConvertCToX createConvertCToX(char[] sOutCp, boolean bIgnoreErr) {
        return ConvertCToXFactory.createConvertCToX(sOutCp, bIgnoreErr, false);
    }

    public static ConvertCToX createConvertCToX(char[] sOutCp, boolean bIgnoreErr, boolean bFailOnErr) {
        String sOutCpStr = new String(sOutCp);
        if (sOutCpStr.equals("4102")) {
            return new ConvertUc2BE(bIgnoreErr);
        }
        if (sOutCpStr.equals("4103")) {
            return new ConvertUc2LE(bIgnoreErr);
        }
        if (sOutCpStr.equals("4110")) {
            return new ConvertUc2Utf8(bIgnoreErr);
        }
        ShortcutBase oShortcut = ConvertCToXFactory.getShortcut(sOutCp);
        if (oShortcut != null) {
            boolean bLoaded;
            if (oShortcut.m_bTabLoaded) {
                return oShortcut.createConvertCToX(bIgnoreErr);
            }
            if (!oShortcut.m_bTabLoadTried && (bLoaded = oShortcut.loadTab())) {
                return oShortcut.createConvertCToX(bIgnoreErr);
            }
        }
        return new ConvertCToX(sOutCp, bIgnoreErr, bFailOnErr);
    }

    public static ConvertCToX createConvertCToAscii(boolean bIgnoreErr) {
        return ConvertCToXFactory.createConvertCToX("1101".toCharArray(), bIgnoreErr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShortcutBase getShortcut(char[] sCp) {
        ConvertBase.CheckConverterJNIAvailable();
        if (!ConvertBase.m_bCnvShortcutsAvailable) {
            return null;
        }
        int nIndex = ConvertCToXFactory.getShortcutIndex(sCp);
        if (nIndex == -1) {
            return null;
        }
        ShortcutBase[] shortcutBaseArray = ms_aShortcuts;
        synchronized (ms_aShortcuts) {
            if (ms_aShortcuts[nIndex] != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ms_aShortcuts[nIndex];
            }
            ConvertCToX aCnvForCheck = new ConvertCToX(sCp, true);
            int nType = aCnvForCheck.GetShortcutType();
            if (nType == 3) {
                ConvertCToXFactory.ms_aShortcuts[nIndex] = new ShortcutUc2Sb(sCp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ms_aShortcuts[nIndex];
            }
            if (nType == 4) {
                ConvertCToXFactory.ms_aShortcuts[nIndex] = new ShortcutUc2Db(sCp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ms_aShortcuts[nIndex];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    private static int getShortcutIndex(char[] sCp) {
        if (sCp.length != 4) {
            return -1;
        }
        int nIndex = (sCp[0] - 48) * 1000 + (sCp[1] - 48) * 100 + (sCp[2] - 48) * 10 + (sCp[3] - 48) * 1;
        if (0 <= nIndex && nIndex < 10000) {
            return nIndex;
        }
        return -1;
    }

    private static class ShortcutUc2Db
    extends ShortcutBase {
        private char[] m_anUc2ValueTab = new char[65536];
        private char[] m_anUc2DbTab = null;

        public ShortcutUc2Db(char[] sCp) {
            super(sCp);
        }

        public ConvertCToX createConvertCToX(boolean bIgnoreErr) {
            ConvertUc2Db returnValue = null;
            if (this.m_bTabLoaded) {
                returnValue = new ConvertUc2Db(this.m_sCp, bIgnoreErr, this.m_anUc2ValueTab, this.m_anUc2DbTab);
            }
            return returnValue;
        }

        public boolean loadTab() {
            int[] aRet = new int[1];
            ConvertCToX aCnvForLoad = new ConvertCToX(this.m_sCp, true);
            this.m_anUc2DbTab = aCnvForLoad.GetUc2DbTab(this.m_anUc2ValueTab, aRet);
            this.m_bTabLoadTried = true;
            this.m_bTabLoaded = aRet[0] == 0;
            return this.m_bTabLoaded;
        }
    }

    private static class ShortcutUc2Sb
    extends ShortcutBase {
        public byte[] m_abUc2SbTab = null;

        public ShortcutUc2Sb(char[] sCp) {
            super(sCp);
        }

        public ConvertCToX createConvertCToX(boolean bIgnoreErr) {
            ConvertUc2Sb returnValue = null;
            if (this.m_bTabLoaded) {
                returnValue = new ConvertUc2Sb(this.m_sCp, bIgnoreErr, this.m_abUc2SbTab);
            }
            return returnValue;
        }

        public boolean loadTab() {
            int[] aRet = new int[1];
            ConvertCToX aCnvForLoad = new ConvertCToX(this.m_sCp, true);
            this.m_abUc2SbTab = aCnvForLoad.GetUc2SbTab(aRet);
            this.m_bTabLoadTried = true;
            this.m_bTabLoaded = aRet[0] == 0;
            return this.m_bTabLoaded;
        }
    }

    private static abstract class ShortcutBase {
        public char[] m_sCp;
        public boolean m_bTabLoaded;
        public boolean m_bTabLoadTried;

        public ShortcutBase(char[] sCp) {
            this.m_sCp = sCp;
            this.m_bTabLoaded = false;
            this.m_bTabLoadTried = false;
        }

        public abstract boolean loadTab();

        public abstract ConvertCToX createConvertCToX(boolean var1);
    }
}

