/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.JCoRequest;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.monitor.JCoRepositoryMonitor;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MetaDataStorage;
import com.sap.conn.jco.rt.json.RepReader;
import com.sap.conn.jco.rt.json.RepWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicRepository
implements JCoRepository {
    static final long serialVersionUID = 3000120080918L;
    protected String name;
    protected boolean containsUnicodeInfo = false;
    private MetaDataStorage storage = null;
    private BasicRepositoryMonitor monitor = null;
    long lastAccessTimestamp;

    BasicRepository(String name, boolean localCache) {
        this.name = name;
        this.storage = JCoRuntimeFactory.getRuntime().createMetaDataStorage(this, name, localCache);
        this.lastAccessTimestamp = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getMetaDataRelease() {
        return "000";
    }

    JCoFunctionTemplate addFunctionTemplate(JCoFunctionTemplate functionTemplate) {
        AbapFunctionTemplate removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        try {
            removed = this.storage.saveFunctionTemplate((AbapFunctionTemplate)functionTemplate);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only function templates created by JCo.createFunctionTemplate(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultRecordMetaData addRecordMetaData(JCoRecordMetaData recordMetaData) {
        DefaultRecordMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        recordMetaData.lock();
        try {
            removed = this.storage.saveRecordMetaData((DefaultRecordMetaData)recordMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only meta data created by JCo.createRecordMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    DefaultClassMetaData addClassMetaData(JCoClassMetaData classMetaData) {
        DefaultClassMetaData removed;
        this.lastAccessTimestamp = System.currentTimeMillis();
        classMetaData.lock();
        try {
            removed = this.storage.saveClassMetaData((DefaultClassMetaData)classMetaData);
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only meta data created by JCo.createClassMetaData(...) can be saved in repository cache");
        }
        return removed;
    }

    @Override
    public JCoFunctionTemplate getFunctionTemplate(String functionName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        return this.storage.loadFunctionTemplate(functionName);
    }

    public final JCoFunctionTemplate getFunctionTemplateFromCache(String functionName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        return this.storage.loadFunctionTemplateFromCache(functionName);
    }

    @Override
    public JCoListMetaData getFunctionInterface(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getFunctionInterface() : null;
    }

    @Override
    public JCoFunction getFunction(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getFunction() : null;
    }

    @Override
    public JCoRequest getRequest(String functionName) throws JCoException {
        JCoFunctionTemplate template = this.getFunctionTemplate(functionName);
        return template != null ? template.getRequest() : null;
    }

    @Override
    public DefaultRecordMetaData getRecordMetaData(String recordName) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        return this.storage.loadRecordMetaData(recordName);
    }

    public final DefaultRecordMetaData getRecordMetaDataFromCache(String recordName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        return this.storage.loadRecordMetaDataFromCache(recordName);
    }

    @Override
    public JCoRecordMetaData getStructureDefinition(String structureName) throws JCoException {
        return this.getRecordMetaData(structureName);
    }

    @Override
    public DefaultClassMetaData getClassMetaData(String className) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        return this.storage.loadClassMetaData(className);
    }

    public final DefaultClassMetaData getClassMetaDataFromCache(String className) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        return this.storage.loadClassMetaDataFromCache(className);
    }

    void resolveDynamicRecordMetaData(DynamicRecordMetaData meta) throws JCoException {
        this.lastAccessTimestamp = System.currentTimeMillis();
        throw new JCoRuntimeException(128, "JCO_ERROR_NOT_SUPPORTED", "Unable to resolve dynamic meta data. Use a custom repository connected to an SAP Application Server ABAP to lookup meta data containing generic boxes instead.");
    }

    @Override
    public void removeFunctionTemplateFromCache(String functionName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (functionName == null) {
            throw new IllegalArgumentException("Provide a valid function name: null is not allowed");
        }
        this.storage.removeFunctionTemplate(functionName);
    }

    @Override
    public void removeRecordMetaDataFromCache(String recordName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (recordName == null) {
            throw new IllegalArgumentException("Provide a valid record name: null is not allowed");
        }
        this.storage.removeRecordMetaData(recordName);
    }

    @Override
    public void removeClassMetaDataFromCache(String className) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        if (className == null) {
            throw new IllegalArgumentException("Provide a valid class name: null is not allowed");
        }
        this.storage.removeClassMetaData(className);
    }

    @Override
    public void clear() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        this.storage.clear();
    }

    protected void destroy() {
        if (JCoRuntimeFactory.getRuntime().getRepositoryManager().getRepository(this.getName()) == null) {
            this.storage.destroy();
            return;
        }
        throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Repository with ID " + this.getName() + " is still referenced by the runtime and cannot be removed");
    }

    @Override
    public String[] getCachedFunctionTemplateNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedFunctionNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] getCachedRecordMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedRecordNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public String[] getCachedClassMetaDataNames() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        Collection<String> names = this.storage.getCachedClassNames();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean isUnicode() {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.containsUnicodeInfo;
    }

    protected boolean containsRecordMetaData(String typeName) {
        this.lastAccessTimestamp = System.currentTimeMillis();
        return this.storage.containsRecord(typeName);
    }

    protected static boolean checkType1(DefaultRecordMetaData meta) {
        block4: for (int i = 0; i < meta.type.length; ++i) {
            switch (meta.type[i]) {
                case 17: {
                    if (meta.isNestedType1Structure(i)) continue block4;
                    DefaultRecordMetaData childMeta = (DefaultRecordMetaData)meta.getRecordMetaData(i);
                    if (childMeta.numOdata == 0 || BasicRepository.checkType1(childMeta)) continue block4;
                    return false;
                }
                case 29: 
                case 30: 
                case 99: {
                    return false;
                }
                default: {
                    continue block4;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicRepositoryMonitor getMonitor() {
        BasicRepository basicRepository = this;
        synchronized (basicRepository) {
            if (this.monitor == null) {
                this.monitor = new BasicRepositoryMonitor();
            }
        }
        return this.monitor;
    }

    @Override
    public void load(Reader reader) throws IOException {
        new RepReader(this).load(reader);
    }

    @Override
    public void save(Writer writer) throws IOException {
        new RepWriter(this).write(writer);
    }

    class BasicRepositoryMonitor
    implements JCoRepositoryMonitor {
        BasicRepositoryMonitor() {
        }

        @Override
        public long getLastAccessTimestamp() {
            return BasicRepository.this.lastAccessTimestamp;
        }

        @Override
        public long getLastRemoteQueryTimestamp() {
            return 0L;
        }

        @Override
        public int getFunctionMetaDataCount() {
            return BasicRepository.this.storage.getFunctionMetaDataCount();
        }

        @Override
        public int getTypeMetaDataCount() {
            return BasicRepository.this.storage.getRecordMetaDataCount();
        }

        @Override
        public int getClassMetaDataCount() {
            return BasicRepository.this.storage.getClassMetaDataCount();
        }

        @Override
        public List<String> getDestinationIDs() {
            return new ArrayList<String>(0);
        }

        @Override
        public JCoDestinationMonitor getRespositoryDestinationMonitor(String destinationID) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The destination with ID " + destinationID + " is not used by this repository " + BasicRepository.this.getName());
        }

        public JCoRepository getRepository() {
            return BasicRepository.this;
        }
    }
}

