/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentIterator;
import java.util.NoSuchElementException;

public class SegmentIterator
implements IDocSegmentIterator {
    public static final int ITERATE_OVER_ALL = 1;
    public static final int ITERATE_OVER_ALL_OF_SAME_TYPE = 2;
    public static final int ITERATE_OVER_SIBLINGS = 3;
    public static final int ITERATE_OVER_SIBLINGS_OF_SAME_TYPE = 4;
    public static final int ITERATE_OVER_CHILDREN = 5;
    public static final int ITERATE_OVER_DESCENDANTS = 6;
    protected IDocSegment m_currentSegment = null;
    protected IDocSegment m_nextSegment = null;
    protected String m_segmentType = null;
    protected int m_iterationType = 0;
    protected int m_parentLevel = -1;

    public SegmentIterator(int iterationType, IDocSegment firstSegment) {
        if (iterationType < 1 && iterationType > 4) {
            throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
        }
        if (firstSegment == null) {
            return;
        }
        this.m_iterationType = iterationType;
        this.m_nextSegment = firstSegment;
        if (iterationType == 2 || iterationType == 4) {
            this.m_segmentType = firstSegment.getType();
        }
    }

    public SegmentIterator(IDocSegment parentSegment, int iterationType) {
        if (iterationType < 5 && iterationType > 6) {
            throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
        }
        if (parentSegment == null) {
            return;
        }
        this.m_nextSegment = parentSegment.getFirstChild();
        switch (iterationType) {
            case 5: {
                this.m_iterationType = 3;
                break;
            }
            case 6: {
                this.m_iterationType = 1;
                this.m_parentLevel = parentSegment.getHierarchyLevel();
            }
        }
    }

    public SegmentIterator(IDocSegment parentSegment, int iterationType, String segmentType) {
        if (iterationType < 5 && iterationType > 6) {
            throw new IllegalArgumentException("Invalid iteration type (iterationType == " + iterationType + ")");
        }
        if (parentSegment == null) {
            return;
        }
        this.m_nextSegment = parentSegment.getFirstChild(segmentType);
        this.m_segmentType = segmentType;
        switch (iterationType) {
            case 5: {
                this.m_iterationType = 4;
                break;
            }
            case 6: {
                this.m_iterationType = 2;
                this.m_parentLevel = parentSegment.getHierarchyLevel();
            }
        }
    }

    public boolean hasNext() {
        if (this.m_nextSegment != null) {
            return true;
        }
        if (this.m_currentSegment == null) {
            return false;
        }
        switch (this.m_iterationType) {
            case 1: {
                this.m_nextSegment = this.m_currentSegment.getNext();
                break;
            }
            case 2: {
                this.m_nextSegment = this.m_currentSegment.getNext(this.m_segmentType);
                break;
            }
            case 3: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling();
                return this.m_nextSegment != null;
            }
            case 4: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
                return this.m_nextSegment != null;
            }
        }
        if (this.m_nextSegment == null) {
            return false;
        }
        if (this.m_parentLevel > -1 && this.m_nextSegment.getHierarchyLevel() <= this.m_parentLevel) {
            this.m_nextSegment = null;
            return false;
        }
        return true;
    }

    public IDocSegment next() {
        if (this.hasNext()) {
            this.m_currentSegment = this.m_nextSegment;
            this.m_nextSegment = null;
            return this.m_currentSegment;
        }
        this.m_currentSegment = null;
        throw new NoSuchElementException("SegmentIterator.nextSegment()");
    }

    public void remove() {
        if (this.m_currentSegment == null) {
            throw new IllegalStateException("SegmentIterator.remove()");
        }
        switch (this.m_iterationType) {
            case 1: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling();
                if (this.m_nextSegment != null) break;
                this.m_nextSegment = this.m_currentSegment.getNext();
                if (this.m_parentLevel <= -1 || this.m_nextSegment == null || this.m_nextSegment.getHierarchyLevel() > this.m_parentLevel) break;
                this.m_nextSegment = null;
                break;
            }
            case 2: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
                if (this.m_nextSegment != null) break;
                this.m_nextSegment = this.m_currentSegment.getNext(this.m_segmentType);
                if (this.m_parentLevel <= -1 || this.m_nextSegment == null || this.m_nextSegment.getHierarchyLevel() > this.m_parentLevel) break;
                this.m_nextSegment = null;
                break;
            }
            case 3: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling();
                break;
            }
            case 4: {
                this.m_nextSegment = this.m_currentSegment.getNextSibling(this.m_segmentType);
            }
        }
        this.m_currentSegment.remove();
        this.m_currentSegment = null;
    }
}

