/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt.xml;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocException;
import com.sap.conn.idoc.IDocFactory;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocMetaDataUnavailableException;
import com.sap.conn.idoc.IDocParseException;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocXMLFormat;
import com.sap.conn.idoc.rt.DefaultIDocDocument;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.record.impl.AbstractRecord;
import com.sap.conn.idoc.rt.util.Utils;
import com.sap.conn.idoc.rt.xml.XMLChar;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class DefaultIDocXMLParser {
    private static final char AMP = '&';
    private static final char APOS = '\'';
    private static final char BOM = '\ufeff';
    private static final char CR = '\r';
    private static final char EM = '!';
    private static final char EQ = '=';
    private static final char GT = '>';
    private static final char HYP = '-';
    private static final char LF = '\n';
    private static final char LL = '_';
    private static final char LSB = '[';
    private static final char LT = '<';
    private static final char NUM = '#';
    private static final char QM = '?';
    private static final char QUOT = '\"';
    private static final char RSB = ']';
    private static final char SEM = ';';
    private static final char SL = '/';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char[] CA_CDATA_START = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private static final String STR_IDOC = "IDOC";
    private static final String STR_BEGIN = "BEGIN";
    private static final String STR_SEGMENT = "SEGMENT";
    private static final String STR_1 = "1";
    private static final String STR_EDI_DC40 = "EDI_DC40";
    private static final String STR_NONE = "NONE";
    private static final String STR_XML = "xml";
    private static final String STR_VERSION = "version";
    private static final String STR_ENCODING = "encoding";
    private static final String STR_STANDALONE = "standalone";
    private static final String STR_DOCTYPE = "DOCTYPE";
    private static final String STR_ENC_EBCDIC = "EBCDIC";
    private static final String STR_ENC_UCS4 = "ISO-10646-UCS-4";
    private static final String STR_ENC_UTF8 = "UTF-8";
    private static final String STR_ENC_UTF16BE = "UTF-16BE";
    private static final String STR_ENC_UTF16LE = "UTF-16LE";
    private static final String STR_ENC_UTF32BE = "UTF-32BE";
    private static final String STR_ENC_UTF32LE = "UTF-32LE";
    private static final int DEFAULT_BUFFERSIZE = 8192;
    private static final int TAB_ADD_COLUMNS = 3;
    private static final LinkedHashMap<String, ArrayList<String>> iDocAttributes = new LinkedHashMap(3);
    private static final LinkedHashMap<String, ArrayList<String>> segmentAttributes;
    private static final ArrayList<String> xmlDeclAttribNames;
    private static final HashMap<String, String> defaultEntities;
    private IDocFactory iDocFactory = null;
    private IDocRepository repository = null;
    private IDocDocumentList iDocList = null;
    private InputStream stream = null;
    private Reader reader = null;
    private IDocXMLFormat format = null;
    private String encoding = null;
    private int options = 0;
    private Properties xmlDeclAttribs = new Properties();
    private int xmlVersion = 0;
    private CharBuffer xml = CharBuffer.allocate(8192);
    private State state = State.INITIAL;
    private State prevState = State.INITIAL;
    private State nextState = State.INITIAL;
    private LinkedList<String> openTags = new LinkedList();
    private int charPosition = -1;
    private int lineNumber = 1;
    private int columnNumber = 0;
    private int tokenPos = 0;
    private boolean escapedTag = false;
    private boolean escapedValue = false;
    private StringBuilder tagBuffer = null;
    private StringBuilder valueBuffer = null;
    private CharSequence token = null;
    private CharSequence fieldName = null;
    private CharSequence fieldValue = null;
    private char delimiter = '\u0000';
    private String attribName = null;
    private String systemRelease = null;
    private String applicationRelease = null;

    protected DefaultIDocXMLParser(IDocFactory iDocFactory, IDocRepository repository, InputStream xmlStream, IDocXMLFormat format, int options, String systemRelease, String applicationRelease) {
        this.iDocFactory = iDocFactory;
        this.repository = repository;
        this.stream = xmlStream.markSupported() ? xmlStream : new BufferedInputStream(xmlStream, 8192);
        this.format = format;
        this.options = this.evaluateOptions(options);
        this.systemRelease = systemRelease;
        this.applicationRelease = applicationRelease;
    }

    protected DefaultIDocXMLParser(IDocFactory iDocFactory, IDocRepository repository, Reader xmlReader, IDocXMLFormat format, int options, String systemRelease, String applicationRelease) {
        this.iDocFactory = iDocFactory;
        this.repository = repository;
        this.reader = xmlReader;
        this.format = format;
        this.options = this.evaluateOptions(options);
        this.systemRelease = systemRelease;
        this.applicationRelease = applicationRelease;
    }

    protected void checkXMLVersion(String version) throws IDocParseException {
        if (this.xmlVersion > 0) {
            throw this.newIDocParseException();
        }
        if (version == null || version.equals("1.0")) {
            this.xmlVersion = 10;
            if ((this.options & 0x200) != 0) {
                throw new IDocParseException("XML version 1.0 document is refused due to specified IDocXML parsing options", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
            }
        } else if (version.equals("1.1")) {
            this.xmlVersion = 11;
            if ((this.options & 0x400) != 0) {
                throw new IDocParseException("XML version 1.1 document is refused due to specified IDocXML parsing options", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
            }
        } else {
            this.xmlVersion = 11;
            try {
                if (version.length() < 3) {
                    Integer.parseInt(version);
                } else {
                    StringBuilder versionBuf = new StringBuilder(version.length()).append(version);
                    int index = version.indexOf(46, 1);
                    if (index > 0 && index < version.length() - 1) {
                        versionBuf.deleteCharAt(index);
                    }
                    Integer.parseInt(versionBuf.toString());
                }
            }
            catch (Exception exc) {
                throw new IDocParseException("Illegal 'version' attribute value in XML declaration <?xml version=\"" + version + "\"?>", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
            }
            if ((this.options & 0x100) != 0) {
                throw new IDocParseException("Unknown XML version " + version + " document is refused due to specified IDocXML parsing options", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
            }
        }
    }

    protected void createReader(String encoding) throws IOException {
        if (encoding == null) {
            this.stream.mark(Integer.MAX_VALUE);
            byte[] b = new byte[4];
            if (this.stream.read(b) < 4) {
                this.stream = null;
                return;
            }
            switch (b[0]) {
                case 0: {
                    if (b[1] == 0) {
                        if (b[2] == 0 && b[3] == 60) {
                            this.encoding = STR_ENC_UTF32BE;
                            break;
                        }
                        if (b[2] == 60 && b[3] == 0) {
                            this.encoding = STR_ENC_UCS4;
                            break;
                        }
                        if (b[2] == 254 && b[3] == 255) {
                            this.encoding = STR_ENC_UTF32BE;
                            break;
                        }
                        if (b[2] == 255 && b[3] == 254) {
                            this.encoding = STR_ENC_UCS4;
                            break;
                        }
                        this.encoding = STR_ENC_UTF8;
                        break;
                    }
                    if (b[1] == 60) {
                        if (b[2] == 0 && b[3] == 0) {
                            this.encoding = STR_ENC_UCS4;
                            break;
                        }
                        if (b[2] == 0 && b[3] == 63) {
                            this.encoding = STR_ENC_UTF16BE;
                            break;
                        }
                        this.encoding = STR_ENC_UTF16BE;
                        break;
                    }
                    this.encoding = STR_ENC_UTF8;
                    break;
                }
                case 60: {
                    if (b[1] == 0) {
                        if (b[2] == 0 && b[3] == 0) {
                            this.encoding = STR_ENC_UTF32LE;
                            break;
                        }
                        if (b[2] == 63 && b[3] == 0) {
                            this.encoding = STR_ENC_UTF16LE;
                            break;
                        }
                        this.encoding = STR_ENC_UTF16LE;
                        break;
                    }
                    this.encoding = STR_ENC_UTF8;
                    break;
                }
                case 76: {
                    if (b[1] == 111 && b[2] == 167 && b[3] == 148) {
                        this.encoding = STR_ENC_EBCDIC;
                        break;
                    }
                    this.encoding = STR_ENC_UTF8;
                    break;
                }
                case -2: {
                    if (b[1] == 255) {
                        if (b[2] == 0 && b[3] == 0) {
                            this.encoding = STR_ENC_UCS4;
                            break;
                        }
                        this.encoding = STR_ENC_UTF16BE;
                        break;
                    }
                    this.encoding = STR_ENC_UTF8;
                    break;
                }
                case -1: {
                    if (b[1] == 254) {
                        if (b[2] == 0 && b[3] == 0) {
                            this.encoding = STR_ENC_UTF32LE;
                            break;
                        }
                        this.encoding = STR_ENC_UTF16LE;
                        break;
                    }
                    this.encoding = STR_ENC_UTF8;
                    break;
                }
                default: {
                    this.encoding = STR_ENC_UTF8;
                }
            }
        } else {
            if (!encoding.equalsIgnoreCase(this.encoding)) {
                this.stream.reset();
                this.stream.mark(0);
                this.reader = new InputStreamReader(this.stream, encoding);
                this.reader.skip(this.charPosition + 1);
            }
            this.encoding = encoding;
            this.stream = null;
            return;
        }
        this.stream.reset();
        this.reader = new InputStreamReader(this.stream, this.encoding);
    }

    protected int evaluateOptions(int options) {
        if (DefaultIDocRuntime.xmlParseOptions_useAlways != 0) {
            options |= DefaultIDocRuntime.xmlParseOptions_useAlways;
        }
        return options;
    }

    protected IDocParseException newIDocParseException() {
        StringBuffer message = new StringBuffer(100);
        message.append("Invalid XML ");
        if (this.xmlVersion > 0) {
            message.append(this.xmlVersion / 10).append('.').append(this.xmlVersion % 10).append(' ');
        }
        message.append("character encountered within IDocXML");
        if (!this.openTags.isEmpty()) {
            message.append(" for type <").append(this.openTags.getFirst()).append('>');
        }
        return this.newIDocParseException(message.toString(), null);
    }

    protected IDocParseException newIDocParseException(String message, Throwable cause) {
        int invalidCharPos = this.xml.position() - 1;
        this.xml.position(Math.max(0, invalidCharPos - 70));
        String xmlSnippet = ((Object)this.xml.subSequence(0, Math.min(100, this.xml.remaining()))).toString();
        return new IDocParseException(message, this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, xmlSnippet, invalidCharPos - this.xml.position(), cause);
    }

    public IDocDocumentList parse() throws IOException, IDocParseException {
        this.read();
        this.parseProlog();
        try {
            this.parseElements();
        }
        catch (IDocParseException ipe) {
            throw ipe;
        }
        catch (IDocMetaDataUnavailableException imdue) {
            throw new IDocParseException(this.state.name(), imdue);
        }
        catch (IDocFieldNotFoundException ifnfe) {
            throw this.newIDocParseException("An " + ifnfe.getClass().getSimpleName() + " occurred while parsing IDocXML" + (this.openTags.isEmpty() ? "" : " for type <" + this.openTags.getFirst() + ">"), ifnfe);
        }
        catch (IDocException ie) {
            throw new IDocParseException("An " + ie.getClass().getSimpleName() + " occurred while parsing IDocXML" + (this.openTags.isEmpty() ? "" : " for type <" + this.openTags.getFirst() + ">"), this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0, ie);
        }
        if (!this.openTags.isEmpty()) {
            throw this.newIDocParseException();
        }
        block8: while (this.xml.hasRemaining() || this.read() != 0) {
            switch (this.xml.get()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block8;
                }
            }
            throw this.newIDocParseException();
        }
        return this.iDocList;
    }

    protected void parseDTD() throws IOException {
        int countOpenedTags = 1;
        char c = '\u0000';
        while (countOpenedTags > 0 && (this.xml.hasRemaining() || this.read() > 0)) {
            char last = c;
            c = this.xml.get();
            ++this.charPosition;
            ++this.columnNumber;
            switch (c) {
                case '<': {
                    ++countOpenedTags;
                    break;
                }
                case '>': {
                    --countOpenedTags;
                    break;
                }
                case '\r': {
                    ++this.lineNumber;
                    this.columnNumber = 0;
                    break;
                }
                case '\n': {
                    if (last != '\r') {
                        ++this.lineNumber;
                    }
                    this.columnNumber = 0;
                    break;
                }
                case '\t': {
                    this.columnNumber += 3;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parseElements() throws IOException, IDocException, IDocParseException {
        iDoc = null;
        segment = null;
        parentSegment = null;
        controlRecord = null;
        segmentType = null;
        attribute = null;
        attribIterator = null;
        attribValues = null;
        parsedEQ = false;
        parsedWS = false;
        c = '\u0000';
        last = '\u0000';
        secondlast = '\u0000';
        while (this.state != State.READING_MISCELLANEOUS && (this.xml.hasRemaining() || this.read() > 0)) {
            last = c;
            c = this.xml.get();
            ++this.charPosition;
            ++this.columnNumber;
            block1 : switch (1.$SwitchMap$com$sap$conn$idoc$rt$xml$DefaultIDocXMLParser$State[this.state.ordinal()]) {
                case 1: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            this.openTags.add(this.token.toString());
                            this.prevState = State.READING_IDOCTYPE;
                            this.state = State.EXPECTING_IMMEDIATE_TAG_END;
                            this.nextState = State.READING_IDOC;
                            break block1;
                        }
                        case '>': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            this.openTags.add(this.token.toString());
                            this.state = State.READING_IDOC;
                            break block1;
                        }
                        case '/': {
                            throw this.newIDocParseException();
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false) break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 2: {
                    switch (c) {
                        case '<': {
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_IDOC_STARTTAG;
                            break block1;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case 3: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            if (!Utils.contentEquals("IDOC", this.token)) {
                                throw new IDocParseException("Missing required <IDOC BEGIN=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            this.openTags.add("IDOC");
                            this.tokenPos = this.xml.position();
                            if (this.iDocList != null) {
                                iDoc = this.iDocList.addNew();
                                iDoc.setIDocType(null);
                                iDoc.setIDocTypeExtension(null);
                                iDoc.setIDocCompoundType(null);
                                iDoc.setCreationDate(null);
                                iDoc.setCreationTime(null);
                                if ((this.options & 1) != 0) {
                                    iDoc.enableFieldValueChecking();
                                }
                                parentSegment = iDoc.getRootSegment();
                            }
                            attribIterator = DefaultIDocXMLParser.iDocAttributes.entrySet().iterator();
                            parsedEQ = false;
                            parsedWS = true;
                            this.prevState = State.READING_IDOC;
                            this.state = State.READING_ATTRIBUTE;
                            this.nextState = State.READING_CONTROLRECORD;
                            break block1;
                        }
                        case '>': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            if (!Utils.contentEquals("IDOC", this.token)) {
                                throw new IDocParseException("Missing required <IDOC BEGIN=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            throw new IDocParseException("Missing required BEGIN attribute in <IDOC BEGIN=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '/': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                if (this.iDocList == null) {
                                    throw new IDocParseException("Missing required <IDOC BEGIN=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                                }
                                this.state = State.READING_ENDTAG;
                                this.tokenPos = this.xml.position();
                                break block1;
                            }
                            this.storeToken();
                            if (!Utils.contentEquals("IDOC", this.token)) {
                                throw new IDocParseException("Missing required <IDOC BEGIN=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            throw new IDocParseException("Missing required BEGIN attribute in <IDOC BEGIN=\"1\"/> empty tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false) break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 4: {
                    switch (c) {
                        case '<': {
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_CONTROLRECORD_STARTTAG;
                            break block1;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case 5: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            if (!Utils.contentEquals(this.token, "EDI_DC40")) {
                                throw new IDocParseException("Missing required <EDI_DC40 SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            segmentType = "EDI_DC40";
                            this.openTags.add(segmentType);
                            this.tokenPos = this.xml.position();
                            if (this.iDocList == null) {
                                controlRecord = new IDocControlRecord();
                                if ((this.options & 1) != 0) {
                                    controlRecord.enableFieldValueChecking(false);
                                }
                            }
                            attribIterator = DefaultIDocXMLParser.segmentAttributes.entrySet().iterator();
                            parsedEQ = false;
                            parsedWS = true;
                            this.prevState = State.READING_IDOC;
                            this.state = State.READING_ATTRIBUTE;
                            this.nextState = State.READING_FIELD;
                            break block1;
                        }
                        case '>': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            if (!Utils.contentEquals(this.token, "EDI_DC40")) {
                                throw new IDocParseException("Missing required <EDI_DC40 SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            throw new IDocParseException("Missing required SEGMENT attribute in <EDI_DC40 SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '/': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw new IDocParseException("Missing required <EDI_DC40 SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            this.storeToken();
                            if (!Utils.contentEquals(this.token, "EDI_DC40")) {
                                throw new IDocParseException("Missing required <EDI_DC40 SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            throw new IDocParseException("Missing required SEGMENT attribute in <EDI_DC40 SEGMENT=\"1\"/> empty tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false) break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 6: {
                    switch (c) {
                        case '<': {
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_SEGMENT_STARTTAG;
                            break block1;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case 7: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            segmentType = this.token.toString();
                            this.openTags.add(segmentType);
                            segment = parentSegment.addChild(segmentType);
                            this.tokenPos = this.xml.position();
                            attribIterator = DefaultIDocXMLParser.segmentAttributes.entrySet().iterator();
                            parsedEQ = false;
                            parsedWS = true;
                            this.prevState = State.READING_SEGMENT;
                            this.state = State.READING_ATTRIBUTE;
                            this.nextState = State.READING_FIELD;
                            break block1;
                        }
                        case '>': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.storeToken();
                            throw new IDocParseException("Missing required SEGMENT attribute in <" + this.token + " SEGMENT=\"1\"> start tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '/': {
                            if (!parsedWS && this.tokenPos == this.xml.position() - 1) {
                                this.tokenPos = this.xml.position();
                                this.state = State.READING_ENDTAG;
                                this.nextState = State.READING_SEGMENT;
                                break block1;
                            }
                            this.storeToken();
                            throw new IDocParseException("Missing required SEGMENT attribute in <" + this.token + " SEGMENT=\"1\"/> empty tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false) break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 8: {
                    switch (c) {
                        case '<': {
                            this.tokenPos = this.xml.position();
                            parsedWS = false;
                            this.state = State.READING_FIELD_STARTTAG;
                            break block1;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case 9: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedWS = true;
                            this.storeToken();
                            this.fieldName = this.token;
                            this.tokenPos = this.xml.position();
                            break;
                        }
                        case '>': {
                            if (!parsedWS) {
                                if (this.tokenPos == this.xml.position() - 1) {
                                    throw this.newIDocParseException();
                                }
                                this.storeToken();
                                this.fieldName = this.token;
                            }
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_FIELD_VALUE;
                            break;
                        }
                        case '/': {
                            if (!parsedWS && this.tokenPos == this.xml.position() - 1) {
                                this.tokenPos = this.xml.position();
                                this.state = State.READING_ENDTAG;
                                this.nextState = State.READING_SEGMENT;
                                break;
                            }
                            if ((this.options & 2) == 0) {
                                if (this.fieldName == null) {
                                    this.storeToken();
                                    this.fieldName = this.token;
                                }
                                if (segment != null) {
                                    segment.getString(this.fieldName.toString());
                                } else if (iDoc != null) {
                                    iDoc.getString(this.fieldName.toString());
                                } else if (controlRecord != null) {
                                    controlRecord.getString(this.fieldName.toString());
                                } else {
                                    throw this.newIDocParseException();
                                }
                            }
                            this.fieldName = null;
                            this.state = State.EXPECTING_IMMEDIATE_TAG_END;
                            this.nextState = State.READING_FIELD;
                            break;
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1) {
                                if (XMLChar.isNameChar(c)) break block1;
                                throw this.newIDocParseException();
                            }
                            if (!XMLChar.isNameStartChar(c)) {
                                throw this.newIDocParseException();
                            }
                            if (!parsedWS) break block1;
                            segmentType = this.fieldName.toString();
                            this.fieldName = null;
                            if (segment == null) {
                                throw new IDocParseException("Illegal child segment type \"" + segmentType + "\" in EDI_DC40 control record segment within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            this.openTags.add(segmentType);
                            parentSegment = segment;
                            segment = parentSegment.addChild(segmentType);
                            attribIterator = DefaultIDocXMLParser.segmentAttributes.entrySet().iterator();
                            parsedEQ = false;
                            parsedWS = true;
                            this.prevState = State.READING_SEGMENT;
                            this.state = State.READING_ATTRIBUTE;
                            this.nextState = State.READING_FIELD;
                            break;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (c) {
                        case '=': {
                            if (!parsedWS || this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedEQ = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (!parsedWS) {
                                parsedWS = true;
                                this.tokenPos = this.xml.position();
                                break block1;
                            }
                            parsedWS = false;
                            this.storeToken();
                            if (attribIterator.hasNext()) {
                                attribute = (Map.Entry)attribIterator.next();
                                this.attribName = (String)attribute.getKey();
                                if (Utils.contentEquals(this.attribName, this.token)) {
                                    this.state = State.READING_ATTRIBUTE_VALUE;
                                    break block1;
                                }
                            } else {
                                this.attribName = "NONE";
                            }
                            throw new IDocParseException("Illegal attribute " + this.token + (this.attribName != "NONE" ? " instead of expected attribute " + this.attribName : "") + " in <" + (segmentType == null ? "IDOC BEGIN" : segmentType + " SEGMENT") + "=\"1\"> tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                        }
                    }
                    if (parsedWS && (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false)) break;
                    throw this.newIDocParseException();
                }
                case 11: {
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            if (this.delimiter == '\u0000') {
                                if (!parsedEQ) {
                                    throw this.newIDocParseException();
                                }
                                this.delimiter = c;
                                this.tokenPos = this.xml.position();
                                break block1;
                            }
                            if (c != this.delimiter) break block1;
                            this.storeToken();
                            attribValues = (ArrayList)attribute.getValue();
                            if (attribValues != null && !attribValues.contains(this.token.toString())) {
                                throw new IDocParseException("Illegal value \"" + this.token + "\" for attribute " + this.attribName + " in <" + (segmentType == null ? "IDOC " : segmentType + " ") + this.attribName + "=\"1\"> tag within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            this.delimiter = '\u0000';
                            parsedEQ = false;
                            parsedWS = false;
                            if (attribIterator.hasNext()) {
                                this.state = State.READING_ATTRIBUTE;
                                break block1;
                            }
                            this.state = State.EXPECTING_TAG_END;
                            break block1;
                        }
                        case '=': {
                            if (this.delimiter != '\u0000') break block1;
                            if (!parsedEQ) {
                                parsedEQ = true;
                                break block1;
                            }
                            throw this.newIDocParseException();
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.delimiter != '\u0000') break block1;
                            if (parsedEQ && !parsedWS) {
                                parsedWS = true;
                                break block1;
                            }
                            throw this.newIDocParseException();
                        }
                        case '&': {
                            this.escapedValue = true;
                            break block1;
                        }
                        case '<': {
                            throw this.newIDocParseException();
                        }
                        default: {
                            if (this.delimiter != '\u0000') break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 12: {
                    switch (c) {
                        case '&': {
                            this.escapedValue = true;
                            break block1;
                        }
                        case '<': {
                            if (this.tokenPos < this.xml.position() - 1) {
                                this.storeToken();
                                if (this.fieldValue == null) {
                                    this.fieldValue = this.token;
                                } else {
                                    if (!(this.fieldValue instanceof StringBuilder)) {
                                        this.fieldValue = new StringBuilder(this.fieldValue);
                                    }
                                    ((StringBuilder)this.fieldValue).append(this.token, 0, this.token.length());
                                }
                            }
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_FIELD_VALUE_TAG;
                            break block1;
                        }
                    }
                    if ((this.xmlVersion != 10 || !XMLChar.isInvalidV10IgnoreSurrogates(c)) && !XMLChar.isInvalidIgnoreSurrogates(c) || (this.options & 4) != 0) break;
                    throw this.newIDocParseException();
                }
                case 13: {
                    switch (c) {
                        case '/': {
                            if (this.tokenPos < this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.fieldValue == null) ** GOTO lbl432
                            try {
                                if (segment == null) ** GOTO lbl420
                                segment.setValue(this.fieldName.toString(), this.fieldValue.toString());
                                ** GOTO lbl430
lbl420:
                                // 1 sources

                                if (iDoc == null) ** GOTO lbl423
                                iDoc.setValue(this.fieldName.toString(), this.fieldValue.toString());
                                ** GOTO lbl430
lbl423:
                                // 1 sources

                                if (controlRecord == null) ** GOTO lbl426
                                controlRecord.setValue(this.fieldName.toString(), this.fieldValue.toString());
                                ** GOTO lbl430
lbl426:
                                // 1 sources

                                throw this.newIDocParseException();
                            }
                            catch (IDocFieldNotFoundException ifnfe) {
                                if ((this.options & 2) != 0) ** GOTO lbl430
                                throw ifnfe;
                            }
lbl430:
                            // 4 sources

                            this.fieldValue = null;
                            ** GOTO lbl446
lbl432:
                            // 1 sources

                            if ((this.options & 2) == 0) {
                                if (segment != null) {
                                    segment.getString(this.fieldName.toString());
                                } else if (iDoc != null) {
                                    iDoc.getString(this.fieldName.toString());
                                } else if (controlRecord != null) {
                                    controlRecord.getString(this.fieldName.toString());
                                } else {
                                    throw this.newIDocParseException();
                                }
                            }
lbl446:
                            // 6 sources

                            this.tokenPos = this.xml.position();
                            parsedWS = false;
                            this.state = State.READING_ENDTAG;
                            break block1;
                        }
                        case '!': {
                            if (this.tokenPos >= this.xml.position() - 1) break block1;
                            throw this.newIDocParseException();
                        }
                        case '[': {
                            if (last != '!') {
                                throw this.newIDocParseException();
                            }
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_FIELD_CDATA_START;
                            break block1;
                        }
                        default: {
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 14: {
                    if (c != DefaultIDocXMLParser.CA_CDATA_START[this.xml.position() - this.tokenPos - 1]) {
                        throw this.newIDocParseException();
                    }
                    if (this.xml.position() - this.tokenPos != DefaultIDocXMLParser.CA_CDATA_START.length) break;
                    this.tokenPos = this.xml.position();
                    this.state = State.READING_FIELD_CDATA_VALUE;
                    break;
                }
                case 15: {
                    switch (c) {
                        case '>': {
                            if (last == ']' && secondlast == ']') {
                                if (this.tokenPos < this.xml.position() - 3) {
                                    currentPos = this.xml.position();
                                    this.xml.position(currentPos - 2);
                                    this.storeToken();
                                    this.xml.position(currentPos);
                                    if (this.fieldValue == null) {
                                        this.fieldValue = this.token;
                                    } else {
                                        if (!(this.fieldValue instanceof StringBuilder)) {
                                            this.fieldValue = new StringBuilder(this.fieldValue);
                                        }
                                        ((StringBuilder)this.fieldValue).append(this.token, 0, this.token.length());
                                    }
                                }
                                this.tokenPos = this.xml.position();
                                this.state = State.READING_FIELD_VALUE;
                            }
                            secondlast = '\u0000';
                            break block1;
                        }
                        case ']': {
                            secondlast = last;
                            break block1;
                        }
                    }
                    if ((this.xmlVersion != 10 || !XMLChar.isInvalidV10IgnoreSurrogates(c)) && !XMLChar.isInvalidIgnoreSurrogates(c) || (this.options & 4) != 0) break;
                    throw this.newIDocParseException();
                }
                case 16: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            this.state = State.EXPECTING_IMMEDIATE_TAG_END;
                        }
                        case '>': {
                            if (this.fieldName != null) {
                                if (this.escapedTag && this.fieldName == this.tagBuffer) {
                                    this.fieldName = this.fieldName.toString();
                                }
                                this.storeToken();
                                if (!Utils.contentEquals(this.fieldName, this.token)) {
                                    throw this.newIDocParseException("End tag <" + this.token + "> does not match start tag <" + this.fieldName + "> within IDocXML for type <" + this.openTags.getFirst() + ">", null);
                                }
                                this.fieldName = null;
                            } else {
                                this.storeToken();
                                starttag = this.openTags.removeLast();
                                if (!Utils.contentEquals(starttag, this.token)) {
                                    throw this.newIDocParseException("End tag <" + this.token + "> does not match start tag <" + starttag + "> within IDocXML for type <" + this.openTags.getFirst() + ">", null);
                                }
                                if (segment != null) {
                                    segmentType = null;
                                    segment = null;
                                } else if (parentSegment != null) {
                                    if (segmentType == "EDI_DC40") {
                                        iDocType = iDoc.getIDocType();
                                        cimType = iDoc.getIDocTypeExtension();
                                        if (cimType.length() > 0 && !cimType.equals(this.openTags.getFirst()) || cimType.length() == 0 && !iDocType.equals(this.openTags.getFirst())) {
                                            throw new IDocParseException("IDoc type " + (cimType.length() > 0 ? "extension " + cimType : iDocType) + " within the EDI_DC40 control record segment does not match the IDocXML root tag <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                                        }
                                    } else if ((parentSegment = parentSegment.getParent()) == null) {
                                        iDoc = null;
                                        this.nextState = State.READING_IDOC;
                                    }
                                } else if (controlRecord != null) {
                                    iDocType = controlRecord.getIDocType();
                                    cimType = controlRecord.getIDocTypeExtension();
                                    if (cimType.length() > 0 && !cimType.equals(this.openTags.getFirst()) || cimType.length() == 0 && !iDocType.equals(this.openTags.getFirst())) {
                                        throw new IDocParseException("IDoc type " + (cimType.length() > 0 ? "extension " + cimType : iDocType) + " within the EDI_DC40 control record segment does not match the IDocXML root tag <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                                    }
                                    this.iDocList = this.iDocFactory.createIDocDocumentList("EDI_DC40", this.repository, iDocType, cimType, this.systemRelease, this.applicationRelease);
                                    iDoc = this.iDocList.addNew();
                                    if ((this.options & 1) != 0) {
                                        iDoc.enableFieldValueChecking();
                                    }
                                    if (!(iDoc instanceof AbstractRecord)) {
                                        throw this.newIDocParseException();
                                    }
                                    ((AbstractRecord)iDoc).copyContent(controlRecord);
                                    controlRecord = null;
                                    parentSegment = iDoc.getRootSegment();
                                } else if (this.openTags.size() == 0) {
                                    this.nextState = State.READING_MISCELLANEOUS;
                                } else {
                                    throw this.newIDocParseException();
                                }
                            }
                            if (this.state == State.EXPECTING_IMMEDIATE_TAG_END) break block1;
                            this.state = this.nextState;
                            break block1;
                        }
                        case '_': {
                            if (this.tokenPos != this.xml.position() - 1 || this.format != IDocXMLFormat.SAP_RELEASE_46) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (this.escapedTag || (this.format != IDocXMLFormat.SAP_RELEASE_610 || last != '_') && this.format != IDocXMLFormat.SAP_RELEASE_46 && this.format != null) break block1;
                            this.escapedTag = true;
                            break block1;
                        }
                        default: {
                            if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) != false : XMLChar.isNameStartChar(c) != false) break block1;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case 17: {
                    switch (c) {
                        case '>': {
                            this.state = this.nextState;
                            break block1;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (parsedWS) {
                                throw this.newIDocParseException();
                            }
                            parsedWS = true;
                            break block1;
                        }
                        case '/': {
                            if (this.fieldName == null) {
                                if (this.nextState == State.READING_CONTROLRECORD) {
                                    throw new IDocParseException("Missing control record within IDocXML for type <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                                }
                                if (segmentType == "EDI_DC40") {
                                    throw new IDocParseException("IDoc type \"\" within the control record does not match IDocXML root tag <" + this.openTags.getFirst() + ">", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                                }
                                this.openTags.removeLast();
                                segmentType = null;
                                segment = null;
                            }
                            this.nextState = this.prevState;
                            this.state = State.EXPECTING_IMMEDIATE_TAG_END;
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case 18: {
                    switch (c) {
                        case '>': {
                            this.state = this.nextState;
                            break block1;
                        }
                    }
                    throw this.newIDocParseException();
                }
                default: {
                    throw this.newIDocParseException();
                }
            }
            if (c >= ' ') continue;
            switch (c) {
                case '\r': {
                    ++this.lineNumber;
                    this.columnNumber = 0;
                    break;
                }
                case '\n': {
                    if (last != '\r') {
                        ++this.lineNumber;
                    }
                    this.columnNumber = 0;
                    break;
                }
                case '\t': {
                    this.columnNumber += 3;
                }
            }
        }
        if (this.state != State.READING_MISCELLANEOUS && !this.xml.hasRemaining() && this.read() == 0) {
            throw this.newIDocParseException();
        }
    }

    protected void parseProlog() throws IOException, IDocParseException {
        Iterator<String> xmlDeclAttribNamesIterator = xmlDeclAttribNames.iterator();
        Properties attribs = null;
        boolean parsedBOM = false;
        boolean parsedEQ = false;
        boolean parsedHYP = false;
        boolean parsedWS = false;
        char c = '\u0000';
        while (this.state != State.READING_IDOCTYPE && (this.xml.hasRemaining() || this.read() > 0)) {
            char last = c;
            c = this.xml.get();
            ++this.charPosition;
            ++this.columnNumber;
            block0 : switch (this.state) {
                case INITIAL: {
                    switch (c) {
                        case 60: {
                            this.state = State.OPENED_FIRST_TAG;
                            break block0;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            parsedWS = true;
                            break block0;
                        }
                        case 65279: {
                            if (parsedBOM || parsedWS) {
                                throw this.newIDocParseException();
                            }
                            parsedBOM = true;
                            break block0;
                        }
                    }
                    throw this.newIDocParseException();
                }
                case READING_ATTRIBUTE_VALUE: {
                    switch (c) {
                        case 34: 
                        case 39: {
                            if (this.delimiter == '\u0000') {
                                if (!parsedEQ) {
                                    throw this.newIDocParseException();
                                }
                                this.delimiter = c;
                                this.tokenPos = this.xml.position();
                                break block0;
                            }
                            if (c != this.delimiter) break block0;
                            this.storeToken();
                            if (attribs == this.xmlDeclAttribs) {
                                String attribValue = ((Object)this.token).toString();
                                if (this.attribName == STR_VERSION) {
                                    this.checkXMLVersion(attribValue);
                                }
                                attribs.put(this.attribName, attribValue);
                            } else if (attribs != null) {
                                attribs.put(this.attribName, ((Object)this.token).toString());
                            }
                            this.delimiter = '\u0000';
                            parsedEQ = false;
                            parsedWS = false;
                            this.state = this.nextState;
                            break block0;
                        }
                        case 61: {
                            if (this.delimiter != '\u0000') break block0;
                            if (!parsedEQ) {
                                parsedEQ = true;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            if (this.delimiter != '\u0000') break block0;
                            if (parsedEQ && !parsedWS) {
                                parsedWS = true;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case 38: {
                            this.escapedValue = true;
                            break block0;
                        }
                        case 60: {
                            throw this.newIDocParseException();
                        }
                        default: {
                            if (this.delimiter != '\u0000') break block0;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case READING_PROLOG: {
                    switch (c) {
                        case 60: {
                            this.state = State.OPENED_PROLOG_TAG;
                            break block0;
                        }
                    }
                    if (XMLChar.isWhiteSpace(c)) break;
                    throw this.newIDocParseException();
                }
                case OPENED_FIRST_TAG: {
                    switch (c) {
                        case 63: {
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_FIRST_TARGETNAME;
                            break block0;
                        }
                        case 33: {
                            this.tokenPos = this.xml.position();
                            parsedHYP = false;
                            this.checkXMLVersion(null);
                            if (this.stream != null) {
                                this.createReader(this.encoding);
                            }
                            this.state = State.READING_MARKUPDECLARATION;
                            break block0;
                        }
                        case 62: {
                            throw this.newIDocParseException();
                        }
                    }
                    if (XMLChar.isNameStartChar(c)) {
                        this.tokenPos = this.xml.position() - 1;
                        this.checkXMLVersion(null);
                        if (this.stream != null) {
                            this.createReader(this.encoding);
                        }
                        this.state = State.READING_IDOCTYPE;
                        break;
                    }
                    throw this.newIDocParseException();
                }
                case OPENED_PROLOG_TAG: {
                    switch (c) {
                        case 63: {
                            this.tokenPos = this.xml.position();
                            this.state = State.READING_PI_TARGETNAME;
                            break block0;
                        }
                        case 33: {
                            this.tokenPos = this.xml.position();
                            parsedHYP = false;
                            this.state = State.READING_MARKUPDECLARATION;
                            break block0;
                        }
                    }
                    if (XMLChar.isNameStartChar(c)) {
                        this.tokenPos = this.xml.position() - 1;
                        this.state = State.READING_IDOCTYPE;
                        break;
                    }
                    throw this.newIDocParseException();
                }
                case READING_FIRST_TARGETNAME: {
                    switch (c) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedWS = true;
                            this.storeToken();
                            this.tokenPos = this.xml.position();
                            if (Utils.contentEqualsIgnoreCase(STR_XML, this.token)) {
                                this.state = State.READING_XMLDECLARATION;
                                break block0;
                            }
                            this.checkXMLVersion(null);
                            if (this.stream != null) {
                                this.createReader(this.encoding);
                            }
                            this.state = State.READING_PROCESSINGINSTRUCTION;
                            break block0;
                        }
                    }
                    if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) : XMLChar.isNameStartChar(c)) break;
                    throw this.newIDocParseException();
                }
                case READING_PI_TARGETNAME: {
                    switch (c) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedWS = true;
                            this.storeToken();
                            this.tokenPos = this.xml.position();
                            if (!Utils.contentEqualsIgnoreCase(STR_XML, this.token)) {
                                this.state = State.READING_PROCESSINGINSTRUCTION;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                    }
                    if (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) : XMLChar.isNameStartChar(c)) break;
                    throw this.newIDocParseException();
                }
                case READING_XMLDECLARATION: {
                    switch (c) {
                        case 61: {
                            if (!parsedWS || this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedEQ = true;
                        }
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: {
                            if (!parsedWS) {
                                parsedWS = true;
                                this.tokenPos = this.xml.position();
                                break block0;
                            }
                            parsedWS = false;
                            this.storeToken();
                            while (xmlDeclAttribNamesIterator.hasNext()) {
                                this.attribName = xmlDeclAttribNamesIterator.next();
                                if (this.attribName == STR_STANDALONE && this.stream != null) {
                                    this.createReader(this.encoding);
                                }
                                if (Utils.contentEquals(this.attribName, this.token)) {
                                    attribs = this.xmlDeclAttribs;
                                    this.state = State.READING_ATTRIBUTE_VALUE;
                                    this.nextState = State.READING_XMLDECLARATION;
                                    break;
                                }
                                if (this.attribName != STR_VERSION) continue;
                                throw new IDocParseException("Missing required 'version' attribute in XML declaration <?xml version=... ?>", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            if (this.state != State.READING_ATTRIBUTE_VALUE) {
                                throw new IDocParseException("Invalid attribute '" + this.token + "' or wrong order of attributes in XML declaration <?xml version=... encoding=... standalone=...?>", this.state.name(), this.charPosition, this.lineNumber, this.columnNumber, null, 0);
                            }
                            if (this.attribName != STR_ENCODING) break block0;
                            this.state = State.READING_ENCODING_VALUE;
                            break block0;
                        }
                        case 63: {
                            if (!parsedWS || this.tokenPos == this.xml.position() - 1) {
                                if (this.stream != null) {
                                    this.createReader(this.encoding);
                                }
                                this.state = State.EXPECTING_PROLOG_END;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        default: {
                            if (parsedWS && (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) : XMLChar.isNameStartChar(c))) break block0;
                            throw this.newIDocParseException();
                        }
                    }
                }
                case READING_ENCODING_VALUE: {
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            if (this.delimiter == '\u0000') {
                                if (!parsedEQ) {
                                    throw this.newIDocParseException();
                                }
                                this.delimiter = c;
                                this.tokenPos = this.xml.position();
                                break block0;
                            }
                            if (c == this.delimiter) {
                                this.storeToken();
                                String encoding = ((Object)this.token).toString();
                                if (attribs != null) {
                                    attribs.put(this.attribName, encoding);
                                }
                                if (this.stream != null) {
                                    this.createReader(encoding);
                                }
                                this.delimiter = '\u0000';
                                parsedEQ = false;
                                parsedWS = false;
                                this.state = this.nextState;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case '=': {
                            if (this.delimiter != '\u0000') {
                                throw this.newIDocParseException();
                            }
                            if (!parsedEQ) {
                                parsedEQ = true;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.delimiter != '\u0000') {
                                throw this.newIDocParseException();
                            }
                            if (parsedEQ && !parsedWS) {
                                parsedWS = true;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case '&': {
                            throw this.newIDocParseException();
                        }
                        case '<': {
                            throw this.newIDocParseException();
                        }
                    }
                    if (this.delimiter != '\u0000' && (this.tokenPos < this.xml.position() - 1 ? XMLChar.isEncNameChar(c) : XMLChar.isEncNameStartChar(c))) break;
                    throw this.newIDocParseException();
                }
                case READING_PROCESSINGINSTRUCTION: {
                    switch (c) {
                        case '=': {
                            if (!parsedWS || this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            parsedEQ = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (!parsedWS) {
                                parsedWS = true;
                                this.tokenPos = this.xml.position();
                                break block0;
                            }
                            parsedWS = false;
                            this.storeToken();
                            attribs = null;
                            this.attribName = ((Object)this.token).toString();
                            this.state = State.READING_ATTRIBUTE_VALUE;
                            this.nextState = State.READING_PROCESSINGINSTRUCTION;
                            break block0;
                        }
                        case '?': {
                            if (!parsedWS || this.tokenPos == this.xml.position() - 1) {
                                this.state = State.EXPECTING_PROLOG_END;
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                    }
                    if (parsedWS && (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) : XMLChar.isNameStartChar(c))) break;
                    throw this.newIDocParseException();
                }
                case READING_MARKUPDECLARATION: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (this.tokenPos == this.xml.position() - 1 || parsedHYP) {
                                throw this.newIDocParseException();
                            }
                            parsedWS = true;
                            this.storeToken();
                            this.tokenPos = this.xml.position();
                            if (Utils.contentEquals(STR_DOCTYPE, this.token)) {
                                switch (c) {
                                    case '\r': {
                                        ++this.lineNumber;
                                        this.columnNumber = 0;
                                        break;
                                    }
                                    case '\n': {
                                        if (last != '\r') {
                                            ++this.lineNumber;
                                        }
                                        this.columnNumber = 0;
                                        break;
                                    }
                                    case '\t': {
                                        this.columnNumber += 3;
                                    }
                                }
                                this.state = State.SKIPPING_DTD;
                                this.parseDTD();
                                this.state = State.READING_PROLOG;
                                c = '>';
                                break block0;
                            }
                            throw this.newIDocParseException();
                        }
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                parsedHYP = true;
                                break block0;
                            }
                            if (!parsedHYP) break;
                            this.tokenPos = this.xml.position();
                            parsedHYP = false;
                            this.state = State.READING_COMMENT;
                            break block0;
                        }
                    }
                    if (!parsedHYP && (this.tokenPos < this.xml.position() - 1 ? XMLChar.isNameChar(c) : XMLChar.isNameStartChar(c))) break;
                    throw this.newIDocParseException();
                }
                case READING_COMMENT: {
                    switch (c) {
                        case '-': {
                            if (this.tokenPos == this.xml.position() - 1) {
                                throw this.newIDocParseException();
                            }
                            if (!parsedHYP) {
                                parsedHYP = true;
                                break block0;
                            }
                            this.state = State.EXPECTING_PROLOG_END;
                            break block0;
                        }
                    }
                    parsedHYP = false;
                    if ((this.xmlVersion != 10 || !XMLChar.isInvalidV10IgnoreSurrogates(c)) && !XMLChar.isInvalidIgnoreSurrogates(c) || (this.options & 4) != 0) break;
                    throw this.newIDocParseException();
                }
                case EXPECTING_PROLOG_END: {
                    switch (c) {
                        case '>': {
                            this.state = State.READING_PROLOG;
                            break block0;
                        }
                    }
                    throw this.newIDocParseException();
                }
                default: {
                    throw this.newIDocParseException();
                }
            }
            if (c >= ' ') continue;
            switch (c) {
                case '\r': {
                    ++this.lineNumber;
                    this.columnNumber = 0;
                    break;
                }
                case '\n': {
                    if (last != '\r') {
                        ++this.lineNumber;
                    }
                    this.columnNumber = 0;
                    break;
                }
                case '\t': {
                    this.columnNumber += 3;
                }
            }
        }
        if (!this.xml.hasRemaining() && this.read() == 0 && this.state != State.READING_PROLOG) {
            throw this.newIDocParseException();
        }
    }

    protected int read() throws IOException {
        if (this.stream != null) {
            int c;
            if (this.reader == null) {
                this.createReader(null);
            }
            if ((c = this.reader.read()) < 0) {
                this.stream = null;
                this.reader = null;
                return 0;
            }
            int pos = this.xml.position();
            this.xml.limit(pos + 1);
            this.xml.put(pos, (char)c);
            return 1;
        }
        int charsRead = 0;
        if (this.reader != null) {
            if (this.fieldName != null) {
                this.fieldName = ((Object)this.fieldName).toString();
            }
            if (this.fieldValue != null) {
                this.fieldValue = new StringBuilder(this.fieldValue);
            }
            if (this.tokenPos > 0) {
                this.xml.position(this.tokenPos);
                this.xml.compact();
                this.tokenPos = 0;
            }
            int pos = this.xml.position();
            charsRead = this.reader.read(this.xml.array(), this.xml.arrayOffset() + pos, this.xml.remaining());
            if (charsRead < 0) {
                charsRead = 0;
                this.reader = null;
            }
            if (pos + charsRead < this.xml.limit()) {
                this.xml.limit(this.xml.position() + charsRead);
                this.reader = null;
            }
        }
        return charsRead;
    }

    protected void storeToken() throws IDocParseException {
        if (this.escapedTag) {
            if (this.tagBuffer == null) {
                this.tagBuffer = new StringBuilder(30);
            }
            this.tagBuffer.setLength(0);
            char[] c = this.xml.array();
            int tokenStart = this.xml.arrayOffset() + this.tokenPos;
            int tokenEnd = this.xml.arrayOffset() + this.xml.position() - 1;
            int cp = 0;
            for (int i = tokenStart; i < tokenEnd; ++i) {
                if (this.format == IDocXMLFormat.SAP_RELEASE_610) {
                    if (c[i] == '_') {
                        if (++i == tokenEnd || c[i] != '-') {
                            --i;
                            this.tagBuffer.append('_');
                            continue;
                        }
                        if (++i == tokenEnd || c[i] != '-') {
                            --i;
                            this.tagBuffer.append('/');
                            continue;
                        }
                        if (++i == tokenEnd || !XMLChar.isHexDigit(c[i])) {
                            --i;
                            this.tagBuffer.append('/');
                            this.tagBuffer.append('-');
                            continue;
                        }
                        cp = XMLChar.isBasicLatinDigit(c[i]) ? c[i] - 48 << 4 : (XMLChar.isBasicLatinCapitalLetter(c[i]) ? 10 + c[i] - 65 << 4 : 10 + c[i] - 97 << 4);
                        if (++i == tokenEnd || !XMLChar.isHexDigit(c[i])) {
                            this.tagBuffer.append('/');
                            this.tagBuffer.append('-');
                            this.tagBuffer.append(c[--i]);
                            continue;
                        }
                        cp = XMLChar.isBasicLatinDigit(c[i]) ? (cp += c[i] - 48) : (XMLChar.isBasicLatinCapitalLetter(c[i]) ? (cp += 10 + c[i] - 65) : (cp += 10 + c[i] - 97));
                        this.tagBuffer.append((char)cp);
                        continue;
                    }
                } else if (this.format == IDocXMLFormat.SAP_RELEASE_46) {
                    if (c[i] == '-' || i == tokenStart && c[i] == '_') {
                        this.tagBuffer.append('/');
                        continue;
                    }
                } else {
                    if (c[i] == '_') {
                        if (++i == tokenEnd || c[i] != '-') {
                            --i;
                            this.tagBuffer.append('_');
                            continue;
                        }
                        this.format = IDocXMLFormat.SAP_RELEASE_610;
                        if (++i == tokenEnd || c[i] != '-') {
                            --i;
                            this.tagBuffer.append('/');
                            continue;
                        }
                        i -= 3;
                        continue;
                    }
                    if (c[i] == '-') {
                        this.format = IDocXMLFormat.SAP_RELEASE_46;
                        if (this.tagBuffer.charAt(0) == '_') {
                            this.tagBuffer.setCharAt(0, '/');
                        }
                        this.tagBuffer.append('/');
                        continue;
                    }
                }
                this.tagBuffer.append(c[i]);
            }
            this.escapedTag = false;
            this.token = this.tagBuffer;
            return;
        }
        if (this.escapedValue) {
            if (this.valueBuffer == null) {
                this.valueBuffer = new StringBuilder(125);
            }
            this.valueBuffer.setLength(0);
            char[] c = this.xml.array();
            int tokenEnd = this.xml.arrayOffset() + this.xml.position() - 1;
            int cp = 0;
            int ampPos = 0;
            int entityPos = 0;
            String entityName = null;
            String entityValue = null;
            for (int i = this.xml.arrayOffset() + this.tokenPos; i < tokenEnd; ++i) {
                if (c[i] == '&') {
                    ampPos = i++;
                    if (i == tokenEnd) {
                        this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                        throw this.newIDocParseException();
                    }
                    if (c[i] == '#') {
                        if (++i == tokenEnd) {
                            this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                            throw this.newIDocParseException();
                        }
                        if (c[i] == 'x') {
                            cp = 0;
                            ++i;
                            while (c[i] != ';') {
                                if (i == tokenEnd || !XMLChar.isHexDigit(c[i])) {
                                    this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                                    throw this.newIDocParseException();
                                }
                                cp = XMLChar.isBasicLatinDigit(c[i]) ? (cp << 4) + c[i] - 48 : (XMLChar.isBasicLatinCapitalLetter(c[i]) ? (cp << 4) + 10 + c[i] - 65 : (cp << 4) + 10 + c[i] - 97);
                                ++i;
                            }
                            if ((this.xmlVersion == 10 && XMLChar.isInvalidV10(cp) || XMLChar.isInvalid(cp)) && (this.options & 4) == 0) {
                                this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                                throw this.newIDocParseException();
                            }
                            this.valueBuffer.appendCodePoint(cp);
                            continue;
                        }
                        if (XMLChar.isDecDigit(c[i])) {
                            cp = c[i] - 48;
                            ++i;
                            while (c[i] != ';') {
                                if (i == tokenEnd || !XMLChar.isDecDigit(c[i])) {
                                    this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                                    throw this.newIDocParseException();
                                }
                                cp = cp * 10 + c[i] - 48;
                                ++i;
                            }
                            if ((this.xmlVersion == 10 && XMLChar.isInvalidV10(cp) || XMLChar.isInvalid(cp)) && (this.options & 4) == 0) {
                                this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                                throw this.newIDocParseException();
                            }
                            this.valueBuffer.appendCodePoint(cp);
                            continue;
                        }
                        this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                        throw this.newIDocParseException();
                    }
                    if (XMLChar.isNameStartChar(c[i])) {
                        entityPos = i++;
                        while (c[i] != ';') {
                            if (i == tokenEnd || !XMLChar.isNameChar(c[i])) {
                                this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                                throw this.newIDocParseException();
                            }
                            ++i;
                        }
                        entityName = new String(c, entityPos, i - entityPos);
                        entityValue = defaultEntities.get(entityName);
                        if (entityValue == null) {
                            this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                            throw this.newIDocParseException(new StringBuffer(110).append("Invalid XML ").append(this.xmlVersion / 10).append('.').append(this.xmlVersion % 10).append(" entity '").append(entityName).append("' encountered within IDocXML for type <").append(this.openTags.getFirst()).append('>').toString(), null);
                        }
                        this.valueBuffer.append(entityValue);
                        continue;
                    }
                    this.xml.position(ampPos - this.xml.arrayOffset() + 1);
                    throw this.newIDocParseException();
                }
                this.valueBuffer.append(c[i]);
            }
            this.escapedValue = false;
            this.token = this.valueBuffer;
            return;
        }
        int currentPos = this.xml.position();
        this.xml.position(this.tokenPos);
        this.token = this.xml.subSequence(0, currentPos - this.tokenPos - 1);
        this.xml.position(currentPos);
    }

    static {
        ArrayList<String> attribValues = new ArrayList<String>(1);
        attribValues.add(STR_1);
        iDocAttributes.put(STR_BEGIN, attribValues);
        segmentAttributes = new LinkedHashMap(3);
        attribValues = new ArrayList(1);
        attribValues.add(STR_1);
        segmentAttributes.put(STR_SEGMENT, attribValues);
        xmlDeclAttribNames = new ArrayList(3);
        xmlDeclAttribNames.add(STR_VERSION);
        xmlDeclAttribNames.add(STR_ENCODING);
        xmlDeclAttribNames.add(STR_STANDALONE);
        defaultEntities = new HashMap(11);
        defaultEntities.put("amp", "&");
        defaultEntities.put("lt", "<");
        defaultEntities.put("gt", ">");
        defaultEntities.put("apos", "'");
        defaultEntities.put("quot", "\"");
    }

    private static final class IDocControlRecord
    extends DefaultIDocDocument {
        static final long serialVersionUID = 1000L;

        IDocControlRecord() {
            super(DefaultIDocXMLParser.STR_EDI_DC40);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        READING_IDOCTYPE,
        READING_IDOC,
        READING_IDOC_STARTTAG,
        READING_CONTROLRECORD,
        READING_CONTROLRECORD_STARTTAG,
        READING_SEGMENT,
        READING_SEGMENT_STARTTAG,
        READING_FIELD,
        READING_FIELD_STARTTAG,
        READING_ATTRIBUTE,
        READING_ATTRIBUTE_VALUE,
        READING_FIELD_VALUE,
        READING_FIELD_VALUE_TAG,
        READING_FIELD_CDATA_START,
        READING_FIELD_CDATA_VALUE,
        READING_ENDTAG,
        EXPECTING_TAG_END,
        EXPECTING_IMMEDIATE_TAG_END,
        READING_PROLOG,
        READING_MISCELLANEOUS,
        OPENED_FIRST_TAG,
        OPENED_PROLOG_TAG,
        READING_FIRST_TARGETNAME,
        READING_PI_TARGETNAME,
        READING_XMLDECLARATION,
        READING_ENCODING_VALUE,
        READING_PROCESSINGINSTRUCTION,
        READING_MARKUPDECLARATION,
        READING_COMMENT,
        EXPECTING_PROLOG_END,
        SKIPPING_DTD;

    }
}

