/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.jco.rt;

import com.sap.conn.idoc.IDocConversionException;
import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocFieldNotFoundException;
import com.sap.conn.idoc.IDocRecordMetaData;
import com.sap.conn.idoc.IDocRuntimeException;
import com.sap.conn.idoc.IDocSegment;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.IDocSyntaxException;
import com.sap.conn.idoc.rt.DefaultIDocRuntime;
import com.sap.conn.idoc.rt.DefaultIDocSegment;
import com.sap.conn.idoc.rt.cp.I18NConverters;
import com.sap.conn.idoc.rt.trace.Trace;
import com.sap.conn.idoc.rt.util.Utils;
import com.sap.i18n.cp.ConvertCToX;
import java.io.UnsupportedEncodingException;

public class JCoIDocSegment
extends DefaultIDocSegment {
    static final long serialVersionUID = 1000L;

    protected JCoIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        super(document, segmentMetaData, checkFieldValuesOnSet);
    }

    protected JCoIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, byte[] sData, String sDataCharset) throws IDocConversionException, IDocSyntaxException {
        super(document, segmentMetaData, checkFieldValuesOnSet, sData, sDataCharset);
    }

    protected JCoIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, String sData) {
        super(document, segmentMetaData, checkFieldValuesOnSet, sData);
    }

    protected static void copyDataToByteArray(IDocSegment segment, char[] dest, int destOffset, int destLength, String charEncoding) {
        if (segment == null || dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        IDocRecordMetaData recordMetaData = segment.getRecordMetaData();
        if (recordMetaData == null) {
            return;
        }
        int destEndOffset = destOffset + destLength;
        if (destEndOffset > dest.length) {
            destEndOffset = dest.length;
        }
        ConvertCToX converter = null;
        String field = null;
        char[] fieldChars = null;
        byte[] spaces = null;
        byte[] value = null;
        int numFields = recordMetaData.getNumFields();
        int metaLength = 0;
        int metaOffset = 0;
        int offset = 0;
        int destBytes = 0;
        int numBytes = 0;
        int b = 0;
        int v = 0;
        int s = 0;
        if (charEncoding != null) {
            converter = I18NConverters.getConvertCToX(charEncoding);
            if (converter != null) {
                spaces = converter.ConvertArr(DefaultIDocRuntime.SPACE_CHARARRAY, 0, DefaultIDocRuntime.SPACE_CHARARRAY.length);
            } else if (charEncoding.equals(Utils.getSystemDefaultCharEncoding())) {
                charEncoding = null;
            } else {
                try {
                    spaces = "                                ".getBytes(charEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    charEncoding = null;
                }
            }
        }
        try {
            if (spaces == null) {
                spaces = "                                ".getBytes();
            }
            for (int i = 0; i < numFields; ++i) {
                field = segment.getString(recordMetaData.getName(i));
                metaLength = recordMetaData.getOutputLength(i);
                metaOffset = recordMetaData.getOffset(i);
                offset = destOffset + (metaOffset >> 1);
                b = metaOffset & 1;
                if (i + 1 < numFields) {
                    destBytes = recordMetaData.getOffset(i + 1) - metaOffset;
                    if (destBytes >= (destEndOffset - offset << 1) - b) {
                        destBytes = (destEndOffset - offset << 1) - b;
                        i = numFields;
                    }
                } else {
                    destBytes = (destEndOffset - offset << 1) - b;
                }
                if (field != null) {
                    if (converter != null) {
                        fieldChars = field.toCharArray();
                        value = converter.ConvertArr(fieldChars, 0, fieldChars.length);
                    } else {
                        value = charEncoding != null ? field.getBytes(charEncoding) : field.getBytes();
                    }
                    numBytes = value.length;
                    if (metaLength > destBytes) {
                        metaLength = destBytes;
                    }
                    if (numBytes > metaLength) {
                        numBytes = metaLength;
                    }
                    for (v = 0; v < numBytes; ++v) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((value[v] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                    }
                } else {
                    v = 0;
                }
                while (v < destBytes) {
                    for (s = 0; v < destBytes && s < spaces.length; ++s, ++v) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((spaces[s] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                    }
                }
            }
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
        catch (UnsupportedEncodingException ex) {
            Trace.fireTraceCritical("missing standard java char converter", ex);
            throw new IDocRuntimeException("missing standard java char converter", ex);
        }
    }

    protected static void copyDataToCharArray(IDocSegment segment, char[] dest, int destOffset, int destLength) {
        if (segment == null || dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        IDocRecordMetaData recordMetaData = segment.getRecordMetaData();
        if (recordMetaData == null) {
            return;
        }
        int destEndOffset = destOffset + destLength;
        if (destEndOffset > dest.length) {
            destEndOffset = dest.length;
        }
        String field = null;
        int numFields = recordMetaData.getNumFields();
        int metaLength = 0;
        int metaOffset = 0;
        int offset = 0;
        int endOffset = 0;
        int numChars = 0;
        try {
            for (int i = 0; i < numFields; ++i) {
                field = segment.getString(recordMetaData.getName(i));
                metaLength = recordMetaData.getLength(i);
                metaOffset = recordMetaData.getOffset(i);
                offset = destOffset + metaOffset;
                if (i + 1 < numFields) {
                    endOffset = destOffset + recordMetaData.getOffset(i + 1);
                    if (endOffset >= destEndOffset) {
                        endOffset = destEndOffset;
                        i = numFields;
                    }
                } else {
                    endOffset = destEndOffset;
                }
                if (field != null) {
                    numChars = field.length();
                    if (offset + metaLength > endOffset) {
                        metaLength = endOffset - offset;
                    }
                    if (numChars > metaLength) {
                        numChars = metaLength;
                    }
                    field.getChars(0, numChars, dest, offset);
                    offset += numChars;
                }
                while (offset < endOffset) {
                    dest[offset++] = 32;
                }
            }
        }
        catch (IDocFieldNotFoundException exc) {
            throw new IDocRuntimeException(exc);
        }
    }

    protected void addChild(DefaultIDocSegment child) {
        super.addChild(child);
    }

    protected void copyDataToByteArray(char[] dest, int destOffset, int destLength, String charEncoding) {
        if (dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        int destEndOffset = destOffset + destLength;
        if (destEndOffset > dest.length) {
            destEndOffset = dest.length;
        }
        ConvertCToX converter = null;
        String field = null;
        char[] fieldChars = null;
        byte[] spaces = null;
        byte[] value = null;
        int numFields = this.recordMetaData.getNumFields();
        int metaLength = 0;
        int metaOffset = 0;
        int offset = 0;
        int destBytes = 0;
        int numBytes = 0;
        int b = 0;
        int v = 0;
        int s = 0;
        if (charEncoding != null) {
            converter = I18NConverters.getConvertCToX(charEncoding);
            if (converter != null) {
                spaces = converter.ConvertArr(DefaultIDocRuntime.SPACE_CHARARRAY, 0, DefaultIDocRuntime.SPACE_CHARARRAY.length);
            } else if (charEncoding.equals(Utils.getSystemDefaultCharEncoding())) {
                charEncoding = null;
            } else {
                try {
                    spaces = "                                ".getBytes(charEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    charEncoding = null;
                }
            }
        }
        if (spaces == null) {
            spaces = "                                ".getBytes();
        }
        try {
            for (int i = 0; i < numFields; ++i) {
                field = this.getString(i);
                metaLength = this.recordMetaData.getOutputLength(i);
                metaOffset = this.recordMetaData.getOffset(i);
                offset = destOffset + (metaOffset >> 1);
                b = metaOffset & 1;
                if (i + 1 < numFields) {
                    destBytes = this.recordMetaData.getOffset(i + 1) - metaOffset;
                    if (destBytes >= (destEndOffset - offset << 1) - b) {
                        destBytes = (destEndOffset - offset << 1) - b;
                        i = numFields;
                    }
                } else {
                    destBytes = (destEndOffset - offset << 1) - b;
                }
                if (field != null) {
                    if (converter != null) {
                        fieldChars = field.toCharArray();
                        value = converter.ConvertArr(fieldChars, 0, fieldChars.length);
                    } else {
                        value = charEncoding != null ? field.getBytes(charEncoding) : field.getBytes();
                    }
                    numBytes = value.length;
                    if (metaLength > destBytes) {
                        metaLength = destBytes;
                    }
                    if (numBytes > metaLength) {
                        numBytes = metaLength;
                    }
                    for (v = 0; v < numBytes; ++v) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((value[v] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                    }
                } else {
                    v = 0;
                }
                while (v < destBytes) {
                    for (s = 0; v < destBytes && s < spaces.length; ++s, ++v) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((spaces[s] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                    }
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            Trace.fireTraceCritical("missing standard java char converter", ex);
            throw new IDocRuntimeException("missing standard java char converter", ex);
        }
    }

    protected void copyDataToCharArray(char[] dest, int destOffset, int destLength) {
        if (dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        if (destOffset + destLength > dest.length) {
            destLength = dest.length - destOffset;
        }
        int destEndOffset = destOffset + destLength;
        int numChars = this.data.length;
        if (numChars > destLength) {
            numChars = destLength;
        }
        char[] dataBuffer = this.getRawBuffer();
        System.arraycopy(dataBuffer, 0, dest, destOffset, numChars);
        destOffset += numChars;
        while (destOffset < destEndOffset) {
            dest[destOffset++] = 32;
        }
    }

    protected DefaultIDocSegment createDefaultIDocSegment(IDocDocument document, IDocSegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
        return new JCoIDocSegment(document, segmentMetaData, checkFieldValuesOnSet);
    }

    protected void removeFromDocument() {
        super.removeFromDocument();
    }
}

