/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocDocument;
import com.sap.conn.idoc.IDocDocumentIterator;
import com.sap.conn.idoc.IDocDocumentList;
import java.util.NoSuchElementException;

public class DocumentIterator
implements IDocDocumentIterator {
    protected IDocDocumentList m_documentList = null;
    protected IDocDocument m_currentDocument = null;
    protected IDocDocument m_nextDocument = null;

    public DocumentIterator(IDocDocumentList documentList) {
        if (documentList == null) {
            return;
        }
        this.m_documentList = documentList;
        this.m_nextDocument = documentList.first();
    }

    public boolean hasNext() {
        if (this.m_nextDocument != null) {
            return true;
        }
        if (this.m_currentDocument == null) {
            return false;
        }
        this.m_nextDocument = this.m_documentList.getNext(this.m_currentDocument);
        return this.m_nextDocument != null;
    }

    public IDocDocument next() {
        if (this.hasNext()) {
            this.m_currentDocument = this.m_nextDocument;
            this.m_nextDocument = null;
            return this.m_currentDocument;
        }
        this.m_currentDocument = null;
        throw new NoSuchElementException("DocumentIterator.nextDocument()");
    }

    public void remove() {
        if (this.m_currentDocument == null) {
            throw new IllegalStateException("DocumentIterator.remove()");
        }
        this.m_nextDocument = this.m_documentList.getNext(this.m_currentDocument);
        this.m_documentList.remove(this.m_currentDocument);
        this.m_currentDocument = null;
    }
}

