/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.regex.Pattern;
import org.jboss.errai.classhider.internal.asm.ClassWriter;
import org.jboss.errai.classhider.internal.asm.Label;
import org.jboss.errai.classhider.internal.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoringClassGenerator
implements ClassFileTransformer {
    private final Pattern hiddenClassNamePattern;
    private final boolean debug;

    public BoringClassGenerator(Pattern hiddenClassNamePattern, boolean debug) {
        this.hiddenClassNamePattern = hiddenClassNamePattern;
        this.debug = debug;
        if (debug) {
            System.out.println("client-local-class-hider: hiding classes that match the regular expression: " + hiddenClassNamePattern);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!this.hiddenClassNamePattern.matcher(className).matches()) {
            if (this.debug) {
                System.out.println("client-local-class-hider: not hiding " + className);
            }
            return null;
        }
        if (this.debug) {
            System.out.println("client-local-class-hider: hiding " + className);
        }
        ClassWriter cw = new ClassWriter(0);
        cw.visit(49, 33, className, null, "java/lang/Object", null);
        cw.visitSource("FakeClass__GENERATED_BY_JBoss_ClientLocalClassHider.java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(15, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + className + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

