// This code is taken from WSO2 Carbon and is licensed by WSO2, Inc.
// under the Apache License version 2.0 http://www.apache.org/licenses/LICENSE-2.0.html
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.apache.axiom.om.OMElement;

public class CompensationHandlerImpl extends SequenceImpl implements org.wso2.carbon.bpel.ui.bpel2svg.CompensationHandlerInterface {
    public CompensationHandlerImpl(String token) {
        super(token);

        name = "COMPENSATIONHANDLER" + System.currentTimeMillis();
        displayName = "Compensation Handler";

        // Set Icon and Size
        startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public CompensationHandlerImpl(OMElement omElement) {
        super(omElement);

        name = "COMPENSATIONHANDLER" + System.currentTimeMillis();
        displayName = "Compensation Handler";

        // Set Icon and Size
        startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }
    
    public CompensationHandlerImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        setParent(parent);
        name = "COMPENSATIONHANDLER" + System.currentTimeMillis();
        displayName = "Compensation Handler";

        // Set Icon and Size
        startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    @Override
    public String getEndTag() {
        return org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory.COMPENSATIONHANDLER_END_TAG;
    }

}
