<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
   xmlns:olc="urn:jboss:domain:overlord-configuration:1.0"
   exclude-result-prefixes="olc">

  <xsl:param name="client-username" />
  <xsl:param name="client-password" />
  <xsl:output xmlns:xalan="http://xml.apache.org/xalan" method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />

<xsl:template match="@*|node()">
   <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
</xsl:template>

<xsl:template match="olc:property[@name='RESTActivityServer.serverUsername']">
   <property xmlns="urn:jboss:domain:overlord-configuration:1.0" name="RESTActivityServer.serverUsername">
      <xsl:attribute name="value">
         <xsl:value-of select="$client-username"/>
      </xsl:attribute>
      <xsl:apply-templates select="@*[not(name()='value')] | node()"/>
   </property>
</xsl:template>

<xsl:template match="olc:property[@name='RESTActivityServer.serverPassword']">
   <property xmlns="urn:jboss:domain:overlord-configuration:1.0" name="RESTActivityServer.serverPassword">
      <xsl:attribute name="value">
         <xsl:text>${vault:</xsl:text>
         <xsl:value-of select="$client-password"/>
         <xsl:text>}</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates select="@*[not(name()='value')] | node()"/>
  </property>
</xsl:template>

</xsl:stylesheet>
