<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
      xmlns:ns7="urn:jboss:domain:overlord-configuration:1.0"
      xmlns:ns9="urn:jboss:domain:overlord-configuration:1.0">

  <xsl:param name="keystore-password" />
  <xsl:param name="key-password" />
  <xsl:output xmlns:xalan="http://xml.apache.org/xalan" method="xml" encoding="UTF-8" indent="yes" xalan:indent-amount="2" />

<xsl:template match="@*|node()">
   <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
   </xsl:copy>
</xsl:template>

<xsl:template match="ns7:property[@name='overlord.auth.saml-keystore-password']">
   <ns7:property xmlns:ns7="urn:jboss:domain:overlord-configuration:1.0" name="overlord.auth.saml-keystore-password">
      <xsl:attribute name="value">
         <xsl:text>${vault:</xsl:text>
         <xsl:value-of select="$keystore-password"/>
         <xsl:text>}</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates select="@*[not(name()='value')] | node()"/>
   </ns7:property>
</xsl:template>

<xsl:template match="ns9:property[@name='overlord.auth.saml-key-alias-password']">
   <ns9:property xmlns:ns9="urn:jboss:domain:overlord-configuration:1.0" name="overlord.auth.saml-key-alias-password">
      <xsl:attribute name="value">
         <xsl:text>${vault:</xsl:text>
         <xsl:value-of select="$key-password"/>
         <xsl:text>}</xsl:text>
      </xsl:attribute>
      <xsl:apply-templates select="@*[not(name()='value')] | node()"/>
  </ns9:property>
</xsl:template>

</xsl:stylesheet>
