create table RTGOV_ACTIVITIES (
    activityType varchar2(31 char) not null,
    unitId varchar2(255 char) not null,
    unitIndex number(10,0) not null,
    principal varchar2(255 char),
    tstamp number(19,0) not null,
    customType varchar2(255 char),
    logLevel number(10,0),
    message varchar2(255 char),
    instanceId varchar2(255 char),
    processType varchar2(255 char),
    status number(10,0),
    version varchar2(255 char),
    variableName varchar2(255 char),
    variableType varchar2(255 char),
    variableValue varchar2(255 char),
    content clob,
    messageType varchar2(255 char),
    destination varchar2(255 char),
    fault varchar2(255 char),
    interface varchar2(255 char),
    operation varchar2(255 char),
    serviceType varchar2(255 char),
    replyToId varchar2(255 char),
    primary key (unitId, unitIndex)
);

create table RTGOV_ACTIVITY_CONTEXT (
    unitId varchar2(255 char) not null,
    unitIndex number(10,0) not null,
    timeframe number(19,0),
    contextType varchar2(255 char),
    value varchar2(255 char)
);

create table RTGOV_ACTIVITY_PROPERTIES (
    unitId varchar2(255 char) not null,
    unitIndex number(10,0) not null,
    value varchar2(4000 char),
    name varchar2(255 char) not null,
    primary key (unitId, unitIndex, name)
);

create table RTGOV_ACTIVITY_UNITS (
    id varchar2(255 char) not null,
    host varchar2(255 char),
    node varchar2(255 char),
    principal varchar2(255 char),
    thread varchar2(255 char),
    primary key (id)
);

create table RTGOV_SITUATIONS (
    id varchar2(255 char) not null,
    description clob,
    severity number(10,0),
    subject varchar2(255 char),
    tstamp number(19,0) not null,
    situationType varchar2(255 char),
    primary key (id)
);

create table RTGOV_SITUATION_ACTIVITY_TYPES (
    Situation_id varchar2(255 char) not null,
    unitId varchar2(255 char),
    unitIndex number(10,0) not null,
    primary key (Situation_id, unitIndex)
);

create table RTGOV_SITUATION_CONTEXT (
    Situation_id varchar2(255 char) not null,
    timeframe number(19,0),
    contextType varchar2(255 char),
    value varchar2(255 char)
);

create table RTGOV_SITUATION_PROPERTIES (
    id varchar2(255 char) not null,
    value varchar2(4000 char),
    name varchar2(255 char) not null,
    primary key (id, name)
);

alter table RTGOV_ACTIVITIES
    add constraint FK_qkn2182qh2hf52txyugoloqaq
    foreign key (unitId)
    references RTGOV_ACTIVITY_UNITS;

alter table RTGOV_ACTIVITY_CONTEXT
    add constraint FK_taqus05muupkc8xuuyig97lx7
    foreign key (unitId, unitIndex)
    references RTGOV_ACTIVITIES;

alter table RTGOV_ACTIVITY_PROPERTIES
    add constraint FK_c5src0indd1kbiljcs7ruf2rc
    foreign key (unitId, unitIndex)
    references RTGOV_ACTIVITIES;

alter table RTGOV_SITUATION_ACTIVITY_TYPES
    add constraint FK_l3yoqst9iu0euiw0vo2b5t5yu
    foreign key (Situation_id)
    references RTGOV_SITUATIONS;

alter table RTGOV_SITUATION_CONTEXT
    add constraint FK_b08bon7ya4r67qlm24alhqdpg
    foreign key (Situation_id)
    references RTGOV_SITUATIONS;

alter table RTGOV_SITUATION_PROPERTIES
    add constraint FK_js9tml3lmnlrl38etv7mouwox
    foreign key (id)
    references RTGOV_SITUATIONS;
