## fabric8:apply

The maven `fabric8:apply` goal takes the JSON file generated via [mvn fabric8:json](mavenFabric8Json.html) located at `target/classes/kubernetes.json` and applies it to the current Kubernetes environment and namespace. 

For a summary of the options see the [Maven Property Reference](#maven-properties)

### Prerequisites

Note that before trying to apply your Kubernetes JSON you need to make sure your docker image is available to Kubernetes. See the [mvn docker:build](mavenDockerBuild.html) and [mvn docker:push](mavenDockerPush.html) goals. 

Also if you are using a local docker registry, make sure it is network accessible to your Kubernetes cluster.

### Creating Routes

You can use the maven property `fabric8.domain` or the environment variable `$KUBERNETES_DOMAIN` to define the DNS host to expose services automatically using [OpenShift Routes](http://docs.openshift.org/latest/admin_guide/router.html)

### Default Configuration

The Kubernetes environment and authentication is defined by the [kubernetes-api environment variables](https://github.com/fabric8io/fabric8/tree/master/components/kubernetes-api#configuration). In particular:

* `KUBERNETES_MASTER` - the location of the kubernetes master
* `KUBERNETES_NAMESPACE` - the default namespace used on operations

#### Defaults from OpenShift

If no configuration is supplied through maven properties or environment variables, the `fabric8:apply` goal will try to find the current login token and namespace by parsing the users `~/.kube/config` file.

This means that if you use the [OpenShift](http://www.openshift.org/) command line tool `oc` you can login and change projects (namespaces in kubernetes speak) and those will be used by default by the `fabric8:apply` goal. e.g.

```
oc login
oc project cheese
mvn fabric8:apply
```

In the above, if there is no `KUBERNETES_NAMESPACE` environment variable or maven property called `fabric8.namespace` then the `fabric8:apply` goal will apply the Kubernetes resources to the `cheese` namespace.

## Example

To apply the kubernetes resources generated by the [mvn fabric8:json](mavenFabric8Json.html) goal use the following goal:

    mvn fabric8:apply

To specify an explicit namespace and domain in recreate mode:

    mvn fabric8:apply -Dfabric8.recreate=true \
    -Dfabric8.domain=foo.acme.com -Dfabric8.namespace=cheese   


## Specifying environments and namespaces

You can use the `fabric8.namespace` system property to explicitly specify the kubernetes namespace to apply things to...

    mvn fabric8:rolling -Dfabric8.namespace=cheese
    
Or you can use the `fabric8.environment` system property to refer to a named environment such as `Testing`, `Staging` or `Production` which is then mapped to the physical namespace by using the [fabric8.yml file](fabric8YamlFile.html).

    mvn fabric8:rolling -Dfabric8.environment=Staging

This lets you keep a level of indirection between the logical environment names for a project and the physical namespaces in kubernetes which probably have team or user prefixes/postfixes. This lets you share the same Jenkinsfiles (Jenkins workflow groovy scripts) across different projects. 

e.g. you can have a standard command to apply to the Staging environment and this can be applied to any project which has a `fabric8.yml` file generated.    
    
### Templates

Applying an [OpenShift template](http://docs.openshift.org/latest/dev_guide/templates.html) works the same as a regular `List` of Kubernetes resources. 

One difference is that you may wish to override some of the template parameter values as you apply the template which you can do on the command line via system properties.

    mvn fabric8:apply -Dfabric8.apply.FOO=bar
    
The above will apply the OpenShift template defined in `target/classes/kubernetes.json` overriding the template parameter `FOO` with the value `bar` before processing the template and creating/updating the resources.

### Maven Properties

The following maven property values are used to configure the behaviour of the apply goal:

You define the maven properties in the `pom.xml` file using the `<properties>` tag such as:

```
    <properties>
      <fabric8.label.container>java</fabric8.label.container>
      <fabric8.label.group>myapp</fabric8.label.group>
      <fabric8.iconRef>camel</fabric8.iconRef>
    </properties>
```

If you wish to override or add a property from the command line, you can do this by using Java JVM system properties. A property from the command line will override any existing option configured in the `pom.xml` file.

    mvn fabric8:apply -Dfabric8.recreate=true
    
There are many options as listed in the following table:

<table class="table table-striped">
<tr>
<th>Parameter</th>
<th>Description</th>
</tr>
<tr>
<td>fabric8.apply.create</td>
<td>Should we create new resources (not in the kubernetes namespace). Defaults to <code>true</code>.</td>
</tr>
<tr>
<td>fabric8.apply.servicesOnly</td>
<td>Should only services be processed. This lets you run 2 builds, process the services only first; then process non-services. Defaults to <code>false</code>.</td>
</tr>
<tr>
<td>fabric8.apply.ignoreServices</td>
<td>Ignore any services in the JSON. This is useful if you wish to recreate all the ReplicationControllers and Pods but not recreate Services (which can cause <code>ClusterIP</code> addresses to change for services which can break some Pods and could cause problems for load balancers. Defaults to <code>false</code>.</td>
</tr>
<tr>
<td>fabric8.apply.createRoutes</td>
<td>If there is a route domain (see <code>fabric8.domain</code>) then this option will create an <a href="http://docs.openshift.org/latest/admin_guide/router.html">OpenShift Route</a> for each service for the host expressio: <code>${serviceName}.${fabric8.domain}</code>. Defaults to <code>true</code>.</td>
</tr>
<tr>
<td>fabric8.domain</td>
<td>The domain to expose the services as <a href="http://docs.openshift.org/latest/admin_guide/router.html">OpenShift Routes</a>. Defaults to <code>$KUBERNETES_DOMAIN</code>.</td>
</tr>
<tr>
<td>fabric8.extended.environment.metadata</td>
<td>Whether to try to fetch extended environment metadata during the json, or apply goals. The following ENV variables is supported: <tt>BUILD_URI</tt>, <tt>GIT_URL</tt>, <tt>GIT_COMMIT</tt>, <tt>GIT_BRANCH</tt>
    If any of these ENV variable is empty then if this option is enabled, then the value is attempted to be fetched from an online connection to the Kubernetes master. If the connection fails then the goal will report this as a failure gently and continue.
    This option can be turned off, to avoid any live connection to the Kubernetes master.
</td>
</tr>
<tr>
<td>fabric8.namespace</td>
<td>Specifies the namespace (or OpenShift project name) to apply the kubernetes resources to. If not specified it will use the <code>KUBERNETES_NAMESPACE</code> environment variable or use the <a href="#defaults-from-openshift">Defaults from OpenShift</a></td>
</tr>
<tr>
<td>fabric8.recreate</td>
<td>If enabled then all resources that are found are deleted first before being recreated. Defaults to <code>false</code>.</td>
</tr>
</table>

