// This file was automatically generated by lister-gen

package internalversion

import (
	oauth "github.com/openshift/origin/pkg/oauth/apis/oauth"
	"k8s.io/apimachinery/pkg/api/errors"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// OAuthAccessTokenLister helps list OAuthAccessTokens.
type OAuthAccessTokenLister interface {
	// List lists all OAuthAccessTokens in the indexer.
	List(selector labels.Selector) (ret []*oauth.OAuthAccessToken, err error)
	// Get retrieves the OAuthAccessToken from the index for a given name.
	Get(name string) (*oauth.OAuthAccessToken, error)
	OAuthAccessTokenListerExpansion
}

// oAuthAccessTokenLister implements the OAuthAccessTokenLister interface.
type oAuthAccessTokenLister struct {
	indexer cache.Indexer
}

// NewOAuthAccessTokenLister returns a new OAuthAccessTokenLister.
func NewOAuthAccessTokenLister(indexer cache.Indexer) OAuthAccessTokenLister {
	return &oAuthAccessTokenLister{indexer: indexer}
}

// List lists all OAuthAccessTokens in the indexer.
func (s *oAuthAccessTokenLister) List(selector labels.Selector) (ret []*oauth.OAuthAccessToken, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*oauth.OAuthAccessToken))
	})
	return ret, err
}

// Get retrieves the OAuthAccessToken from the index for a given name.
func (s *oAuthAccessTokenLister) Get(name string) (*oauth.OAuthAccessToken, error) {
	key := &oauth.OAuthAccessToken{ObjectMeta: v1.ObjectMeta{Name: name}}
	obj, exists, err := s.indexer.Get(key)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(oauth.Resource("oauthaccesstoken"), name)
	}
	return obj.(*oauth.OAuthAccessToken), nil
}
